/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.logback.extensions;

import ch.qos.logback.core.pattern.ReplacingCompositeConverter;
import java.util.List;
import java.util.regex.Pattern;

public class ExtendedReplacingCompositeConverter<E>
extends ReplacingCompositeConverter<E> {
    private Pattern pattern;
    private String replacement;

    public void start() {
        List optionList = this.getOptionList();
        if (optionList == null) {
            this.addError("at least two options are expected whereas you have declared none");
            return;
        }
        int numOpts = optionList.size();
        if (numOpts < 2) {
            this.addError("at least two options are expected whereas you have declared only " + numOpts + "as [" + optionList + "]");
            return;
        }
        this.pattern = Pattern.compile((String)optionList.get(0));
        this.replacement = ((String)optionList.get(1)).replaceAll("%n|(\\\\r)?\\\\n", System.getProperty("line.separator"));
        super.start();
    }

    protected String transform(E event, String in) {
        if (!this.started) {
            return in;
        }
        return this.pattern.matcher(in).replaceAll(this.replacement);
    }
}

