/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.workqueue;

import javax.management.JMException;
import javax.management.ObjectName;
import org.apache.cxf.Bus;
import org.apache.cxf.management.ManagedComponent;
import org.apache.cxf.management.annotation.ManagedOperation;
import org.apache.cxf.management.annotation.ManagedResource;
import org.apache.cxf.workqueue.WorkQueueManagerImpl;

@ManagedResource(componentName="WorkQueueManager", description="The CXF manangement of work queues ", currencyTimeLimit=15, persistPolicy="OnUpdate", persistPeriod=200)
public class WorkQueueManagerImplMBeanWrapper
implements ManagedComponent {
    static final String NAME_VALUE = "Bus.WorkQueueManager";
    static final String TYPE_VALUE = "WorkQueueManager";
    private WorkQueueManagerImpl wqManager;
    private Bus bus;

    public WorkQueueManagerImplMBeanWrapper(WorkQueueManagerImpl wq) {
        this.wqManager = wq;
        this.bus = wq.getBus();
    }

    @ManagedOperation(currencyTimeLimit=30)
    public void shutdown(boolean processRemainingWorkItems) {
        this.wqManager.shutdown(processRemainingWorkItems);
    }

    public ObjectName getObjectName() throws JMException {
        StringBuilder buffer = new StringBuilder();
        buffer.append("org.apache.cxf").append(':');
        buffer.append("bus.id").append('=').append(this.bus.getId()).append(',');
        buffer.append("WorkQueueManager=").append(NAME_VALUE);
        buffer.append(',').append("type").append('=').append(TYPE_VALUE);
        return new ObjectName(buffer.toString());
    }
}

