/**
 * Logback: the reliable, generic, fast and flexible logging framework.
 * Copyright (C) 1999-2013, QOS.ch. All rights reserved.
 *
 * This program and the accompanying materials are dual-licensed under
 * either the terms of the Eclipse Public License v1.0 as published by
 * the Eclipse Foundation
 *
 *   or (per the licensee's choosing)
 *
 * under the terms of the GNU Lesser General Public License version 2.1
 * as published by the Free Software Foundation.
 */

package ch.qos.logback.classic.util;

import java.util.Map;
import org.slf4j.spi.MDCAdapter;

/**
 * {@link LogbackMDCAdapter} - The base MDC adapter class
 *
 * @author Thorben Betten
 */
public abstract class LogbackMDCAdapter implements MDCAdapter {

    private static final String PROPERTY_DUPLICATE_ON_PUT = "logback.threadlocal.put.duplicate";

    private static final boolean duplicateOnPut() {
      try {
        return Boolean.parseBoolean(System.getProperty(PROPERTY_DUPLICATE_ON_PUT, Boolean.TRUE.toString()));
      } catch (Exception e) {
        return true;
      }
    }

    /**
     * Gets the appropriate <code>LogbackMDCAdapter</code> instance.
     *
     * @return The instance
     */
    public static LogbackMDCAdapter getInstance() {
        return duplicateOnPut() ? new DuplicateOnInsertLogbackMDCAdapter() : new ConcurrentLogbackMDCAdapter();
    }

    // ---------------------------------------------------------------------------------

    /**
     * Get the current thread's MDC as a map. This method is intended to be used
     * internally.
     */
    public abstract Map<String, String> getPropertyMap();

}
