/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.util;

import com.hazelcast.core.HazelcastException;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.ClassLoaderUtil;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.util.FilteringClassLoader;
import com.hazelcast.util.ValidationUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public final class ServiceLoader {
    private static final ILogger LOGGER = Logger.getLogger(ServiceLoader.class);
    private static final String FILTERING_CLASS_LOADER = FilteringClassLoader.class.getCanonicalName();

    private ServiceLoader() {
    }

    public static <T> T load(Class<T> clazz, String factoryId, ClassLoader classLoader) throws Exception {
        Iterator<T> iterator = ServiceLoader.iterator(clazz, factoryId, classLoader);
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    public static <T> Iterator<T> iterator(final Class<T> clazz, String factoryId, ClassLoader classLoader) throws Exception {
        List<ClassLoader> classLoaders = ServiceLoader.selectClassLoaders(classLoader);
        HashSet<URLDefinition> factoryUrls = new HashSet<URLDefinition>();
        for (ClassLoader selectedClassLoader : classLoaders) {
            factoryUrls.addAll(ServiceLoader.collectFactoryUrls(factoryId, selectedClassLoader));
        }
        final HashSet<ServiceDefinition> serviceDefinitions = new HashSet<ServiceDefinition>();
        for (URLDefinition urlDefinition : factoryUrls) {
            serviceDefinitions.addAll(ServiceLoader.parse(urlDefinition));
        }
        if (serviceDefinitions.isEmpty()) {
            Logger.getLogger(ServiceLoader.class).warning("Service loader could not load 'META-INF/services/" + factoryId + "' It may be empty or does not exist.");
        }
        return new Iterator<T>(){
            final Iterator<ServiceDefinition> iterator;
            {
                this.iterator = serviceDefinitions.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public T next() {
                ServiceDefinition definition = this.iterator.next();
                try {
                    String className = definition.className;
                    ClassLoader classLoader = definition.classLoader;
                    return clazz.cast(ClassLoaderUtil.newInstance(classLoader, className));
                }
                catch (Exception e) {
                    throw new HazelcastException(e);
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private static Set<URLDefinition> collectFactoryUrls(String factoryId, ClassLoader classLoader) {
        String resourceName = "META-INF/services/" + factoryId;
        try {
            Enumeration<URL> configs = classLoader != null ? classLoader.getResources(resourceName) : ClassLoader.getSystemResources(resourceName);
            HashSet<URLDefinition> urlDefinitions = new HashSet<URLDefinition>();
            while (configs.hasMoreElements()) {
                URL url = configs.nextElement();
                ClassLoader highestClassLoader = ServiceLoader.findHighestReachableClassLoader(url, classLoader, resourceName);
                urlDefinitions.add(new URLDefinition(url, highestClassLoader));
            }
            return urlDefinitions;
        }
        catch (Exception e) {
            LOGGER.severe(e);
            return Collections.emptySet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<ServiceDefinition> parse(URLDefinition urlDefinition) {
        try {
            HashSet<ServiceDefinition> names = new HashSet<ServiceDefinition>();
            BufferedReader r = null;
            try {
                String line;
                URL url = urlDefinition.url;
                r = new BufferedReader(new InputStreamReader(url.openStream(), "UTF-8"));
                while ((line = r.readLine()) != null) {
                    String name;
                    int comment = line.indexOf(35);
                    if (comment >= 0) {
                        line = line.substring(0, comment);
                    }
                    if ((name = line.trim()).length() == 0) continue;
                    names.add(new ServiceDefinition(name, urlDefinition.classLoader));
                }
            }
            catch (Throwable throwable) {
                IOUtil.closeResource(r);
                throw throwable;
            }
            IOUtil.closeResource(r);
            return names;
        }
        catch (Exception e) {
            LOGGER.severe(e);
            return Collections.emptySet();
        }
    }

    private static ClassLoader findHighestReachableClassLoader(URL url, ClassLoader classLoader, String resourceName) {
        if (classLoader.getParent() == null) {
            return classLoader;
        }
        ClassLoader highestClassLoader = classLoader;
        ClassLoader current = classLoader;
        while (current.getParent() != null && !FILTERING_CLASS_LOADER.equals(current.getClass().getCanonicalName())) {
            ClassLoader parent = current.getParent();
            try {
                Enumeration<URL> enumeration = parent.getResources(resourceName);
                while (enumeration.hasMoreElements()) {
                    URL testURL = enumeration.nextElement();
                    if (!url.equals(testURL)) continue;
                    highestClassLoader = parent;
                }
            }
            catch (IOException ignore) {
                // empty catch block
            }
            current = current.getParent();
        }
        return highestClassLoader;
    }

    static List<ClassLoader> selectClassLoaders(ClassLoader classLoader) {
        ClassLoader coreClassLoader;
        ClassLoader tccl;
        ArrayList<ClassLoader> classLoaders = new ArrayList<ClassLoader>();
        if (classLoader != null) {
            classLoaders.add(classLoader);
        }
        if ((tccl = Thread.currentThread().getContextClassLoader()) != classLoader) {
            classLoaders.add(tccl);
        }
        if ((coreClassLoader = ServiceLoader.class.getClassLoader()) != classLoader && coreClassLoader != tccl) {
            classLoaders.add(coreClassLoader);
        }
        try {
            Class<?> hzClientClass = Class.forName("com.hazelcast.client.HazelcastClient");
            ClassLoader clientClassLoader = hzClientClass.getClassLoader();
            if (clientClassLoader != classLoader && clientClassLoader != tccl && clientClassLoader != coreClassLoader) {
                classLoaders.add(clientClassLoader);
            }
        }
        catch (ClassNotFoundException ignore) {
            // empty catch block
        }
        return classLoaders;
    }

    private static final class URLDefinition {
        private final URL url;
        private final ClassLoader classLoader;

        private URLDefinition(URL url, ClassLoader classLoader) {
            this.url = url;
            this.classLoader = classLoader;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            URLDefinition that = (URLDefinition)o;
            return !(this.url != null ? !this.url.equals(that.url) : that.url != null);
        }

        public int hashCode() {
            int result = this.url != null ? this.url.hashCode() : 0;
            return result;
        }
    }

    private static final class ServiceDefinition {
        private final String className;
        private final ClassLoader classLoader;

        private ServiceDefinition(String className, ClassLoader classLoader) {
            ValidationUtil.isNotNull(className, "className");
            ValidationUtil.isNotNull(classLoader, "classLoader");
            this.className = className;
            this.classLoader = classLoader;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ServiceDefinition that = (ServiceDefinition)o;
            if (!this.classLoader.equals(that.classLoader)) {
                return false;
            }
            return this.className.equals(that.className);
        }

        public int hashCode() {
            int result = this.className.hashCode();
            result = 31 * result + this.classLoader.hashCode();
            return result;
        }
    }
}

