/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.javaee.reqreporter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import org.javasimon.Split;
import org.javasimon.Stopwatch;
import org.javasimon.javaee.SimonServletFilter;
import org.javasimon.javaee.reqreporter.RequestReporter;
import org.javasimon.utils.SimonUtils;

public class DefaultRequestReporter
implements RequestReporter {
    private static final int NOTE_OUTPUT_MAX_LEN = 80;
    private SimonServletFilter simonServletFilter;

    @Override
    public void reportRequest(HttpServletRequest request, Split requestSplit, List<Split> splits) {
        StringBuilder messageBuilder = new StringBuilder("Web request is too long (" + SimonUtils.presentNanoTime((long)requestSplit.runningFor()) + ") [" + requestSplit.getStopwatch().getNote() + "]");
        if (splits.size() > 0) {
            this.buildSplitDetails(requestSplit, splits, messageBuilder);
        }
        this.reportMessage(messageBuilder.toString());
    }

    protected void reportMessage(String message) {
        this.simonServletFilter.getManager().message(message);
    }

    private void buildSplitDetails(Split requestSplit, List<Split> splits, StringBuilder messageBuilder) {
        HashMap<String, StopwatchInfo> stopwatchInfos = new HashMap<String, StopwatchInfo>();
        this.processSplitsAndAddSignificantOnes(requestSplit, splits, messageBuilder, stopwatchInfos);
        this.addStopwatchSplitDistribution(messageBuilder, stopwatchInfos);
    }

    private void processSplitsAndAddSignificantOnes(Split requestSplit, List<Split> splits, StringBuilder messageBuilder, Map<String, StopwatchInfo> stopwatchInfos) {
        for (Split split : splits) {
            StopwatchInfo stopwatchInfo = stopwatchInfos.get(split.getStopwatch().getName());
            if (stopwatchInfo == null) {
                stopwatchInfo = new StopwatchInfo(split.getStopwatch());
                stopwatchInfos.put(split.getStopwatch().getName(), stopwatchInfo);
            }
            stopwatchInfo.addSplit(split);
            if (!this.isSignificantSplit(split, requestSplit)) continue;
            messageBuilder.append("\n\t").append(split.getStopwatch().getName()).append(": ").append(SimonUtils.presentNanoTime((long)split.runningFor()));
        }
    }

    protected boolean isSignificantSplit(Split split, Split requestSplit) {
        return split.runningFor() > requestSplit.runningFor() / 20L;
    }

    private void addStopwatchSplitDistribution(StringBuilder messageBuilder, Map<String, StopwatchInfo> stopwatchInfos) {
        messageBuilder.append("\nStopwatch/Split count/total/max for this request (sorted by total descending):");
        TreeSet<StopwatchInfo> sortedInfos = new TreeSet<StopwatchInfo>(stopwatchInfos.values());
        for (StopwatchInfo info : sortedInfos) {
            if (!this.shouldBeAddedStopwatchInfo(info)) continue;
            this.addStopwatchInfo(messageBuilder, info);
        }
    }

    protected boolean shouldBeAddedStopwatchInfo(StopwatchInfo info) {
        return true;
    }

    private void addStopwatchInfo(StringBuilder messageBuilder, StopwatchInfo info) {
        messageBuilder.append("\n\t").append(info.stopwatch.getName()).append(": ").append(info.splits.size()).append("x, total: ").append(SimonUtils.presentNanoTime((long)info.total)).append(", max: ").append(SimonUtils.presentNanoTime((long)info.maxSplit.runningFor()));
        if (info.stopwatch.getNote() != null) {
            messageBuilder.append(", note: ").append(SimonUtils.compact((String)info.stopwatch.getNote(), (int)80));
        }
    }

    @Override
    public void setSimonServletFilter(SimonServletFilter simonServletFilter) {
        this.simonServletFilter = simonServletFilter;
    }

    protected class StopwatchInfo
    implements Comparable<StopwatchInfo> {
        Stopwatch stopwatch;
        List<Split> splits = new ArrayList<Split>();
        Split maxSplit;
        long total;

        StopwatchInfo(Stopwatch stopwatch) {
            this.stopwatch = stopwatch;
        }

        @Override
        public int compareTo(StopwatchInfo o) {
            return this.total < o.total ? 1 : (this.total == o.total ? 0 : -1);
        }

        public void addSplit(Split split) {
            this.splits.add(split);
            long runningFor = split.runningFor();
            if (this.maxSplit == null || runningFor > this.maxSplit.runningFor()) {
                this.maxSplit = split;
            }
            this.total += runningFor;
        }
    }
}

