/*
 * Decompiled with CFR 0.152.
 */
package com.drew.lang;

import com.drew.lang.BufferBoundsException;
import com.drew.lang.BufferReader;
import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.SuppressWarnings;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;

public class RandomAccessFileReader
implements BufferReader {
    @NotNull
    private final RandomAccessFile _file;
    private final long _length;
    private int _currentIndex;
    private boolean _isMotorolaByteOrder = true;

    @SuppressWarnings(value="EI_EXPOSE_REP2", justification="Design intent")
    public RandomAccessFileReader(@NotNull RandomAccessFile randomAccessFile) throws IOException {
        if (randomAccessFile == null) {
            throw new NullPointerException();
        }
        this._file = randomAccessFile;
        this._length = this._file.length();
    }

    @Override
    public long getLength() {
        return this._length;
    }

    @Override
    public void setMotorolaByteOrder(boolean bl) {
        this._isMotorolaByteOrder = bl;
    }

    @Override
    public boolean isMotorolaByteOrder() {
        return this._isMotorolaByteOrder;
    }

    private byte read() throws BufferBoundsException {
        int n;
        try {
            n = this._file.read();
        }
        catch (IOException iOException) {
            throw new BufferBoundsException("IOException reading from file.", iOException);
        }
        if (n < 0) {
            throw new BufferBoundsException("Unexpected end of file encountered.");
        }
        assert (n <= 255);
        return (byte)n;
    }

    private void seek(int n) throws BufferBoundsException {
        if (n == this._currentIndex) {
            return;
        }
        try {
            this._file.seek(n);
            this._currentIndex = n;
        }
        catch (IOException iOException) {
            throw new BufferBoundsException("IOException seeking in file.", iOException);
        }
    }

    @Override
    public short getUInt8(int n) throws BufferBoundsException {
        this.checkBounds(n, 1);
        this.seek(n);
        return (short)(this.read() & 0xFF);
    }

    @Override
    public byte getInt8(int n) throws BufferBoundsException {
        this.checkBounds(n, 1);
        this.seek(n);
        return this.read();
    }

    @Override
    public int getUInt16(int n) throws BufferBoundsException {
        this.checkBounds(n, 2);
        this.seek(n);
        if (this._isMotorolaByteOrder) {
            return this.read() << 8 & 0xFF00 | this.read() & 0xFF;
        }
        return this.read() & 0xFF | this.read() << 8 & 0xFF00;
    }

    @Override
    public short getInt16(int n) throws BufferBoundsException {
        this.checkBounds(n, 2);
        this.seek(n);
        if (this._isMotorolaByteOrder) {
            return (short)((short)this.read() << 8 & 0xFFFFFF00 | (short)this.read() & 0xFF);
        }
        return (short)((short)this.read() & 0xFF | (short)this.read() << 8 & 0xFFFFFF00);
    }

    @Override
    public long getUInt32(int n) throws BufferBoundsException {
        this.checkBounds(n, 4);
        this.seek(n);
        if (this._isMotorolaByteOrder) {
            return (long)this.read() << 24 & 0xFF000000L | (long)this.read() << 16 & 0xFF0000L | (long)this.read() << 8 & 0xFF00L | (long)this.read() & 0xFFL;
        }
        return (long)this.read() & 0xFFL | (long)this.read() << 8 & 0xFF00L | (long)this.read() << 16 & 0xFF0000L | (long)this.read() << 24 & 0xFF000000L;
    }

    @Override
    public int getInt32(int n) throws BufferBoundsException {
        this.checkBounds(n, 4);
        this.seek(n);
        if (this._isMotorolaByteOrder) {
            return this.read() << 24 & 0xFF000000 | this.read() << 16 & 0xFF0000 | this.read() << 8 & 0xFF00 | this.read() & 0xFF;
        }
        return this.read() & 0xFF | this.read() << 8 & 0xFF00 | this.read() << 16 & 0xFF0000 | this.read() << 24 & 0xFF000000;
    }

    @Override
    public long getInt64(int n) throws BufferBoundsException {
        this.checkBounds(n, 8);
        this.seek(n);
        if (this._isMotorolaByteOrder) {
            return (long)this.read() << 56 & 0xFF00000000000000L | (long)this.read() << 48 & 0xFF000000000000L | (long)this.read() << 40 & 0xFF0000000000L | (long)this.read() << 32 & 0xFF00000000L | (long)this.read() << 24 & 0xFF000000L | (long)this.read() << 16 & 0xFF0000L | (long)this.read() << 8 & 0xFF00L | (long)this.read() & 0xFFL;
        }
        return (long)this.read() & 0xFFL | (long)this.read() << 8 & 0xFF00L | (long)this.read() << 16 & 0xFF0000L | (long)this.read() << 24 & 0xFF000000L | (long)this.read() << 32 & 0xFF00000000L | (long)this.read() << 40 & 0xFF0000000000L | (long)this.read() << 48 & 0xFF000000000000L | (long)this.read() << 56 & 0xFF00000000000000L;
    }

    @Override
    public float getS15Fixed16(int n) throws BufferBoundsException {
        this.checkBounds(n, 4);
        this.seek(n);
        if (this._isMotorolaByteOrder) {
            float f = (this.read() & 0xFF) << 8 | this.read() & 0xFF;
            int n2 = (this.read() & 0xFF) << 8 | this.read() & 0xFF;
            return (float)((double)f + (double)n2 / 65536.0);
        }
        int n3 = this.read() & 0xFF | (this.read() & 0xFF) << 8;
        float f = this.read() & 0xFF | (this.read() & 0xFF) << 8;
        return (float)((double)f + (double)n3 / 65536.0);
    }

    @Override
    public float getFloat32(int n) throws BufferBoundsException {
        return Float.intBitsToFloat(this.getInt32(n));
    }

    @Override
    public double getDouble64(int n) throws BufferBoundsException {
        return Double.longBitsToDouble(this.getInt64(n));
    }

    @Override
    @NotNull
    public byte[] getBytes(int n, int n2) throws BufferBoundsException {
        int n3;
        this.checkBounds(n, n2);
        this.seek(n);
        byte[] byArray = new byte[n2];
        try {
            n3 = this._file.read(byArray);
        }
        catch (IOException iOException) {
            throw new BufferBoundsException("Unexpected end of file encountered.", iOException);
        }
        if (n3 != n2) {
            throw new BufferBoundsException("Unexpected end of file encountered.");
        }
        return byArray;
    }

    @Override
    @NotNull
    public String getString(int n, int n2) throws BufferBoundsException {
        return new String(this.getBytes(n, n2));
    }

    @Override
    @NotNull
    public String getString(int n, int n2, String string) throws BufferBoundsException {
        this.checkBounds(n, n2);
        byte[] byArray = this.getBytes(n, n2);
        try {
            return new String(byArray, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String(byArray);
        }
    }

    @Override
    @NotNull
    public String getNullTerminatedString(int n, int n2) throws BufferBoundsException {
        int n3;
        this.checkBounds(n, n2);
        this.seek(n);
        for (n3 = 0; (long)(n + n3) < this._length && this.read() != 0 && n3 < n2; ++n3) {
        }
        byte[] byArray = this.getBytes(n, n3);
        return new String(byArray);
    }

    private void checkBounds(int n, int n2) throws BufferBoundsException {
        if (n2 < 0) {
            throw new BufferBoundsException("Requested negative number of bytes.");
        }
        if (n < 0) {
            throw new BufferBoundsException("Requested data from a negative index within the file.");
        }
        if ((long)n + (long)n2 - 1L >= this._length) {
            throw new BufferBoundsException("Requested data from beyond the end of the file.");
        }
    }
}

