/*
 * Decompiled with CFR 0.152.
 */
package org.magicwerk.brownies.collections.primitive;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.magicwerk.brownies.collections.GapList;
import org.magicwerk.brownies.collections.IList;
import org.magicwerk.brownies.collections.function.Mapper;
import org.magicwerk.brownies.collections.function.Predicate;
import org.magicwerk.brownies.collections.primitive.DoubleGapList;
import org.magicwerk.brownies.collections.primitive.DoubleObjGapList;

public abstract class IDoubleList
implements Cloneable,
Serializable {
    static double[] toArray(Collection<Double> coll) {
        Object[] values = coll.toArray();
        double[] v = new double[values.length];
        for (int i = 0; i < values.length; ++i) {
            v[i] = (Double)values[i];
        }
        return v;
    }

    public IDoubleList copy() {
        return (IDoubleList)this.clone();
    }

    public abstract IDoubleList unmodifiableList();

    public Object clone() {
        try {
            IDoubleList list = (IDoubleList)super.clone();
            list.doClone(this);
            return list;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    protected abstract void doClone(IDoubleList var1);

    public void clear() {
        this.doRemoveAll(0, this.size());
    }

    public abstract int size();

    public abstract int capacity();

    public double get(int index) {
        this.checkIndex(index);
        return this.doGet(index);
    }

    protected abstract double doGet(int var1);

    protected abstract double doSet(int var1, double var2);

    public double set(int index, double elem) {
        this.checkIndex(index);
        return this.doSet(index, elem);
    }

    protected abstract double doReSet(int var1, double var2);

    protected abstract double getDefaultElem();

    protected void doModify() {
    }

    public boolean add(double elem) {
        return this.doAdd(-1, elem);
    }

    public void add(int index, double elem) {
        this.checkIndexAdd(index);
        this.doAdd(index, elem);
    }

    protected abstract boolean doAdd(int var1, double var2);

    public double remove(int index) {
        this.checkIndex(index);
        return this.doRemove(index);
    }

    protected abstract double doRemove(int var1);

    public void ensureCapacity(int minCapacity) {
        this.doModify();
        this.doEnsureCapacity(minCapacity);
    }

    protected abstract void doEnsureCapacity(int var1);

    public abstract void trimToSize();

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof DoubleObjGapList) {
            obj = ((DoubleObjGapList)obj).list;
        }
        if (!(obj instanceof DoubleGapList)) {
            return false;
        }
        DoubleGapList list = (DoubleGapList)obj;
        int size = this.size();
        if (size != list.size()) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            if (IDoubleList.equalsElem(this.doGet(i), list.get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            double elem = this.doGet(i);
            hashCode = 31 * hashCode + IDoubleList.hashCodeElem(elem);
        }
        return hashCode;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(this.doGet(i));
        }
        buf.append("]");
        return buf.toString();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    static boolean equalsElem(double elem1, double elem2) {
        return Double.doubleToLongBits(elem1) == Double.doubleToLongBits(elem2);
    }

    static int hashCodeElem(double elem) {
        return (int)elem;
    }

    public int getCount(double elem) {
        int count = 0;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (!IDoubleList.equalsElem(this.doGet(i), elem)) continue;
            ++count;
        }
        return count;
    }

    public IDoubleList getAll(double elem) {
        IDoubleList list = this.doCreate(-1);
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            double e = this.doGet(i);
            if (!IDoubleList.equalsElem(e, elem)) continue;
            list.add(e);
        }
        return list;
    }

    public Set getDistinct() {
        HashSet<Double> set = new HashSet<Double>();
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            set.add(this.doGet(i));
        }
        return set;
    }

    public <R> IList<R> mappedList(Mapper<Double, R> mapper) {
        int size = this.size();
        GapList<R> mappedList = new GapList<R>(size);
        for (int i = 0; i < size; ++i) {
            double e = this.doGet(i);
            ((IList)mappedList).add(mapper.getKey(e));
        }
        return mappedList;
    }

    public void filter(Predicate<Double> predicate) {
        IDoubleList list = this.doCreate(-1);
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            double e = this.doGet(i);
            if (!predicate.allow(e)) continue;
            list.add(e);
        }
        this.doAssign(list);
    }

    public int indexOf(double elem) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (!IDoubleList.equalsElem(this.doGet(i), elem)) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(double elem) {
        for (int i = this.size() - 1; i >= 0; --i) {
            if (!IDoubleList.equalsElem(this.doGet(i), elem)) continue;
            return i;
        }
        return -1;
    }

    public boolean removeElem(double elem) {
        int index = this.indexOf(elem);
        if (index == -1) {
            return false;
        }
        this.doRemove(index);
        return true;
    }

    public boolean contains(double elem) {
        return this.indexOf(elem) != -1;
    }

    public boolean containsAny(Collection<Double> coll) {
        for (double elem : coll) {
            if (!this.contains(elem)) continue;
            return true;
        }
        return false;
    }

    public boolean containsAll(Collection<Double> coll) {
        for (double elem : coll) {
            if (this.contains(elem)) continue;
            return false;
        }
        return true;
    }

    public boolean removeAll(Collection<Double> coll) {
        boolean modified = false;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (!coll.contains(this.doGet(i))) continue;
            this.doRemove(i);
            --size;
            --i;
            modified = true;
        }
        return modified;
    }

    public IDoubleList removeAll(double elem) {
        IDoubleList list = this.doCreate(-1);
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            double e = this.doGet(i);
            if (!IDoubleList.equalsElem(elem, e)) continue;
            list.add(e);
            this.doRemove(i);
            --size;
            --i;
        }
        return list;
    }

    public boolean removeAll(IDoubleList coll) {
        boolean modified = false;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (!coll.contains(this.doGet(i))) continue;
            this.doRemove(i);
            --size;
            --i;
            modified = true;
        }
        return modified;
    }

    public boolean retainAll(Collection<Double> coll) {
        boolean modified = false;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (coll.contains(this.doGet(i))) continue;
            this.doRemove(i);
            --size;
            --i;
            modified = true;
        }
        return modified;
    }

    public boolean retainAll(IDoubleList coll) {
        boolean modified = false;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (coll.contains(this.doGet(i))) continue;
            this.doRemove(i);
            --size;
            --i;
            modified = true;
        }
        return modified;
    }

    public double[] toArray() {
        int size = this.size();
        double[] array = new double[size];
        this.doGetAll(array, 0, size);
        return array;
    }

    public double[] toArray(int index, int len) {
        double[] array = new double[len];
        this.doGetAll(array, index, len);
        return array;
    }

    public double[] toArray(double[] array) {
        int size = this.size();
        if (array.length < size) {
            array = (double[])Array.newInstance(array.getClass().getComponentType(), size);
        }
        this.doGetAll(array, 0, size);
        if (array.length > size) {
            array[size] = 0.0;
        }
        return array;
    }

    protected void doGetAll(double[] array, int index, int len) {
        for (int i = 0; i < len; ++i) {
            array[i] = this.doGet(index + i);
        }
    }

    public boolean addAll(Collection<Double> coll) {
        double[] array = IDoubleList.toArray(coll);
        return this.doAddAll(-1, array);
    }

    public boolean addAll(int index, Collection<Double> coll) {
        this.checkIndexAdd(index);
        double[] array = IDoubleList.toArray(coll);
        return this.doAddAll(index, array);
    }

    public boolean addAll(double ... elems) {
        return this.doAddAll(-1, elems);
    }

    public boolean addAll(int index, double ... elems) {
        this.checkIndexAdd(index);
        return this.doAddAll(index, elems);
    }

    public boolean addAll(IDoubleList list) {
        return this.doAddAll(-1, list.toArray());
    }

    public boolean addAll(int index, IDoubleList list) {
        this.checkIndexAdd(index);
        return this.doAddAll(index, list.toArray());
    }

    protected boolean doAddAll(int index, double[] array) {
        this.doEnsureCapacity(this.size() + array.length);
        if (array.length == 0) {
            return false;
        }
        for (double elem : array) {
            this.doAdd(index, elem);
            if (index == -1) continue;
            ++index;
        }
        return true;
    }

    public double peek() {
        if (this.size() == 0) {
            return 0.0;
        }
        return this.getFirst();
    }

    public double element() {
        if (this.size() == 0) {
            throw new NoSuchElementException();
        }
        return this.doGet(0);
    }

    public double poll() {
        if (this.size() == 0) {
            return 0.0;
        }
        return this.doRemove(0);
    }

    public double remove() {
        if (this.size() == 0) {
            throw new NoSuchElementException();
        }
        return this.doRemove(0);
    }

    public boolean offer(double elem) {
        return this.doAdd(-1, elem);
    }

    public double getFirst() {
        if (this.size() == 0) {
            throw new NoSuchElementException();
        }
        return this.doGet(0);
    }

    public double getLast() {
        int size = this.size();
        if (size == 0) {
            throw new NoSuchElementException();
        }
        return this.doGet(size - 1);
    }

    public void addFirst(double elem) {
        this.doAdd(0, elem);
    }

    public void addLast(double elem) {
        this.doAdd(-1, elem);
    }

    public double removeFirst() {
        if (this.size() == 0) {
            throw new NoSuchElementException();
        }
        return this.doRemove(0);
    }

    public double removeLast() {
        int size = this.size();
        if (size == 0) {
            throw new NoSuchElementException();
        }
        return this.doRemove(size - 1);
    }

    public boolean offerFirst(double elem) {
        this.doAdd(0, elem);
        return true;
    }

    public boolean offerLast(double elem) {
        this.doAdd(-1, elem);
        return true;
    }

    public double peekFirst() {
        if (this.size() == 0) {
            return 0.0;
        }
        return this.doGet(0);
    }

    public double peekLast() {
        int size = this.size();
        if (size == 0) {
            return 0.0;
        }
        return this.doGet(size - 1);
    }

    public double pollFirst() {
        if (this.size() == 0) {
            return 0.0;
        }
        return this.doRemove(0);
    }

    public double pollLast() {
        int size = this.size();
        if (size == 0) {
            return 0.0;
        }
        return this.doRemove(size - 1);
    }

    public double pop() {
        if (this.size() == 0) {
            throw new NoSuchElementException();
        }
        return this.doRemove(0);
    }

    public void push(double elem) {
        this.doAdd(0, elem);
    }

    public boolean removeFirstOccurrence(double elem) {
        int index = this.indexOf(elem);
        if (index == -1) {
            return false;
        }
        this.doRemove(index);
        return true;
    }

    public boolean removeLastOccurrence(double elem) {
        int index = this.lastIndexOf(elem);
        if (index == -1) {
            return false;
        }
        this.doRemove(index);
        return true;
    }

    public static void move(IDoubleList src, int srcIndex, IDoubleList dst, int dstIndex, int len) {
        if (src == dst) {
            src.move(srcIndex, dstIndex, len);
        } else {
            src.checkRange(srcIndex, len);
            dst.checkRange(dstIndex, len);
            double defaultElem = src.getDefaultElem();
            for (int i = 0; i < len; ++i) {
                double elem = src.doReSet(srcIndex + i, defaultElem);
                dst.doSet(dstIndex + i, elem);
            }
        }
    }

    public static void copy(IDoubleList src, int srcIndex, IDoubleList dst, int dstIndex, int len) {
        if (src == dst) {
            src.copy(srcIndex, dstIndex, len);
        } else {
            src.checkRange(srcIndex, len);
            dst.checkRange(dstIndex, len);
            for (int i = 0; i < len; ++i) {
                double elem = src.doGet(srcIndex + i);
                dst.doSet(dstIndex + i, elem);
            }
        }
    }

    public static void swap(IDoubleList src, int srcIndex, IDoubleList dst, int dstIndex, int len) {
        if (src == dst) {
            src.swap(srcIndex, dstIndex, len);
        } else {
            src.checkRange(srcIndex, len);
            dst.checkRange(dstIndex, len);
            if (src != dst) {
                for (int i = 0; i < len; ++i) {
                    double swap = src.doGet(srcIndex + i);
                    swap = dst.doSet(dstIndex + i, swap);
                    src.doSet(srcIndex + i, swap);
                }
            }
        }
    }

    protected abstract IDoubleList doCreate(int var1);

    protected abstract void doAssign(IDoubleList var1);

    public IDoubleList getAll(int index, int len) {
        this.checkRange(index, len);
        IDoubleList list = this.doCreate(len);
        for (int i = 0; i < len; ++i) {
            list.add(this.doGet(index + i));
        }
        return list;
    }

    public double[] getArray(int index, int len) {
        this.checkRange(index, len);
        double[] array = new double[len];
        for (int i = 0; i < len; ++i) {
            array[i] = this.doGet(index + i);
        }
        return array;
    }

    public void setAll(int index, IDoubleList list) {
        int size = list.size();
        this.checkRange(index, size);
        for (int i = 0; i < size; ++i) {
            this.doSet(index + i, list.get(i));
        }
    }

    public void setAll(int index, Collection<Double> coll) {
        this.checkRange(index, coll.size());
        int i = 0;
        Iterator<Double> iter = coll.iterator();
        while (iter.hasNext()) {
            this.doSet(index + i, iter.next());
            ++i;
        }
    }

    public void setAll(int index, double ... elems) {
        this.checkRange(index, elems.length);
        this.doSetAll(index, elems);
    }

    protected void doSetAll(int index, double[] elems) {
        for (int i = 0; i < elems.length; ++i) {
            this.doSet(index + i, elems[i]);
        }
    }

    public void remove(int index, int len) {
        this.checkRange(index, len);
        this.doRemoveAll(index, len);
    }

    protected void doRemoveAll(int index, int len) {
        for (int i = index + len - 1; i >= index; --i) {
            this.doRemove(i);
        }
    }

    public void init(int len, double elem) {
        this.checkLength(len);
        int size = this.size();
        if (len < size) {
            this.remove(len, size - len);
            this.fill(0, len, elem);
        } else {
            this.fill(0, size, elem);
            for (int i = size; i < len; ++i) {
                this.add(elem);
            }
        }
        assert (this.size() == len);
    }

    public void resize(int len, double elem) {
        this.checkLength(len);
        int size = this.size();
        if (len < size) {
            this.remove(len, size - len);
        } else {
            for (int i = size; i < len; ++i) {
                this.add(elem);
            }
        }
        assert (this.size() == len);
    }

    public void fill(double elem) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            this.doSet(i, elem);
        }
    }

    public void fill(int index, int len, double elem) {
        this.checkRange(index, len);
        for (int i = 0; i < len; ++i) {
            this.doSet(index + i, elem);
        }
    }

    public void copy(int srcIndex, int dstIndex, int len) {
        block3: {
            block2: {
                this.checkRange(srcIndex, len);
                this.checkRange(dstIndex, len);
                if (srcIndex >= dstIndex) break block2;
                for (int i = len - 1; i >= 0; --i) {
                    this.doReSet(dstIndex + i, this.doGet(srcIndex + i));
                }
                break block3;
            }
            if (srcIndex <= dstIndex) break block3;
            for (int i = 0; i < len; ++i) {
                this.doReSet(dstIndex + i, this.doGet(srcIndex + i));
            }
        }
    }

    public void move(int srcIndex, int dstIndex, int len) {
        int fill;
        int i;
        this.checkRange(srcIndex, len);
        this.checkRange(dstIndex, len);
        if (srcIndex < dstIndex) {
            for (i = len - 1; i >= 0; --i) {
                this.doReSet(dstIndex + i, this.doGet(srcIndex + i));
            }
        } else if (srcIndex > dstIndex) {
            for (i = 0; i < len; ++i) {
                this.doReSet(dstIndex + i, this.doGet(srcIndex + i));
            }
        }
        if (srcIndex < dstIndex) {
            fill = Math.min(len, dstIndex - srcIndex);
            this.fill(srcIndex, fill, 0.0);
        } else if (srcIndex > dstIndex) {
            fill = Math.min(len, srcIndex - dstIndex);
            this.fill(srcIndex + len - fill, fill, 0.0);
        }
    }

    public void reverse() {
        this.reverse(0, this.size());
    }

    public void reverse(int index, int len) {
        this.checkRange(index, len);
        int pos1 = index;
        int pos2 = index + len - 1;
        int mid = len / 2;
        for (int i = 0; i < mid; ++i) {
            double swap = this.doGet(pos1);
            swap = this.doReSet(pos2, swap);
            this.doReSet(pos1, swap);
            ++pos1;
            --pos2;
        }
    }

    public void swap(int index1, int index2, int len) {
        this.checkRange(index1, len);
        this.checkRange(index2, len);
        if (index1 < index2 && index1 + len > index2 || index1 > index2 && index2 + len > index1) {
            throw new IllegalArgumentException("Swap ranges overlap");
        }
        for (int i = 0; i < len; ++i) {
            double swap = this.doGet(index1 + i);
            swap = this.doReSet(index2 + i, swap);
            this.doReSet(index1 + i, swap);
        }
    }

    public void rotate(int distance) {
        this.rotate(0, this.size(), distance);
    }

    public void rotate(int index, int len, int distance) {
        this.checkRange(index, len);
        int size = this.size();
        if ((distance %= size) < 0) {
            distance += size;
        }
        if (distance == 0) {
            return;
        }
        int num = 0;
        int start = 0;
        while (num != size) {
            double elem = this.doGet(index + start);
            int i = start;
            do {
                if ((i += distance) >= len) {
                    i -= len;
                }
                elem = this.doReSet(index + i, elem);
                ++num;
            } while (i != start);
            ++start;
        }
    }

    public void sort() {
        this.sort(0, this.size());
    }

    public abstract void sort(int var1, int var2);

    public int binarySearch(double key) {
        return this.binarySearch(0, this.size(), key);
    }

    public abstract int binarySearch(int var1, int var2, double var3);

    protected void checkIndex(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException("Invalid index: " + index + " (size: " + this.size() + ")");
        }
    }

    protected void checkIndexAdd(int index) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException("Invalid index: " + index + " (size: " + this.size() + ")");
        }
    }

    protected void checkRange(int index, int len) {
        if (index < 0 || len < 0 || index + len > this.size()) {
            throw new IndexOutOfBoundsException("Invalid range: " + index + "/" + len + " (size: " + this.size() + ")");
        }
    }

    protected void checkLength(int length) {
        if (length < 0) {
            throw new IndexOutOfBoundsException("Invalid length: " + length);
        }
    }
}

