/*
 * Decompiled with CFR 0.152.
 */
package org.magicwerk.brownies.collections.primitive;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.magicwerk.brownies.collections.GapList;
import org.magicwerk.brownies.collections.IList;
import org.magicwerk.brownies.collections.function.Mapper;
import org.magicwerk.brownies.collections.function.Predicate;
import org.magicwerk.brownies.collections.primitive.ShortGapList;
import org.magicwerk.brownies.collections.primitive.ShortObjGapList;

public abstract class IShortList
implements Cloneable,
Serializable {
    static short[] toArray(Collection<Short> coll) {
        Object[] values = coll.toArray();
        short[] v = new short[values.length];
        for (int i = 0; i < values.length; ++i) {
            v[i] = (Short)values[i];
        }
        return v;
    }

    public IShortList copy() {
        return (IShortList)this.clone();
    }

    public abstract IShortList unmodifiableList();

    public Object clone() {
        try {
            IShortList list = (IShortList)super.clone();
            list.doClone(this);
            return list;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    protected abstract void doClone(IShortList var1);

    public void clear() {
        this.doRemoveAll(0, this.size());
    }

    public abstract int size();

    public abstract int capacity();

    public short get(int index) {
        this.checkIndex(index);
        return this.doGet(index);
    }

    protected abstract short doGet(int var1);

    protected abstract short doSet(int var1, short var2);

    public short set(int index, short elem) {
        this.checkIndex(index);
        return this.doSet(index, elem);
    }

    protected abstract short doReSet(int var1, short var2);

    protected abstract short getDefaultElem();

    protected void doModify() {
    }

    public boolean add(short elem) {
        return this.doAdd(-1, elem);
    }

    public void add(int index, short elem) {
        this.checkIndexAdd(index);
        this.doAdd(index, elem);
    }

    protected abstract boolean doAdd(int var1, short var2);

    public short remove(int index) {
        this.checkIndex(index);
        return this.doRemove(index);
    }

    protected abstract short doRemove(int var1);

    public void ensureCapacity(int minCapacity) {
        this.doModify();
        this.doEnsureCapacity(minCapacity);
    }

    protected abstract void doEnsureCapacity(int var1);

    public abstract void trimToSize();

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ShortObjGapList) {
            obj = ((ShortObjGapList)obj).list;
        }
        if (!(obj instanceof ShortGapList)) {
            return false;
        }
        ShortGapList list = (ShortGapList)obj;
        int size = this.size();
        if (size != list.size()) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            if (IShortList.equalsElem(this.doGet(i), list.get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            short elem = this.doGet(i);
            hashCode = 31 * hashCode + IShortList.hashCodeElem(elem);
        }
        return hashCode;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(this.doGet(i));
        }
        buf.append("]");
        return buf.toString();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    static boolean equalsElem(short elem1, short elem2) {
        return elem1 == elem2;
    }

    static int hashCodeElem(short elem) {
        return elem;
    }

    public int getCount(short elem) {
        int count = 0;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (!IShortList.equalsElem(this.doGet(i), elem)) continue;
            ++count;
        }
        return count;
    }

    public IShortList getAll(short elem) {
        IShortList list = this.doCreate(-1);
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            short e = this.doGet(i);
            if (!IShortList.equalsElem(e, elem)) continue;
            list.add(e);
        }
        return list;
    }

    public Set getDistinct() {
        HashSet<Short> set = new HashSet<Short>();
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            set.add(this.doGet(i));
        }
        return set;
    }

    public <R> IList<R> mappedList(Mapper<Short, R> mapper) {
        int size = this.size();
        GapList<R> mappedList = new GapList<R>(size);
        for (int i = 0; i < size; ++i) {
            short e = this.doGet(i);
            ((IList)mappedList).add(mapper.getKey(e));
        }
        return mappedList;
    }

    public void filter(Predicate<Short> predicate) {
        IShortList list = this.doCreate(-1);
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            short e = this.doGet(i);
            if (!predicate.allow(e)) continue;
            list.add(e);
        }
        this.doAssign(list);
    }

    public int indexOf(short elem) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (!IShortList.equalsElem(this.doGet(i), elem)) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(short elem) {
        for (int i = this.size() - 1; i >= 0; --i) {
            if (!IShortList.equalsElem(this.doGet(i), elem)) continue;
            return i;
        }
        return -1;
    }

    public boolean removeElem(short elem) {
        int index = this.indexOf(elem);
        if (index == -1) {
            return false;
        }
        this.doRemove(index);
        return true;
    }

    public boolean contains(short elem) {
        return this.indexOf(elem) != -1;
    }

    public boolean containsAny(Collection<Short> coll) {
        for (short elem : coll) {
            if (!this.contains(elem)) continue;
            return true;
        }
        return false;
    }

    public boolean containsAll(Collection<Short> coll) {
        for (short elem : coll) {
            if (this.contains(elem)) continue;
            return false;
        }
        return true;
    }

    public boolean removeAll(Collection<Short> coll) {
        boolean modified = false;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (!coll.contains(this.doGet(i))) continue;
            this.doRemove(i);
            --size;
            --i;
            modified = true;
        }
        return modified;
    }

    public IShortList removeAll(short elem) {
        IShortList list = this.doCreate(-1);
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            short e = this.doGet(i);
            if (!IShortList.equalsElem(elem, e)) continue;
            list.add(e);
            this.doRemove(i);
            --size;
            --i;
        }
        return list;
    }

    public boolean removeAll(IShortList coll) {
        boolean modified = false;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (!coll.contains(this.doGet(i))) continue;
            this.doRemove(i);
            --size;
            --i;
            modified = true;
        }
        return modified;
    }

    public boolean retainAll(Collection<Short> coll) {
        boolean modified = false;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (coll.contains(this.doGet(i))) continue;
            this.doRemove(i);
            --size;
            --i;
            modified = true;
        }
        return modified;
    }

    public boolean retainAll(IShortList coll) {
        boolean modified = false;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (coll.contains(this.doGet(i))) continue;
            this.doRemove(i);
            --size;
            --i;
            modified = true;
        }
        return modified;
    }

    public short[] toArray() {
        int size = this.size();
        short[] array = new short[size];
        this.doGetAll(array, 0, size);
        return array;
    }

    public short[] toArray(int index, int len) {
        short[] array = new short[len];
        this.doGetAll(array, index, len);
        return array;
    }

    public short[] toArray(short[] array) {
        int size = this.size();
        if (array.length < size) {
            array = (short[])Array.newInstance(array.getClass().getComponentType(), size);
        }
        this.doGetAll(array, 0, size);
        if (array.length > size) {
            array[size] = 0;
        }
        return array;
    }

    protected void doGetAll(short[] array, int index, int len) {
        for (int i = 0; i < len; ++i) {
            array[i] = this.doGet(index + i);
        }
    }

    public boolean addAll(Collection<Short> coll) {
        short[] array = IShortList.toArray(coll);
        return this.doAddAll(-1, array);
    }

    public boolean addAll(int index, Collection<Short> coll) {
        this.checkIndexAdd(index);
        short[] array = IShortList.toArray(coll);
        return this.doAddAll(index, array);
    }

    public boolean addAll(short ... elems) {
        return this.doAddAll(-1, elems);
    }

    public boolean addAll(int index, short ... elems) {
        this.checkIndexAdd(index);
        return this.doAddAll(index, elems);
    }

    public boolean addAll(IShortList list) {
        return this.doAddAll(-1, list.toArray());
    }

    public boolean addAll(int index, IShortList list) {
        this.checkIndexAdd(index);
        return this.doAddAll(index, list.toArray());
    }

    protected boolean doAddAll(int index, short[] array) {
        this.doEnsureCapacity(this.size() + array.length);
        if (array.length == 0) {
            return false;
        }
        for (short elem : array) {
            this.doAdd(index, elem);
            if (index == -1) continue;
            ++index;
        }
        return true;
    }

    public short peek() {
        if (this.size() == 0) {
            return 0;
        }
        return this.getFirst();
    }

    public short element() {
        if (this.size() == 0) {
            throw new NoSuchElementException();
        }
        return this.doGet(0);
    }

    public short poll() {
        if (this.size() == 0) {
            return 0;
        }
        return this.doRemove(0);
    }

    public short remove() {
        if (this.size() == 0) {
            throw new NoSuchElementException();
        }
        return this.doRemove(0);
    }

    public boolean offer(short elem) {
        return this.doAdd(-1, elem);
    }

    public short getFirst() {
        if (this.size() == 0) {
            throw new NoSuchElementException();
        }
        return this.doGet(0);
    }

    public short getLast() {
        int size = this.size();
        if (size == 0) {
            throw new NoSuchElementException();
        }
        return this.doGet(size - 1);
    }

    public void addFirst(short elem) {
        this.doAdd(0, elem);
    }

    public void addLast(short elem) {
        this.doAdd(-1, elem);
    }

    public short removeFirst() {
        if (this.size() == 0) {
            throw new NoSuchElementException();
        }
        return this.doRemove(0);
    }

    public short removeLast() {
        int size = this.size();
        if (size == 0) {
            throw new NoSuchElementException();
        }
        return this.doRemove(size - 1);
    }

    public boolean offerFirst(short elem) {
        this.doAdd(0, elem);
        return true;
    }

    public boolean offerLast(short elem) {
        this.doAdd(-1, elem);
        return true;
    }

    public short peekFirst() {
        if (this.size() == 0) {
            return 0;
        }
        return this.doGet(0);
    }

    public short peekLast() {
        int size = this.size();
        if (size == 0) {
            return 0;
        }
        return this.doGet(size - 1);
    }

    public short pollFirst() {
        if (this.size() == 0) {
            return 0;
        }
        return this.doRemove(0);
    }

    public short pollLast() {
        int size = this.size();
        if (size == 0) {
            return 0;
        }
        return this.doRemove(size - 1);
    }

    public short pop() {
        if (this.size() == 0) {
            throw new NoSuchElementException();
        }
        return this.doRemove(0);
    }

    public void push(short elem) {
        this.doAdd(0, elem);
    }

    public boolean removeFirstOccurrence(short elem) {
        int index = this.indexOf(elem);
        if (index == -1) {
            return false;
        }
        this.doRemove(index);
        return true;
    }

    public boolean removeLastOccurrence(short elem) {
        int index = this.lastIndexOf(elem);
        if (index == -1) {
            return false;
        }
        this.doRemove(index);
        return true;
    }

    public static void move(IShortList src, int srcIndex, IShortList dst, int dstIndex, int len) {
        if (src == dst) {
            src.move(srcIndex, dstIndex, len);
        } else {
            src.checkRange(srcIndex, len);
            dst.checkRange(dstIndex, len);
            short defaultElem = src.getDefaultElem();
            for (int i = 0; i < len; ++i) {
                short elem = src.doReSet(srcIndex + i, defaultElem);
                dst.doSet(dstIndex + i, elem);
            }
        }
    }

    public static void copy(IShortList src, int srcIndex, IShortList dst, int dstIndex, int len) {
        if (src == dst) {
            src.copy(srcIndex, dstIndex, len);
        } else {
            src.checkRange(srcIndex, len);
            dst.checkRange(dstIndex, len);
            for (int i = 0; i < len; ++i) {
                short elem = src.doGet(srcIndex + i);
                dst.doSet(dstIndex + i, elem);
            }
        }
    }

    public static void swap(IShortList src, int srcIndex, IShortList dst, int dstIndex, int len) {
        if (src == dst) {
            src.swap(srcIndex, dstIndex, len);
        } else {
            src.checkRange(srcIndex, len);
            dst.checkRange(dstIndex, len);
            if (src != dst) {
                for (int i = 0; i < len; ++i) {
                    short swap = src.doGet(srcIndex + i);
                    swap = dst.doSet(dstIndex + i, swap);
                    src.doSet(srcIndex + i, swap);
                }
            }
        }
    }

    protected abstract IShortList doCreate(int var1);

    protected abstract void doAssign(IShortList var1);

    public IShortList getAll(int index, int len) {
        this.checkRange(index, len);
        IShortList list = this.doCreate(len);
        for (int i = 0; i < len; ++i) {
            list.add(this.doGet(index + i));
        }
        return list;
    }

    public short[] getArray(int index, int len) {
        this.checkRange(index, len);
        short[] array = new short[len];
        for (int i = 0; i < len; ++i) {
            array[i] = this.doGet(index + i);
        }
        return array;
    }

    public void setAll(int index, IShortList list) {
        int size = list.size();
        this.checkRange(index, size);
        for (int i = 0; i < size; ++i) {
            this.doSet(index + i, list.get(i));
        }
    }

    public void setAll(int index, Collection<Short> coll) {
        this.checkRange(index, coll.size());
        int i = 0;
        Iterator<Short> iter = coll.iterator();
        while (iter.hasNext()) {
            this.doSet(index + i, iter.next());
            ++i;
        }
    }

    public void setAll(int index, short ... elems) {
        this.checkRange(index, elems.length);
        this.doSetAll(index, elems);
    }

    protected void doSetAll(int index, short[] elems) {
        for (int i = 0; i < elems.length; ++i) {
            this.doSet(index + i, elems[i]);
        }
    }

    public void remove(int index, int len) {
        this.checkRange(index, len);
        this.doRemoveAll(index, len);
    }

    protected void doRemoveAll(int index, int len) {
        for (int i = index + len - 1; i >= index; --i) {
            this.doRemove(i);
        }
    }

    public void init(int len, short elem) {
        this.checkLength(len);
        int size = this.size();
        if (len < size) {
            this.remove(len, size - len);
            this.fill(0, len, elem);
        } else {
            this.fill(0, size, elem);
            for (int i = size; i < len; ++i) {
                this.add(elem);
            }
        }
        assert (this.size() == len);
    }

    public void resize(int len, short elem) {
        this.checkLength(len);
        int size = this.size();
        if (len < size) {
            this.remove(len, size - len);
        } else {
            for (int i = size; i < len; ++i) {
                this.add(elem);
            }
        }
        assert (this.size() == len);
    }

    public void fill(short elem) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            this.doSet(i, elem);
        }
    }

    public void fill(int index, int len, short elem) {
        this.checkRange(index, len);
        for (int i = 0; i < len; ++i) {
            this.doSet(index + i, elem);
        }
    }

    public void copy(int srcIndex, int dstIndex, int len) {
        block3: {
            block2: {
                this.checkRange(srcIndex, len);
                this.checkRange(dstIndex, len);
                if (srcIndex >= dstIndex) break block2;
                for (int i = len - 1; i >= 0; --i) {
                    this.doReSet(dstIndex + i, this.doGet(srcIndex + i));
                }
                break block3;
            }
            if (srcIndex <= dstIndex) break block3;
            for (int i = 0; i < len; ++i) {
                this.doReSet(dstIndex + i, this.doGet(srcIndex + i));
            }
        }
    }

    public void move(int srcIndex, int dstIndex, int len) {
        int fill;
        int i;
        this.checkRange(srcIndex, len);
        this.checkRange(dstIndex, len);
        if (srcIndex < dstIndex) {
            for (i = len - 1; i >= 0; --i) {
                this.doReSet(dstIndex + i, this.doGet(srcIndex + i));
            }
        } else if (srcIndex > dstIndex) {
            for (i = 0; i < len; ++i) {
                this.doReSet(dstIndex + i, this.doGet(srcIndex + i));
            }
        }
        if (srcIndex < dstIndex) {
            fill = Math.min(len, dstIndex - srcIndex);
            this.fill(srcIndex, fill, (short)0);
        } else if (srcIndex > dstIndex) {
            fill = Math.min(len, srcIndex - dstIndex);
            this.fill(srcIndex + len - fill, fill, (short)0);
        }
    }

    public void reverse() {
        this.reverse(0, this.size());
    }

    public void reverse(int index, int len) {
        this.checkRange(index, len);
        int pos1 = index;
        int pos2 = index + len - 1;
        int mid = len / 2;
        for (int i = 0; i < mid; ++i) {
            short swap = this.doGet(pos1);
            swap = this.doReSet(pos2, swap);
            this.doReSet(pos1, swap);
            ++pos1;
            --pos2;
        }
    }

    public void swap(int index1, int index2, int len) {
        this.checkRange(index1, len);
        this.checkRange(index2, len);
        if (index1 < index2 && index1 + len > index2 || index1 > index2 && index2 + len > index1) {
            throw new IllegalArgumentException("Swap ranges overlap");
        }
        for (int i = 0; i < len; ++i) {
            short swap = this.doGet(index1 + i);
            swap = this.doReSet(index2 + i, swap);
            this.doReSet(index1 + i, swap);
        }
    }

    public void rotate(int distance) {
        this.rotate(0, this.size(), distance);
    }

    public void rotate(int index, int len, int distance) {
        this.checkRange(index, len);
        int size = this.size();
        if ((distance %= size) < 0) {
            distance += size;
        }
        if (distance == 0) {
            return;
        }
        int num = 0;
        int start = 0;
        while (num != size) {
            short elem = this.doGet(index + start);
            int i = start;
            do {
                if ((i += distance) >= len) {
                    i -= len;
                }
                elem = this.doReSet(index + i, elem);
                ++num;
            } while (i != start);
            ++start;
        }
    }

    public void sort() {
        this.sort(0, this.size());
    }

    public abstract void sort(int var1, int var2);

    public int binarySearch(short key) {
        return this.binarySearch(0, this.size(), key);
    }

    public abstract int binarySearch(int var1, int var2, short var3);

    protected void checkIndex(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException("Invalid index: " + index + " (size: " + this.size() + ")");
        }
    }

    protected void checkIndexAdd(int index) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException("Invalid index: " + index + " (size: " + this.size() + ")");
        }
    }

    protected void checkRange(int index, int len) {
        if (index < 0 || len < 0 || index + len > this.size()) {
            throw new IndexOutOfBoundsException("Invalid range: " + index + "/" + len + " (size: " + this.size() + ")");
        }
    }

    protected void checkLength(int length) {
        if (length < 0) {
            throw new IndexOutOfBoundsException("Invalid length: " + length);
        }
    }
}

