/*
 * Decompiled with CFR 0.152.
 */
package org.magicwerk.brownies.collections;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.magicwerk.brownies.collections.CollectionAsSet;
import org.magicwerk.brownies.collections.GapList;
import org.magicwerk.brownies.collections.KeyCollectionImpl;

public class KeyCollectionAsMap<E, K>
implements Map<K, E>,
Serializable {
    KeyCollectionImpl<E> coll;
    int keyIndex;
    boolean immutable;

    public KeyCollectionAsMap(KeyCollectionImpl<E> coll, int keyIndex, boolean immutable) {
        if (coll == null) {
            throw new IllegalArgumentException("Collection may not be null");
        }
        this.coll = coll;
        this.keyIndex = keyIndex;
        this.immutable = immutable;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        if (m.size() != this.size()) {
            return false;
        }
        try {
            for (Map.Entry<K, E> e : this.entrySet()) {
                K key = e.getKey();
                E value = e.getValue();
                if (!(value == null ? m.get(key) != null || !m.containsKey(key) : !value.equals(m.get(key)))) continue;
                return false;
            }
        }
        catch (ClassCastException unused) {
            return false;
        }
        catch (NullPointerException unused) {
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return this.coll.hashCode();
    }

    public String toString() {
        return this.coll.toString();
    }

    @Override
    public int size() {
        return this.coll.size();
    }

    @Override
    public boolean isEmpty() {
        return this.coll.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.coll.containsKey(this.keyIndex, key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.coll.contains(value);
    }

    @Override
    public E get(Object key) {
        return this.coll.getByKey(this.keyIndex, key);
    }

    @Override
    public Set<K> keySet() {
        return new CollectionAsSet(this.coll.getDistinctKeys(this.keyIndex), true);
    }

    @Override
    public Set<Map.Entry<K, E>> entrySet() {
        Set<?> keys = this.coll.getDistinctKeys(this.keyIndex);
        GapList entries = new GapList(keys.size());
        for (Object key : keys) {
            E elem = this.coll.getByKey(this.keyIndex, key);
            entries.add(new MapEntry(key, elem));
        }
        return new CollectionAsSet<Map.Entry<K, E>>(entries, true);
    }

    @Override
    public Collection<E> values() {
        if (this.immutable) {
            return Collections.unmodifiableCollection(this.coll);
        }
        return this.coll;
    }

    void checkMutable() {
        if (this.immutable) {
            throw new UnsupportedOperationException("Map is immutable");
        }
    }

    @Override
    public void clear() {
        this.checkMutable();
        this.coll.clear();
    }

    @Override
    public E put(K key, E elem) {
        this.checkMutable();
        if (!GapList.equalsElem(key, this.coll.getKey(this.keyIndex, elem))) {
            KeyCollectionImpl.errorInvalidData();
        }
        if (this.coll.containsKey(1, key)) {
            E oldElem = this.coll.removeByKey(this.keyIndex, key);
            this.coll.add(elem);
            return oldElem;
        }
        this.coll.add(elem);
        return null;
    }

    @Override
    public E remove(Object key) {
        this.checkMutable();
        return this.coll.removeByKey(this.keyIndex, key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends E> map) {
        for (Map.Entry<K, E> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    static class MapEntry<K, E>
    implements Map.Entry<K, E> {
        K key;
        E elem;

        MapEntry(K key, E elem) {
            this.key = key;
            this.elem = elem;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public E getValue() {
            return this.elem;
        }

        @Override
        public E setValue(E value) {
            throw new AssertionError();
        }

        public String toString() {
            return "MapEntry [key=" + this.key + ", elem=" + this.elem + "]";
        }
    }
}

