/*
 * Decompiled with CFR 0.152.
 */
package org.magicwerk.brownies.collections.primitive;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.magicwerk.brownies.collections.GapList;
import org.magicwerk.brownies.collections.IList;
import org.magicwerk.brownies.collections.function.IFunction;
import org.magicwerk.brownies.collections.function.IPredicate;
import org.magicwerk.brownies.collections.primitive.ByteObjBigList;
import org.magicwerk.brownies.collections.primitive.ByteObjGapList;

public abstract class IByteList
implements Cloneable,
Serializable {
    private static final int TRANSFER_COPY = 0;
    private static final int TRANSFER_MOVE = 1;
    private static final int TRANSFER_REMOVE = 2;

    static byte[] toArray(Collection<Byte> coll) {
        Object[] values = coll.toArray();
        byte[] v = new byte[values.length];
        for (int i = 0; i < values.length; ++i) {
            v[i] = (Byte)values[i];
        }
        return v;
    }

    public IByteList copy() {
        return (IByteList)this.clone();
    }

    public abstract IByteList unmodifiableList();

    public Object clone() {
        try {
            IByteList list = (IByteList)super.clone();
            list.doClone(this);
            return list;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    protected abstract void doClone(IByteList var1);

    public void clear() {
        this.doClear();
    }

    protected void doClear() {
        this.doRemoveAll(0, this.size());
    }

    public void resize(int len, byte elem) {
        this.checkLength(len);
        int size = this.size();
        if (len < size) {
            this.remove(len, size - len);
        } else {
            for (int i = size; i < len; ++i) {
                this.add(elem);
            }
        }
        assert (this.size() == len);
    }

    public abstract int size();

    public abstract int capacity();

    public byte get(int index) {
        this.checkIndex(index);
        return this.doGet(index);
    }

    protected abstract byte doGet(int var1);

    protected abstract byte doSet(int var1, byte var2);

    public byte set(int index, byte elem) {
        this.checkIndex(index);
        return this.doSet(index, elem);
    }

    public byte put(int index, byte elem) {
        this.checkIndexAdd(index);
        if (index < this.size()) {
            return this.doSet(index, elem);
        }
        this.doAdd(-1, elem);
        return 0;
    }

    protected abstract byte doReSet(int var1, byte var2);

    protected abstract byte getDefaultElem();

    protected void doModify() {
    }

    public boolean add(byte elem) {
        return this.doAdd(-1, elem);
    }

    public void add(int index, byte elem) {
        this.checkIndexAdd(index);
        this.doAdd(index, elem);
    }

    protected abstract boolean doAdd(int var1, byte var2);

    public byte remove(int index) {
        this.checkIndex(index);
        return this.doRemove(index);
    }

    protected abstract byte doRemove(int var1);

    public void ensureCapacity(int minCapacity) {
        this.doModify();
        this.doEnsureCapacity(minCapacity);
    }

    protected abstract void doEnsureCapacity(int var1);

    public abstract void trimToSize();

    public boolean equals(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof ByteObjGapList) {
            obj = ((ByteObjGapList)obj).list;
        } else if (obj instanceof ByteObjBigList) {
            obj = ((ByteObjBigList)obj).list;
        }
        if (!(obj instanceof IByteList)) {
            return false;
        }
        IByteList list = (IByteList)obj;
        int size = this.size();
        if (size != list.size()) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            if (IByteList.equalsElem(this.doGet(i), list.get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            byte elem = this.doGet(i);
            hashCode = 31 * hashCode + IByteList.hashCodeElem(elem);
        }
        return hashCode;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(this.doGet(i));
        }
        buf.append("]");
        return buf.toString();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    static boolean equalsElem(byte elem1, byte elem2) {
        return elem1 == elem2;
    }

    static int hashCodeElem(byte elem) {
        return elem;
    }

    public int getCount(byte elem) {
        int count = 0;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (!IByteList.equalsElem(this.doGet(i), elem)) continue;
            ++count;
        }
        return count;
    }

    public IByteList getAll(byte elem) {
        IByteList list = this.doCreate(-1);
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            byte e = this.doGet(i);
            if (!IByteList.equalsElem(e, elem)) continue;
            list.add(e);
        }
        return list;
    }

    public IByteList getWhere(IPredicate predicate) {
        IByteList list = this.doCreate(-1);
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            byte e = this.doGet(i);
            if (!predicate.test(e)) continue;
            list.add(e);
        }
        return list;
    }

    public void removeWhere(IPredicate predicate) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            byte e = this.doGet(i);
            if (!predicate.test(e)) continue;
            this.doRemove(i);
            --size;
            --i;
        }
    }

    public void retainWhere(IPredicate predicate) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            byte e = this.doGet(i);
            if (predicate.test(e)) continue;
            this.doRemove(i);
            --size;
            --i;
        }
    }

    public IByteList extractWhere(IPredicate predicate) {
        IByteList list = this.doCreate(-1);
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            byte e = this.doGet(i);
            if (!predicate.test(e)) continue;
            list.add(e);
            this.doRemove(i);
            --size;
            --i;
        }
        return list;
    }

    public Set getDistinct() {
        HashSet<Byte> set = new HashSet<Byte>();
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            set.add(this.doGet(i));
        }
        return set;
    }

    public <R> IList<R> mappedList(IFunction<Byte, R> mapper) {
        int size = this.size();
        GapList<R> mappedList = new GapList<R>(size);
        for (int i = 0; i < size; ++i) {
            byte e = this.doGet(i);
            ((IList)mappedList).add(mapper.apply(e));
        }
        return mappedList;
    }

    public void filter(IPredicate<Byte> predicate) {
        IByteList list = this.doCreate(-1);
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            byte e = this.doGet(i);
            if (!predicate.test(e)) continue;
            list.add(e);
        }
        this.doAssign(list);
    }

    public int indexOf(byte elem) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (!IByteList.equalsElem(this.doGet(i), elem)) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(byte elem) {
        for (int i = this.size() - 1; i >= 0; --i) {
            if (!IByteList.equalsElem(this.doGet(i), elem)) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(byte elem, int fromIndex) {
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        int size = this.size();
        for (int i = fromIndex; i < size; ++i) {
            if (!IByteList.equalsElem(this.doGet(i), elem)) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(byte elem, int fromIndex) {
        int size = this.size();
        if (fromIndex >= size) {
            fromIndex = size - 1;
        }
        for (int i = fromIndex; i >= 0; --i) {
            if (!IByteList.equalsElem(this.doGet(i), elem)) continue;
            return i;
        }
        return -1;
    }

    public boolean removeElem(byte elem) {
        int index = this.indexOf(elem);
        if (index == -1) {
            return false;
        }
        this.doRemove(index);
        return true;
    }

    public boolean contains(byte elem) {
        return this.indexOf(elem) != -1;
    }

    public boolean addIfAbsent(byte elem) {
        if (this.contains(elem)) {
            return false;
        }
        return this.add(elem);
    }

    public boolean containsAny(Collection<Byte> coll) {
        for (byte elem : coll) {
            if (!this.contains(elem)) continue;
            return true;
        }
        return false;
    }

    public boolean containsAll(Collection<Byte> coll) {
        for (byte elem : coll) {
            if (this.contains(elem)) continue;
            return false;
        }
        return true;
    }

    public boolean removeAll(Collection<Byte> coll) {
        boolean modified = false;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (!coll.contains(this.doGet(i))) continue;
            this.doRemove(i);
            --size;
            --i;
            modified = true;
        }
        return modified;
    }

    public IByteList removeAll(byte elem) {
        IByteList list = this.doCreate(-1);
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            byte e = this.doGet(i);
            if (!IByteList.equalsElem(elem, e)) continue;
            list.add(e);
            this.doRemove(i);
            --size;
            --i;
        }
        return list;
    }

    public boolean removeAll(IByteList coll) {
        boolean modified = false;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (!coll.contains(this.doGet(i))) continue;
            this.doRemove(i);
            --size;
            --i;
            modified = true;
        }
        return modified;
    }

    public boolean retainAll(Collection<Byte> coll) {
        boolean modified = false;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (coll.contains(this.doGet(i))) continue;
            this.doRemove(i);
            --size;
            --i;
            modified = true;
        }
        return modified;
    }

    public boolean retainAll(IByteList coll) {
        boolean modified = false;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (coll.contains(this.doGet(i))) continue;
            this.doRemove(i);
            --size;
            --i;
            modified = true;
        }
        return modified;
    }

    public byte[] toArray() {
        int size = this.size();
        byte[] array = new byte[size];
        this.doGetAll(array, 0, size);
        return array;
    }

    public byte[] toArray(int index, int len) {
        byte[] array = new byte[len];
        this.doGetAll(array, index, len);
        return array;
    }

    public byte[] toArray(byte[] array) {
        int size = this.size();
        if (array.length < size) {
            array = (byte[])Array.newInstance(array.getClass().getComponentType(), size);
        }
        this.doGetAll(array, 0, size);
        if (array.length > size) {
            array[size] = 0;
        }
        return array;
    }

    protected void doGetAll(byte[] array, int index, int len) {
        for (int i = 0; i < len; ++i) {
            array[i] = this.doGet(index + i);
        }
    }

    protected boolean doAddAll(int index, IByteList list) {
        int listSize = list.size();
        this.doEnsureCapacity(this.size() + listSize);
        if (listSize == 0) {
            return false;
        }
        boolean changed = false;
        int prevSize = this.size();
        for (int i = 0; i < listSize; ++i) {
            byte elem = list.get(i);
            if (!this.doAdd(index, elem)) continue;
            changed = true;
            if (index == -1 || prevSize == this.size()) continue;
            prevSize = this.size();
            ++index;
        }
        return changed;
    }

    public byte peek() {
        if (this.size() == 0) {
            return 0;
        }
        return this.getFirst();
    }

    public byte element() {
        if (this.size() == 0) {
            throw new NoSuchElementException();
        }
        return this.doGet(0);
    }

    public byte poll() {
        if (this.size() == 0) {
            return 0;
        }
        return this.doRemove(0);
    }

    public byte remove() {
        if (this.size() == 0) {
            throw new NoSuchElementException();
        }
        return this.doRemove(0);
    }

    public boolean offer(byte elem) {
        return this.doAdd(-1, elem);
    }

    public byte getFirst() {
        if (this.size() == 0) {
            throw new NoSuchElementException();
        }
        return this.doGet(0);
    }

    public byte getLast() {
        int size = this.size();
        if (size == 0) {
            throw new NoSuchElementException();
        }
        return this.doGet(size - 1);
    }

    public void addFirst(byte elem) {
        this.doAdd(0, elem);
    }

    public void addLast(byte elem) {
        this.doAdd(-1, elem);
    }

    public byte removeFirst() {
        if (this.size() == 0) {
            throw new NoSuchElementException();
        }
        return this.doRemove(0);
    }

    public byte removeLast() {
        int size = this.size();
        if (size == 0) {
            throw new NoSuchElementException();
        }
        return this.doRemove(size - 1);
    }

    public boolean offerFirst(byte elem) {
        this.doAdd(0, elem);
        return true;
    }

    public boolean offerLast(byte elem) {
        this.doAdd(-1, elem);
        return true;
    }

    public byte peekFirst() {
        if (this.size() == 0) {
            return 0;
        }
        return this.doGet(0);
    }

    public byte peekLast() {
        int size = this.size();
        if (size == 0) {
            return 0;
        }
        return this.doGet(size - 1);
    }

    public byte pollFirst() {
        if (this.size() == 0) {
            return 0;
        }
        return this.doRemove(0);
    }

    public byte pollLast() {
        int size = this.size();
        if (size == 0) {
            return 0;
        }
        return this.doRemove(size - 1);
    }

    public byte pop() {
        if (this.size() == 0) {
            throw new NoSuchElementException();
        }
        return this.doRemove(0);
    }

    public void push(byte elem) {
        this.doAdd(0, elem);
    }

    public boolean removeFirstOccurrence(byte elem) {
        int index = this.indexOf(elem);
        if (index == -1) {
            return false;
        }
        this.doRemove(index);
        return true;
    }

    public boolean removeLastOccurrence(byte elem) {
        int index = this.lastIndexOf(elem);
        if (index == -1) {
            return false;
        }
        this.doRemove(index);
        return true;
    }

    public static void transferCopy(IByteList src, int srcIndex, int srcLen, IByteList dst, int dstIndex, int dstLen) {
        if (src == dst) {
            src.checkLengths(srcLen, dstLen);
            src.copy(srcIndex, dstIndex, srcLen);
        } else {
            src.doTransfer(0, srcIndex, srcLen, dst, dstIndex, dstLen);
        }
    }

    public static void transferMove(IByteList src, int srcIndex, int srcLen, IByteList dst, int dstIndex, int dstLen) {
        if (src == dst) {
            src.checkLengths(srcLen, dstLen);
            src.move(srcIndex, dstIndex, srcLen);
        } else {
            src.doTransfer(1, srcIndex, srcLen, dst, dstIndex, dstLen);
        }
    }

    public static void transferRemove(IByteList src, int srcIndex, int srcLen, IByteList dst, int dstIndex, int dstLen) {
        if (src == dst) {
            src.checkLengths(srcLen, dstLen);
            src.drag(srcIndex, dstIndex, srcLen);
        } else {
            src.doTransfer(2, srcIndex, srcLen, dst, dstIndex, dstLen);
        }
    }

    void doTransfer(int transferMode, int srcIndex, int srcLen, IByteList dst, int dstIndex, int dstLen) {
        this.checkRange(srcIndex, srcLen);
        if (dstIndex == -1) {
            dstIndex = dst.size();
        } else {
            dst.checkIndexAdd(dstIndex);
        }
        if (dstLen == -1) {
            dstLen = dst.size() - dstIndex;
        } else {
            dst.checkLength(dstLen);
        }
        byte defaultElem = this.getDefaultElem();
        if (dstLen > srcLen) {
            dst.remove(dstIndex, dstLen - srcLen);
        } else if (srcLen > dstLen) {
            dst.addMult(dstIndex, srcLen - dstLen, defaultElem);
        }
        if (transferMode == 1) {
            for (int i = 0; i < srcLen; ++i) {
                byte elem = this.doReSet(srcIndex + i, defaultElem);
                dst.doSet(dstIndex + i, elem);
            }
        } else {
            for (int i = 0; i < srcLen; ++i) {
                byte elem = this.doGet(srcIndex + i);
                dst.doSet(dstIndex + i, elem);
            }
            if (transferMode == 2) {
                this.remove(srcIndex, srcLen);
            }
        }
    }

    public static void transferSwap(IByteList src, int srcIndex, IByteList dst, int dstIndex, int len) {
        if (src == dst) {
            src.swap(srcIndex, dstIndex, len);
        } else {
            src.doTransferSwap(srcIndex, dst, dstIndex, len);
        }
    }

    void doTransferSwap(int srcIndex, IByteList dst, int dstIndex, int len) {
        this.checkRange(srcIndex, len);
        dst.checkRange(dstIndex, len);
        for (int i = 0; i < len; ++i) {
            byte swap = this.doGet(srcIndex + i);
            swap = dst.doSet(dstIndex + i, swap);
            this.doSet(srcIndex + i, swap);
        }
    }

    protected abstract IByteList doCreate(int var1);

    protected abstract void doAssign(IByteList var1);

    public IByteList getAll(int index, int len) {
        this.checkRange(index, len);
        IByteList list = this.doCreate(len);
        for (int i = 0; i < len; ++i) {
            list.add(this.doGet(index + i));
        }
        return list;
    }

    public IByteList extract(int index, int len) {
        this.checkRange(index, len);
        IByteList list = this.doCreate(len);
        for (int i = 0; i < len; ++i) {
            list.add(this.doGet(index + i));
        }
        this.remove(index, len);
        return list;
    }

    public byte[] getArray(int index, int len) {
        this.checkRange(index, len);
        byte[] array = new byte[len];
        for (int i = 0; i < len; ++i) {
            array[i] = this.doGet(index + i);
        }
        return array;
    }

    public void remove(int index, int len) {
        this.checkRange(index, len);
        this.doRemoveAll(index, len);
    }

    protected void doRemoveAll(int index, int len) {
        for (int i = index + len - 1; i >= index; --i) {
            this.doRemove(i);
        }
    }

    public boolean addAll(IByteList list) {
        return this.doAddAll(-1, list);
    }

    public boolean addAll(int index, IByteList list) {
        this.checkIndexAdd(index);
        return this.doAddAll(index, list);
    }

    public boolean addAll(Collection<Byte> coll) {
        if (coll instanceof List) {
            return this.doAddAll(-1, new IReadOnlyByteListFromList((List)coll));
        }
        return this.doAddAll(-1, new IReadOnlyByteListFromCollection(coll));
    }

    public boolean addAll(int index, Collection<Byte> coll) {
        this.checkIndexAdd(index);
        if (coll instanceof List) {
            return this.doAddAll(index, new IReadOnlyByteListFromList((List)coll));
        }
        return this.doAddAll(index, new IReadOnlyByteListFromCollection(coll));
    }

    public boolean addArray(byte ... elems) {
        return this.doAddAll(-1, new IReadOnlyByteListFromArray(elems));
    }

    public boolean addArray(int index, byte ... elems) {
        this.checkIndexAdd(index);
        return this.doAddAll(index, new IReadOnlyByteListFromArray(elems));
    }

    public boolean addMult(int len, byte elem) {
        return this.doAddAll(-1, new IReadOnlyByteListFromMult(len, elem));
    }

    public boolean addMult(int index, int len, byte elem) {
        this.checkIndexAdd(index);
        return this.doAddAll(index, new IReadOnlyByteListFromMult(len, elem));
    }

    public void setAll(int index, IByteList list) {
        int listSize = list.size();
        this.checkRange(index, listSize);
        this.doReplaceAll(index, listSize, list);
    }

    public void setAll(int index, Collection<Byte> coll) {
        int collSize = coll.size();
        this.checkRange(index, collSize);
        if (coll instanceof List) {
            this.doReplaceAll(index, collSize, new IReadOnlyByteListFromList((List)coll));
        } else {
            this.doReplaceAll(index, collSize, new IReadOnlyByteListFromCollection(coll));
        }
    }

    public void setArray(int index, byte ... elems) {
        int arrayLen = elems.length;
        this.checkRange(index, arrayLen);
        this.doReplaceAll(index, arrayLen, new IReadOnlyByteListFromArray(elems));
    }

    public void setMult(int index, int len, byte elem) {
        this.checkRange(index, len);
        this.doReplaceAll(index, len, new IReadOnlyByteListFromMult(len, elem));
    }

    public void putAll(int index, IByteList list) {
        this.checkIndexAdd(index);
        this.checkNonNull(list);
        int len = this.size() - index;
        if (list != null && list.size() < len) {
            len = list.size();
        }
        this.doReplaceAll(index, len, list);
    }

    public void putAll(int index, Collection<Byte> coll) {
        if (coll instanceof IByteList) {
            this.putAll(index, (IByteList)((Object)coll));
        } else if (coll instanceof List) {
            this.putAll(index, new IReadOnlyByteListFromList((List)coll));
        } else {
            this.putAll(index, new IReadOnlyByteListFromCollection(coll));
        }
    }

    public void putArray(int index, byte ... elems) {
        this.putAll(index, new IReadOnlyByteListFromArray(elems));
    }

    public void putMult(int index, int len, byte elem) {
        this.putAll(index, new IReadOnlyByteListFromMult(len, elem));
    }

    public void initAll(IByteList list) {
        this.checkNonNull(list);
        this.doReplaceAll(0, this.size(), list);
    }

    public void initAll(Collection<Byte> coll) {
        if (coll instanceof IByteList) {
            this.initAll((IByteList)((Object)coll));
        } else if (coll instanceof List) {
            this.initAll(new IReadOnlyByteListFromList((List)coll));
        } else {
            this.initAll(new IReadOnlyByteListFromCollection(coll));
        }
    }

    public void initArray(byte ... elems) {
        this.initAll(new IReadOnlyByteListFromArray(elems));
    }

    public void initMult(int len, byte elem) {
        this.checkLength(len);
        this.initAll(new IReadOnlyByteListFromMult(len, elem));
    }

    public void replaceAll(int index, int len, Collection<Byte> coll) {
        if (coll instanceof IByteList) {
            this.replaceAll(index, len, (IByteList)((Object)coll));
        } else if (coll instanceof List) {
            this.replaceAll(index, len, new IReadOnlyByteListFromList((List)coll));
        } else {
            this.replaceAll(index, len, new IReadOnlyByteListFromCollection(coll));
        }
    }

    public void replaceArray(int index, int len, byte ... elems) {
        this.replaceAll(index, len, new IReadOnlyByteListFromArray(elems));
    }

    public void replaceMult(int index, int len, int numElems, byte elem) {
        this.replaceAll(index, len, new IReadOnlyByteListFromMult(numElems, elem));
    }

    public void replaceAll(int index, int len, IByteList list) {
        if (index == -1) {
            index = this.size();
        } else {
            this.checkIndexAdd(index);
        }
        if (len == -1) {
            len = this.size() - index;
            if (list != null && list.size() < len) {
                len = list.size();
            }
        } else {
            this.checkRange(index, len);
        }
        this.doReplaceAll(index, len, list);
    }

    protected boolean doReplaceAll(int index, int len, IByteList list) {
        int i;
        assert (index >= 0 && index <= this.size());
        assert (len >= 0 && index + len <= this.size());
        int srcLen = 0;
        if (list != null) {
            srcLen = list.size();
        }
        this.doEnsureCapacity(this.size() - len + srcLen);
        if (len > srcLen) {
            this.doRemoveAll(index, len - srcLen);
            len = srcLen;
        }
        for (i = 0; i < len; ++i) {
            this.doSet(index + i, list.doGet(i));
        }
        for (i = len; i < srcLen; ++i) {
            if (this.doAdd(index + i, list.doGet(i))) continue;
            --index;
        }
        return len > 0 || srcLen > 0;
    }

    public void fill(byte elem) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            this.doSet(i, elem);
        }
    }

    public void copy(int srcIndex, int dstIndex, int len) {
        block3: {
            block2: {
                this.checkRange(srcIndex, len);
                this.checkRange(dstIndex, len);
                if (srcIndex >= dstIndex) break block2;
                for (int i = len - 1; i >= 0; --i) {
                    this.doReSet(dstIndex + i, this.doGet(srcIndex + i));
                }
                break block3;
            }
            if (srcIndex <= dstIndex) break block3;
            for (int i = 0; i < len; ++i) {
                this.doReSet(dstIndex + i, this.doGet(srcIndex + i));
            }
        }
    }

    public void move(int srcIndex, int dstIndex, int len) {
        int fill;
        int i;
        this.checkRange(srcIndex, len);
        this.checkRange(dstIndex, len);
        if (srcIndex < dstIndex) {
            for (i = len - 1; i >= 0; --i) {
                this.doReSet(dstIndex + i, this.doGet(srcIndex + i));
            }
        } else if (srcIndex > dstIndex) {
            for (i = 0; i < len; ++i) {
                this.doReSet(dstIndex + i, this.doGet(srcIndex + i));
            }
        }
        if (srcIndex < dstIndex) {
            fill = Math.min(len, dstIndex - srcIndex);
            this.setMult(srcIndex, fill, (byte)0);
        } else if (srcIndex > dstIndex) {
            fill = Math.min(len, srcIndex - dstIndex);
            this.setMult(srcIndex + len - fill, fill, (byte)0);
        }
    }

    public void drag(int srcIndex, int dstIndex, int len) {
        this.checkRange(srcIndex, len);
        this.checkRange(dstIndex, len);
        if (srcIndex < dstIndex) {
            this.doRotate(srcIndex, len + (dstIndex - srcIndex), dstIndex - srcIndex);
        } else if (srcIndex > dstIndex) {
            this.doRotate(dstIndex, len + (srcIndex - dstIndex), dstIndex - srcIndex);
        }
    }

    public void swap(int index1, int index2, int len) {
        this.checkRange(index1, len);
        this.checkRange(index2, len);
        if (index1 < index2 && index1 + len > index2 || index1 > index2 && index2 + len > index1) {
            throw new IndexOutOfBoundsException("Swap ranges overlap");
        }
        for (int i = 0; i < len; ++i) {
            byte swap = this.doGet(index1 + i);
            swap = this.doReSet(index2 + i, swap);
            this.doReSet(index1 + i, swap);
        }
    }

    public void reverse() {
        this.reverse(0, this.size());
    }

    public void reverse(int index, int len) {
        this.checkRange(index, len);
        int pos1 = index;
        int pos2 = index + len - 1;
        int mid = len / 2;
        for (int i = 0; i < mid; ++i) {
            byte swap = this.doGet(pos1);
            swap = this.doReSet(pos2, swap);
            this.doReSet(pos1, swap);
            ++pos1;
            --pos2;
        }
    }

    public void rotate(int distance) {
        this.rotate(0, this.size(), distance);
    }

    public void rotate(int index, int len, int distance) {
        this.checkRange(index, len);
        this.doRotate(index, len, distance);
    }

    protected void doRotate(int index, int len, int distance) {
        if ((distance %= len) < 0) {
            distance += len;
        }
        if (distance == 0) {
            return;
        }
        assert (distance >= 0 && distance < len);
        int num = 0;
        int start = 0;
        while (num != len) {
            byte elem = this.doGet(index + start);
            int i = start;
            do {
                if ((i += distance) >= len) {
                    i -= len;
                }
                elem = this.doReSet(index + i, elem);
                ++num;
            } while (i != start);
            ++start;
        }
    }

    public void sort() {
        this.sort(0, this.size());
    }

    public abstract void sort(int var1, int var2);

    public int binarySearch(byte key) {
        return this.binarySearch(0, this.size(), key);
    }

    public abstract int binarySearch(int var1, int var2, byte var3);

    protected void checkIndex(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException("Invalid index: " + index + " (size: " + this.size() + ")");
        }
    }

    protected void checkIndexAdd(int index) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException("Invalid index: " + index + " (size: " + this.size() + ")");
        }
    }

    protected void checkRange(int index, int len) {
        if (index < 0 || len < 0 || index + len > this.size()) {
            throw new IndexOutOfBoundsException("Invalid range: " + index + "/" + len + " (size: " + this.size() + ")");
        }
    }

    protected void checkLength(int len) {
        if (len < 0) {
            throw new IndexOutOfBoundsException("Invalid length: " + len);
        }
    }

    protected void checkLengths(int len1, int len2) {
        if (len1 != len2) {
            throw new IndexOutOfBoundsException("Invalid lengths: " + len1 + ", " + len2);
        }
        if (len1 < 0) {
            throw new IndexOutOfBoundsException("Invalid length: " + len1);
        }
        if (len2 < 0) {
            throw new IndexOutOfBoundsException("Invalid length: " + len2);
        }
    }

    protected void checkNonNull(Object obj) {
        if (obj == null) {
            throw new NullPointerException("Argument may not be (byte) 0");
        }
    }

    protected static class IReadOnlyByteListFromList
    extends IReadOnlyByteList {
        List<Byte> list2;

        IReadOnlyByteListFromList(List<Byte> list) {
            this.list2 = list;
        }

        @Override
        public int size() {
            return this.list2.size();
        }

        @Override
        protected byte doGet(int index) {
            return this.list2.get(index);
        }
    }

    protected static class IReadOnlyByteListFromCollection
    extends IReadOnlyByteList {
        byte[] array;

        IReadOnlyByteListFromCollection(Collection<Byte> coll) {
            this.array = IReadOnlyByteListFromCollection.toArray(coll);
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        protected byte doGet(int index) {
            return this.array[index];
        }
    }

    protected static class IReadOnlyByteListFromMult
    extends IReadOnlyByteList {
        int len;
        byte elem;

        IReadOnlyByteListFromMult(int len, byte elem) {
            this.len = len;
            this.elem = elem;
        }

        @Override
        public int size() {
            return this.len;
        }

        @Override
        protected byte doGet(int index) {
            return this.elem;
        }
    }

    protected static class IReadOnlyByteListFromArray
    extends IReadOnlyByteList {
        byte[] array;

        IReadOnlyByteListFromArray(byte[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        protected byte doGet(int index) {
            return this.array[index];
        }
    }

    protected static abstract class IReadOnlyByteList
    extends IByteList {
        protected IReadOnlyByteList() {
        }

        @Override
        public IByteList unmodifiableList() {
            this.error();
            return null;
        }

        @Override
        protected void doClone(IByteList that) {
            this.error();
        }

        @Override
        public int capacity() {
            this.error();
            return 0;
        }

        @Override
        protected byte doSet(int index, byte elem) {
            this.error();
            return 0;
        }

        @Override
        protected byte doReSet(int index, byte elem) {
            this.error();
            return 0;
        }

        @Override
        protected byte getDefaultElem() {
            this.error();
            return 0;
        }

        @Override
        protected boolean doAdd(int index, byte elem) {
            this.error();
            return false;
        }

        @Override
        protected byte doRemove(int index) {
            this.error();
            return 0;
        }

        @Override
        protected void doEnsureCapacity(int minCapacity) {
            this.error();
        }

        @Override
        public void trimToSize() {
            this.error();
        }

        @Override
        protected IByteList doCreate(int capacity) {
            this.error();
            return null;
        }

        @Override
        protected void doAssign(IByteList that) {
            this.error();
        }

        @Override
        public void sort(int index, int len) {
            this.error();
        }

        @Override
        public int binarySearch(int index, int len, byte key) {
            this.error();
            return 0;
        }

        private void error() {
            throw new UnsupportedOperationException("list is read-only");
        }
    }
}

