/*
 * Decompiled with CFR 0.152.
 */
package com.planetj.math.rabinhash;

final class RabinHashFunctionUtils {
    private static final int BIT_32 = Integer.MIN_VALUE;
    private static final long BIT_64 = Long.MIN_VALUE;

    private RabinHashFunctionUtils() {
    }

    static String polynomialToString(int P) {
        StringBuffer result = new StringBuffer();
        result.append("x^32");
        int exp = 31;
        int temp = P;
        while (temp != 0) {
            if ((temp & Integer.MIN_VALUE) != 0) {
                RabinHashFunctionUtils.appendTerm(exp, result);
            }
            temp <<= 1;
            --exp;
        }
        return result.toString();
    }

    static String polynomialToString(long P) {
        StringBuffer result = new StringBuffer();
        result.append("x^64");
        int exp = 63;
        long temp = P;
        while (temp != 0L) {
            if ((temp & Long.MIN_VALUE) != 0L) {
                RabinHashFunctionUtils.appendTerm(exp, result);
            }
            temp <<= 1;
            --exp;
        }
        return result.toString();
    }

    private static void appendTerm(int exp, StringBuffer result) {
        switch (exp) {
            case 0: {
                result.append(" + 1");
                break;
            }
            case 1: {
                result.append(" + x");
                break;
            }
            default: {
                result.append(" + x^");
                result.append(exp);
            }
        }
    }
}

