/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.io.scribe;

import ezvcard.io.CannotParseException;
import ezvcard.io.html.HCardElement;
import ezvcard.io.scribe.BinaryPropertyScribe;
import ezvcard.parameter.SoundType;
import ezvcard.property.Sound;
import ezvcard.util.DataUri;
import java.util.List;
import org.jsoup.nodes.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SoundScribe
extends BinaryPropertyScribe<Sound, SoundType> {
    public SoundScribe() {
        super(Sound.class, "SOUND");
    }

    @Override
    protected SoundType _buildTypeObj(String type) {
        return SoundType.get(type, null, null);
    }

    @Override
    protected SoundType _buildMediaTypeObj(String mediaType) {
        return SoundType.get(null, mediaType, null);
    }

    @Override
    protected Sound _newInstance(String uri, SoundType contentType) {
        return new Sound(uri, contentType);
    }

    @Override
    protected Sound _newInstance(byte[] data, SoundType contentType) {
        return new Sound(data, contentType);
    }

    @Override
    protected Sound _parseHtml(HCardElement element, List<String> warnings) {
        String src;
        String elementName = element.tagName();
        if (!"audio".equals(elementName) && !"source".equals(elementName)) {
            return (Sound)super._parseHtml(element, (List)warnings);
        }
        if ("audio".equals(elementName)) {
            Element source = element.getElement().getElementsByTag("source").first();
            if (source == null) {
                throw new CannotParseException(16, new Object[0]);
            }
            element = new HCardElement(source);
        }
        if ((src = element.absUrl("src")).length() == 0) {
            throw new CannotParseException(17, new Object[0]);
        }
        String type = element.attr("type");
        SoundType mediaType = type.length() == 0 ? null : this._buildMediaTypeObj(type);
        try {
            DataUri uri = new DataUri(src);
            mediaType = this._buildMediaTypeObj(uri.getContentType());
            return new Sound(uri.getData(), mediaType);
        }
        catch (IllegalArgumentException e) {
            return new Sound(src, null);
        }
    }
}

