/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.io.text;

import ezvcard.VCard;
import ezvcard.VCardDataType;
import ezvcard.VCardVersion;
import ezvcard.io.EmbeddedVCardException;
import ezvcard.io.SkipMeException;
import ezvcard.io.StreamWriter;
import ezvcard.io.scribe.VCardPropertyScribe;
import ezvcard.io.text.VCardRawWriter;
import ezvcard.parameter.VCardParameters;
import ezvcard.property.VCardProperty;
import ezvcard.util.IOUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VCardWriter
extends StreamWriter
implements Flushable {
    private final VCardRawWriter writer;
    private final LinkedList<Boolean> prodIdStack = new LinkedList();

    public VCardWriter(OutputStream out, VCardVersion targetVersion) {
        this(targetVersion == VCardVersion.V4_0 ? IOUtils.utf8Writer(out) : new OutputStreamWriter(out), targetVersion);
    }

    public VCardWriter(File file, VCardVersion targetVersion) throws IOException {
        this(file, false, targetVersion);
    }

    public VCardWriter(File file, boolean append, VCardVersion targetVersion) throws IOException {
        this(targetVersion == VCardVersion.V4_0 ? IOUtils.utf8Writer(file, append) : new FileWriter(file, append), targetVersion);
    }

    public VCardWriter(Writer writer, VCardVersion targetVersion) {
        this.writer = new VCardRawWriter(writer, targetVersion);
    }

    public VCardRawWriter getRawWriter() {
        return this.writer;
    }

    @Override
    public VCardVersion getTargetVersion() {
        return this.writer.getVersion();
    }

    public void setTargetVersion(VCardVersion targetVersion) {
        this.writer.setVersion(targetVersion);
    }

    public boolean isCaretEncodingEnabled() {
        return this.writer.isCaretEncodingEnabled();
    }

    public void setCaretEncodingEnabled(boolean enable) {
        this.writer.setCaretEncodingEnabled(enable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _write(VCard vcard, List<VCardProperty> propertiesToAdd) throws IOException {
        VCardVersion targetVersion = this.getTargetVersion();
        this.writer.writeBeginComponent("VCARD");
        this.writer.writeVersion();
        for (VCardProperty property : propertiesToAdd) {
            VCardDataType defaultDataType;
            VCardPropertyScribe<? extends VCardProperty> scribe = this.index.getPropertyScribe(property);
            String value = null;
            VCard nestedVCard = null;
            try {
                value = scribe.writeText(property, targetVersion);
            }
            catch (SkipMeException e) {
                continue;
            }
            catch (EmbeddedVCardException e) {
                nestedVCard = e.getVCard();
            }
            VCardParameters parameters = scribe.prepareParameters(property, targetVersion, vcard);
            if (nestedVCard != null) {
                if (targetVersion == VCardVersion.V2_1) {
                    this.writer.writeProperty(property.getGroup(), scribe.getPropertyName(), parameters, value);
                    this.prodIdStack.add(this.addProdId);
                    this.addProdId = false;
                    this.write(nestedVCard);
                    this.addProdId = this.prodIdStack.removeLast();
                    continue;
                }
                StringWriter sw = new StringWriter();
                VCardWriter agentWriter = new VCardWriter(sw, targetVersion);
                agentWriter.getRawWriter().getFoldedLineWriter().setLineLength(null);
                agentWriter.getRawWriter().getFoldedLineWriter().setNewline("\n");
                agentWriter.setAddProdId(false);
                agentWriter.setVersionStrict(this.versionStrict);
                try {
                    agentWriter.write(nestedVCard);
                }
                catch (IOException e) {
                }
                finally {
                    IOUtils.closeQuietly(agentWriter);
                }
                String vCardStr = sw.toString();
                vCardStr = VCardPropertyScribe.escape(vCardStr);
                this.writer.writeProperty(property.getGroup(), scribe.getPropertyName(), parameters, vCardStr);
                continue;
            }
            if (value == null) continue;
            VCardDataType dataType = scribe.dataType(property, targetVersion);
            if (dataType != null && dataType != (defaultDataType = scribe.defaultDataType(targetVersion)) && (defaultDataType != VCardDataType.DATE_AND_OR_TIME || dataType != VCardDataType.DATE && dataType != VCardDataType.DATE_TIME && dataType != VCardDataType.TIME)) {
                parameters.setValue(dataType);
            }
            this.writer.writeProperty(property.getGroup(), scribe.getPropertyName(), parameters, value);
        }
        this.writer.writeEndComponent("VCARD");
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }
}

