/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directory.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.directory.model.DescribeSnapshotsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class DescribeSnapshotsRequestMarshaller
implements Marshaller<Request<DescribeSnapshotsRequest>, DescribeSnapshotsRequest> {
    @Override
    public Request<DescribeSnapshotsRequest> marshall(DescribeSnapshotsRequest describeSnapshotsRequest) {
        if (describeSnapshotsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeSnapshotsRequest> request = new DefaultRequest<DescribeSnapshotsRequest>(describeSnapshotsRequest, "AWSDirectoryService");
        String target = "DirectoryService_20150416.DescribeSnapshots";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            ListWithAutoConstructFlag snapshotIdsList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (describeSnapshotsRequest.getDirectoryId() != null) {
                jsonWriter.key("DirectoryId").value(describeSnapshotsRequest.getDirectoryId());
            }
            if (!((snapshotIdsList = (ListWithAutoConstructFlag)describeSnapshotsRequest.getSnapshotIds()) == null || snapshotIdsList.isAutoConstruct() && snapshotIdsList.isEmpty())) {
                jsonWriter.key("SnapshotIds");
                jsonWriter.array();
                for (String snapshotIdsListValue : snapshotIdsList) {
                    if (snapshotIdsListValue == null) continue;
                    jsonWriter.value(snapshotIdsListValue);
                }
                jsonWriter.endArray();
            }
            if (describeSnapshotsRequest.getNextToken() != null) {
                jsonWriter.key("NextToken").value(describeSnapshotsRequest.getNextToken());
            }
            if (describeSnapshotsRequest.getLimit() != null) {
                jsonWriter.key("Limit").value(describeSnapshotsRequest.getLimit());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

