/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.obs.gradle.plugin;

import com.openexchange.obs.api.Architecture;
import com.openexchange.obs.api.BlockMode;
import com.openexchange.obs.api.BuildServiceException;
import com.openexchange.obs.api.BuildTrigger;
import com.openexchange.obs.gradle.plugin.Path;
import com.openexchange.obs.gradle.plugin.ProjectReference;
import com.openexchange.obs.gradle.plugin.RepositoryReference;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gradle.api.GradleException;
import org.gradle.api.Named;

public class Repository
implements Named {
    private String name;
    private Set<Architecture> archs = new HashSet<Architecture>(Arrays.asList(Architecture.x86_64));
    private BlockMode block = BlockMode.DEFAULT;
    private BuildTrigger rebuild = BuildTrigger.DEFAULT;
    private Set<Path> depends = new HashSet<Path>();

    public Repository(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void arch(Architecture arch) {
        this.archs.add(arch);
    }

    public BlockMode getBlock() {
        return this.block;
    }

    public void setBlock(BlockMode block) {
        this.block = block;
    }

    public BuildTrigger getRebuild() {
        return this.rebuild;
    }

    public void setRebuild(BuildTrigger rebuild) {
        this.rebuild = rebuild;
    }

    public void depends(Map<String, String> params) {
        ProjectReference project = null;
        RepositoryReference repository = null;
        for (Map.Entry<String, String> entry : params.entrySet()) {
            if ("project".equals(entry.getKey()) && null == project) {
                project = new ProjectReference(entry.getValue());
                continue;
            }
            if ("repository".equals(entry.getKey())) {
                repository = new RepositoryReference(entry.getValue());
                continue;
            }
            throw new GradleException("Could not set unknown property '" + entry.getKey() + "' for Path" + params.toString() + " of type " + Path.class.getName());
        }
        if (null == project || null == repository) {
            throw new GradleException("Could not create an instance of type " + Path.class.getName() + ".");
        }
        this.depends.add(new Path(project, repository));
    }

    public com.openexchange.obs.api.Repository convert() throws BuildServiceException {
        HashSet<com.openexchange.obs.api.Path> convertedPath = new HashSet<com.openexchange.obs.api.Path>();
        for (Path path : this.depends) {
            convertedPath.add(path.convert());
        }
        return new com.openexchange.obs.api.Repository(this.name, convertedPath, this.archs, this.rebuild, this.block);
    }
}

