/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.obs.api;

import com.openexchange.obs.api.BuildServiceException;
import com.openexchange.obs.api.ObsPackage;
import com.openexchange.obs.api.Tools;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class ObsPackageParser {
    private static final DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();

    private ObsPackageParser() {
    }

    public static ObsPackage[] parse(InputStream is) throws BuildServiceException {
        Document document;
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            document = db.parse(is);
            NodeList childs = document.getChildNodes();
            for (int i = 0; i < childs.getLength(); ++i) {
                Node node = childs.item(i);
                if ("directory".equals(node.getNodeName())) {
                    return ObsPackageParser.parseResult(node);
                }
                if (3 == node.getNodeType()) continue;
                throw new BuildServiceException("Unknown node in build result \"" + node.getNodeName() + "\".");
            }
        }
        catch (ParserConfigurationException e) {
            throw new BuildServiceException(e.getMessage(), e);
        }
        catch (SAXException e) {
            throw new BuildServiceException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new BuildServiceException(e.getMessage(), e);
        }
        throw new BuildServiceException("Unable to parse build result. " + Tools.transform(document));
    }

    private static ObsPackage[] parseResult(Node resultNode) throws BuildServiceException {
        NodeList childs = resultNode.getChildNodes();
        ArrayList<ObsPackage> packages = new ArrayList<ObsPackage>();
        for (int i = 0; i < childs.getLength(); ++i) {
            Node node = childs.item(i);
            if ("entry".equals(node.getNodeName())) {
                packages.add(ObsPackageParser.parseStatus(node));
                continue;
            }
            if (3 == node.getNodeType()) continue;
            throw new BuildServiceException("Unknown node in result \"" + node.getNodeName() + "\" \"" + node.getNodeValue() + "\".");
        }
        return packages.toArray(new ObsPackage[packages.size()]);
    }

    private static ObsPackage parseStatus(Node status) throws BuildServiceException {
        NamedNodeMap attributes = status.getAttributes();
        ObsPackage pkg = new ObsPackage(attributes.getNamedItem("name").getNodeValue());
        return pkg;
    }
}

