/*
 * Decompiled with CFR 0.152.
 */
package liquibase.diff.output.report;

import java.io.PrintStream;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import liquibase.diff.DiffResult;
import liquibase.diff.Difference;
import liquibase.diff.ObjectDifferences;
import liquibase.diff.StringDiff;
import liquibase.exception.DatabaseException;
import liquibase.structure.DatabaseObject;
import liquibase.structure.DatabaseObjectComparator;

public class DiffToReport {
    private DiffResult diffResult;
    private PrintStream out;

    public DiffToReport(DiffResult diffResult, PrintStream out) {
        this.diffResult = diffResult;
        this.out = out;
    }

    public void print() throws DatabaseException {
        DatabaseObjectComparator comparator = new DatabaseObjectComparator();
        this.out.println("Reference Database: " + this.diffResult.getReferenceSnapshot().getDatabase());
        this.out.println("Comparison Database: " + this.diffResult.getComparisonSnapshot().getDatabase());
        this.printComparison("Product Name", this.diffResult.getProductNameDiff(), this.out);
        this.printComparison("Product Version", this.diffResult.getProductVersionDiff(), this.out);
        TreeSet<Class<? extends DatabaseObject>> types = new TreeSet<Class<? extends DatabaseObject>>(new Comparator<Class<? extends DatabaseObject>>(){

            @Override
            public int compare(Class<? extends DatabaseObject> o1, Class<? extends DatabaseObject> o2) {
                return o1.getSimpleName().compareTo(o2.getSimpleName());
            }
        });
        types.addAll(this.diffResult.getCompareControl().getComparedTypes());
        for (Class<? extends DatabaseObject> type : types) {
            this.printSetComparison("Missing " + this.getTypeName(type), this.diffResult.getMissingObjects(type, comparator), this.out);
            this.printSetComparison("Unexpected " + this.getTypeName(type), this.diffResult.getUnexpectedObjects(type, comparator), this.out);
            this.printChangedComparison("Changed " + this.getTypeName(type), this.diffResult.getChangedObjects(type, comparator), this.out);
        }
    }

    protected String getTypeName(Class<? extends DatabaseObject> type) {
        return type.getSimpleName().replaceAll("([A-Z])", " $1").trim() + "(s)";
    }

    protected void printChangedComparison(String title, Map<? extends DatabaseObject, ObjectDifferences> objects, PrintStream out) {
        out.print(title + ": ");
        if (objects.size() == 0) {
            out.println("NONE");
        } else {
            out.println();
            for (Map.Entry<? extends DatabaseObject, ObjectDifferences> object : objects.entrySet()) {
                if (!object.getValue().hasDifferences()) continue;
                out.println("     " + object.getKey());
                for (Difference difference : object.getValue().getDifferences()) {
                    out.println("          " + difference.toString());
                }
            }
        }
    }

    protected void printSetComparison(String title, Set<?> objects, PrintStream out) {
        out.print(title + ": ");
        if (objects.size() == 0) {
            out.println("NONE");
        } else {
            out.println();
            for (Object object : objects) {
                out.println("     " + object);
            }
        }
    }

    protected void printComparison(String title, StringDiff string, PrintStream out) {
        out.print(title + ":");
        if (string == null) {
            out.print("NULL");
            return;
        }
        if (string.areEqual()) {
            out.println(" EQUAL");
        } else {
            out.println();
            out.println("     Reference:   '" + string.getReferenceVersion() + "'");
            out.println("     Target: '" + string.getTargetVersion() + "'");
        }
    }
}

