/*
 * Decompiled with CFR 0.152.
 */
package liquibase.snapshot;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import liquibase.CatalogAndSchema;
import liquibase.database.Database;
import liquibase.diff.compare.DatabaseObjectComparatorFactory;
import liquibase.exception.DatabaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.snapshot.InvalidExampleException;
import liquibase.snapshot.ResultSetCache;
import liquibase.snapshot.SnapshotControl;
import liquibase.snapshot.SnapshotGenerator;
import liquibase.snapshot.SnapshotGeneratorChain;
import liquibase.snapshot.SnapshotGeneratorFactory;
import liquibase.structure.DatabaseObject;
import liquibase.structure.DatabaseObjectCollection;
import liquibase.structure.core.Schema;

public abstract class DatabaseSnapshot {
    private SnapshotControl snapshotControl;
    private Database database;
    private DatabaseObjectCollection allFound;
    private Map<Class<? extends DatabaseObject>, Set<DatabaseObject>> knownNull = new HashMap<Class<? extends DatabaseObject>, Set<DatabaseObject>>();
    private Map<String, ResultSetCache> resultSetCaches = new HashMap<String, ResultSetCache>();

    DatabaseSnapshot(DatabaseObject[] examples, Database database, SnapshotControl snapshotControl) throws DatabaseException, InvalidExampleException {
        this.database = database;
        this.allFound = new DatabaseObjectCollection(database);
        this.snapshotControl = snapshotControl;
        if (examples != null) {
            for (DatabaseObject obj : examples) {
                this.snapshotControl.addType(obj.getClass(), database);
                this.include(obj);
            }
        }
    }

    public DatabaseSnapshot(DatabaseObject[] examples, Database database) throws DatabaseException, InvalidExampleException {
        this(examples, database, new SnapshotControl(database));
    }

    public SnapshotControl getSnapshotControl() {
        return this.snapshotControl;
    }

    public Database getDatabase() {
        return this.database;
    }

    public ResultSetCache getResultSetCache(String key) {
        if (!this.resultSetCaches.containsKey(key)) {
            this.resultSetCaches.put(key, new ResultSetCache());
        }
        return this.resultSetCaches.get(key);
    }

    protected <T extends DatabaseObject> T include(T example) throws DatabaseException, InvalidExampleException {
        if (example == null) {
            return null;
        }
        if (this.database.isSystemObject((DatabaseObject)example)) {
            return null;
        }
        if (example instanceof Schema && example.getName() == null && (((Schema)example).getCatalog() == null || ((Schema)example).getCatalogName() == null)) {
            CatalogAndSchema catalogAndSchema = this.database.correctSchema(((Schema)example).toCatalogAndSchema());
            example = new Schema(catalogAndSchema.getCatalogName(), catalogAndSchema.getSchemaName());
        }
        if (!this.snapshotControl.shouldInclude(example.getClass())) {
            return (T)example;
        }
        T existing = this.get(example);
        if (existing != null) {
            return existing;
        }
        if (this.isKnownNull((DatabaseObject)example)) {
            return null;
        }
        SnapshotGeneratorChain chain = this.createGeneratorChain(example.getClass(), this.database);
        T object = chain.snapshot(example, this);
        if (object == null) {
            Set<DatabaseObject> collection = this.knownNull.get(example.getClass());
            if (collection == null) {
                collection = new HashSet<DatabaseObject>();
                this.knownNull.put(example.getClass(), collection);
            }
            collection.add((DatabaseObject)example);
        } else {
            this.allFound.add(object);
            try {
                this.includeNestedObjects(object);
            }
            catch (InstantiationException e) {
                throw new UnexpectedLiquibaseException(e);
            }
            catch (IllegalAccessException e) {
                throw new UnexpectedLiquibaseException(e);
            }
        }
        return object;
    }

    private void includeNestedObjects(DatabaseObject object) throws DatabaseException, InvalidExampleException, InstantiationException, IllegalAccessException {
        for (String field : new HashSet<String>(object.getAttributes())) {
            Object newFieldValue;
            Object fieldValue = object.getAttribute(field, Object.class);
            if (fieldValue == (newFieldValue = this.replaceObject(fieldValue))) continue;
            object.setAttribute(field, newFieldValue);
        }
    }

    private Object replaceObject(Object fieldValue) throws DatabaseException, InvalidExampleException, IllegalAccessException, InstantiationException {
        if (fieldValue == null) {
            return null;
        }
        if (fieldValue instanceof DatabaseObject) {
            if (((DatabaseObject)fieldValue).getSnapshotId() != null) {
                return fieldValue;
            }
            if (!this.snapshotControl.shouldInclude(((DatabaseObject)fieldValue).getClass())) {
                return fieldValue;
            }
            if (((DatabaseObject)fieldValue).getSnapshotId() == null) {
                return this.include((DatabaseObject)fieldValue);
            }
            return fieldValue;
        }
        if (fieldValue instanceof Collection) {
            Iterator fieldValueIterator = ((Collection)fieldValue).iterator();
            ArrayList newValues = new ArrayList();
            while (fieldValueIterator.hasNext()) {
                Object obj = fieldValueIterator.next();
                if (fieldValue instanceof DatabaseObject && !this.snapshotControl.shouldInclude(((DatabaseObject)fieldValue).getClass())) {
                    return fieldValue;
                }
                if (obj instanceof DatabaseObject && ((DatabaseObject)obj).getSnapshotId() == null) {
                    obj = this.include((DatabaseObject)obj);
                }
                if (obj == null) continue;
                newValues.add(obj);
            }
            Collection newCollection = (Collection)fieldValue.getClass().newInstance();
            newCollection.addAll(newValues);
            return newCollection;
        }
        if (fieldValue instanceof Map) {
            Map newMap = (Map)fieldValue.getClass().newInstance();
            for (Map.Entry entry : ((Map)fieldValue).entrySet()) {
                Object key = this.replaceObject(entry.getKey());
                Object value = this.replaceObject(entry.getValue());
                if (key == null) continue;
                newMap.put(key, value);
            }
            return newMap;
        }
        return fieldValue;
    }

    public <DatabaseObjectType extends DatabaseObject> DatabaseObjectType get(DatabaseObjectType example) {
        return this.allFound.get(example);
    }

    public <DatabaseObjectType extends DatabaseObject> Set<DatabaseObjectType> get(Class<DatabaseObjectType> type) {
        return this.allFound.get(type);
    }

    private SnapshotGeneratorChain createGeneratorChain(Class<? extends DatabaseObject> databaseObjectType, Database database) {
        SortedSet<SnapshotGenerator> generators = SnapshotGeneratorFactory.getInstance().getGenerators(databaseObjectType, database);
        if (generators == null || generators.size() == 0) {
            return null;
        }
        return new SnapshotGeneratorChain(generators);
    }

    private boolean isKnownNull(DatabaseObject example) {
        Set<DatabaseObject> databaseObjects = this.knownNull.get(example.getClass());
        if (databaseObjects == null) {
            return false;
        }
        for (DatabaseObject obj : databaseObjects) {
            if (!DatabaseObjectComparatorFactory.getInstance().isSameObject(obj, example, this.database)) continue;
            return true;
        }
        return false;
    }
}

