/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.benchmark;

import java.text.NumberFormat;
import org.apache.http.HttpHost;
import org.apache.http.benchmark.BenchmarkWorker;
import org.apache.http.benchmark.Stats;

public class ResultProcessor {
    static NumberFormat nf2 = NumberFormat.getInstance();
    static NumberFormat nf3 = NumberFormat.getInstance();
    static NumberFormat nf6 = NumberFormat.getInstance();

    static String printResults(BenchmarkWorker[] workers, HttpHost host, String uri) {
        double totalTimeNano = 0.0;
        long successCount = 0L;
        long failureCount = 0L;
        long writeErrors = 0L;
        long keepAliveCount = 0L;
        long totalBytesRcvd = 0L;
        long totalBytesSent = 0L;
        Stats stats = workers[0].getStats();
        for (int i = 0; i < workers.length; ++i) {
            Stats s = workers[i].getStats();
            totalTimeNano += (double)s.getDuration();
            successCount += (long)s.getSuccessCount();
            failureCount += (long)s.getFailureCount();
            writeErrors += (long)s.getWriteErrors();
            keepAliveCount += (long)s.getKeepAliveCount();
            totalBytesRcvd += s.getTotalBytesRecv();
            totalBytesSent += s.getTotalBytesSent();
        }
        int threads = workers.length;
        double totalTimeMs = totalTimeNano / (double)threads / 1000000.0;
        double timePerReqMs = totalTimeMs / (double)successCount;
        double totalTimeSec = totalTimeMs / 1000.0;
        double reqsPerSec = (double)successCount / totalTimeSec;
        long totalBytes = totalBytesRcvd + (totalBytesSent > 0L ? totalBytesSent : 0L);
        StringBuilder sb = new StringBuilder(1024);
        ResultProcessor.printAndAppend(sb, "\nServer Software:\t\t" + stats.getServerName());
        ResultProcessor.printAndAppend(sb, "Server Hostname:\t\t" + host.getHostName());
        ResultProcessor.printAndAppend(sb, "Server Port:\t\t\t" + (host.getPort() > 0 ? Integer.valueOf(host.getPort()) : (uri.startsWith("https") ? "443" : "80")) + "\n");
        ResultProcessor.printAndAppend(sb, "Document Path:\t\t\t" + uri);
        ResultProcessor.printAndAppend(sb, "Document Length:\t\t" + stats.getContentLength() + " bytes\n");
        ResultProcessor.printAndAppend(sb, "Concurrency Level:\t\t" + workers.length);
        ResultProcessor.printAndAppend(sb, "Time taken for tests:\t\t" + nf6.format(totalTimeSec) + " seconds");
        ResultProcessor.printAndAppend(sb, "Complete requests:\t\t" + successCount);
        ResultProcessor.printAndAppend(sb, "Failed requests:\t\t" + failureCount);
        ResultProcessor.printAndAppend(sb, "Write errors:\t\t\t" + writeErrors);
        ResultProcessor.printAndAppend(sb, "Kept alive:\t\t\t" + keepAliveCount);
        ResultProcessor.printAndAppend(sb, "Total transferred:\t\t" + totalBytes + " bytes");
        ResultProcessor.printAndAppend(sb, "Requests per second:\t\t" + nf2.format(reqsPerSec) + " [#/sec] (mean)");
        ResultProcessor.printAndAppend(sb, "Time per request:\t\t" + nf3.format(timePerReqMs * (double)workers.length) + " [ms] (mean)");
        ResultProcessor.printAndAppend(sb, "Time per request:\t\t" + nf3.format(timePerReqMs) + " [ms] (mean, across all concurrent requests)");
        ResultProcessor.printAndAppend(sb, "Transfer rate:\t\t\t" + nf2.format((double)(totalBytesRcvd / 1000L) / totalTimeSec) + " [Kbytes/sec] received");
        ResultProcessor.printAndAppend(sb, "\t\t\t\t" + (totalBytesSent > 0L ? nf2.format((double)(totalBytesSent / 1000L) / totalTimeSec) : Integer.valueOf(-1)) + " kb/s sent");
        ResultProcessor.printAndAppend(sb, "\t\t\t\t" + nf2.format((double)(totalBytes / 1000L) / totalTimeSec) + " kb/s total");
        return sb.toString();
    }

    private static void printAndAppend(StringBuilder sb, String s) {
        System.out.println(s);
        sb.append(s).append("\r\n");
    }

    static {
        nf2.setMaximumFractionDigits(2);
        nf2.setMinimumFractionDigits(2);
        nf3.setMaximumFractionDigits(3);
        nf3.setMinimumFractionDigits(3);
        nf6.setMaximumFractionDigits(6);
        nf6.setMinimumFractionDigits(6);
    }
}

