/*
 * Decompiled with CFR 0.152.
 */
package net.freeutils.tnef;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.freeutils.tnef.Attachment;
import net.freeutils.tnef.Attr;
import net.freeutils.tnef.MAPIProps;
import net.freeutils.tnef.RawInputStream;
import net.freeutils.tnef.TNEFInputStream;
import net.freeutils.tnef.TNEFUtils;

public class Message {
    List attributes = new ArrayList();
    List attachments = new ArrayList();

    public Message() {
    }

    public Message(TNEFInputStream in) throws IOException {
        this();
        this.read(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void read(TNEFInputStream in) throws IOException {
        Attr attr;
        Attachment attachment = null;
        block16: while ((attr = in.readAttr()) != null) {
            switch (attr.getLevel()) {
                case 2: {
                    switch (attr.getID()) {
                        case 36866: {
                            if (attachment != null) {
                                this.attachments.add(attachment);
                            }
                            attachment = new Attachment();
                            attachment.addAttribute(attr);
                            continue block16;
                        }
                        case 36869: {
                            RawInputStream data = (RawInputStream)attr.getValue();
                            try {
                                attachment.setMAPIProps(new MAPIProps(data));
                                continue block16;
                            }
                            finally {
                                data.close();
                                attr.close();
                                continue block16;
                            }
                        }
                        case 32783: {
                            RawInputStream data = (RawInputStream)attr.getValue();
                            attachment.setRawData(data);
                            attr.close();
                            continue block16;
                        }
                        case 36865: {
                            RawInputStream data = (RawInputStream)attr.getValue();
                            try {
                                String filename = TNEFUtils.removeTerminatingNulls(new String(data.toByteArray(), this.getOEMCodePage()));
                                attachment.setFilename(filename);
                                continue block16;
                            }
                            finally {
                                data.close();
                                attr.close();
                                continue block16;
                            }
                        }
                    }
                    attachment.addAttribute(attr);
                    continue block16;
                }
                case 1: {
                    this.attributes.add(attr);
                    continue block16;
                }
                default: {
                    throw new IOException("Invalid attribute level: " + attr.getLevel());
                }
            }
        }
        if (attachment != null) {
            this.attachments.add(attachment);
        }
    }

    public MAPIProps getMAPIProps() throws IOException {
        Attr attr = this.getAttribute(36867);
        return attr != null ? (MAPIProps)attr.getValue() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getOEMCodePage() {
        String string;
        Attr attr = this.getAttribute(36871);
        if (attr == null) {
            return null;
        }
        RawInputStream data = (RawInputStream)attr.getValue();
        try {
            string = "Cp" + data.readU16();
        }
        catch (Throwable throwable) {
            try {
                data.close();
                throw throwable;
            }
            catch (IOException e) {
                return null;
            }
        }
        data.close();
        return string;
    }

    public List getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List attributes) {
        this.attributes = attributes;
    }

    public Attr getAttribute(int ID) {
        return Attr.findAttr(this.attributes, ID);
    }

    public List getAttachments() {
        return this.attachments;
    }

    public void setAttachments(List attachments) {
        this.attachments = attachments;
    }

    public void addAttribute(Attr attr) {
        this.attributes.add(attr);
    }

    public void addAttachment(Attachment attachment) {
        this.attachments.add(attachment);
    }

    public void close() throws IOException {
        int i;
        for (i = 0; i < this.attributes.size(); ++i) {
            ((Attr)this.attributes.get(i)).close();
        }
        for (i = 0; i < this.attachments.size(); ++i) {
            ((Attachment)this.attachments.get(i)).close();
        }
    }

    public String toString() {
        int i;
        StringBuffer s = new StringBuffer();
        s.append("Message:");
        s.append("\n  Attributes:");
        for (i = 0; i < this.attributes.size(); ++i) {
            s.append("\n    ").append(this.attributes.get(i));
        }
        s.append("\n  Attachments:");
        for (i = 0; i < this.attachments.size(); ++i) {
            s.append("\n    ").append(this.attachments.get(i));
        }
        return s.toString();
    }
}

