/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change.core;

import liquibase.change.ColumnConfig;
import liquibase.change.DatabaseChange;
import liquibase.change.core.AbstractModifyDataChange;
import liquibase.database.Database;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.DeleteStatement;

@DatabaseChange(name="delete", description="Deletes data from an existing table", priority=1, appliesTo={"table"})
public class DeleteDataChange
extends AbstractModifyDataChange {
    @Override
    public SqlStatement[] generateStatements(Database database) {
        DeleteStatement statement = new DeleteStatement(this.getCatalogName(), this.getSchemaName(), this.getTableName());
        statement.setWhereClause(this.where);
        for (ColumnConfig whereParam : this.whereParams) {
            if (whereParam.getName() != null) {
                statement.addWhereColumnName(whereParam.getName());
            }
            statement.addWhereParameter(whereParam.getValueObject());
        }
        return new SqlStatement[]{statement};
    }

    @Override
    public String getConfirmationMessage() {
        return "Data deleted from " + this.getTableName();
    }
}

