/*
 * Decompiled with CFR 0.152.
 */
package liquibase.parser.core.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import liquibase.change.Change;
import liquibase.change.ChangeFactory;
import liquibase.change.ChangeWithColumns;
import liquibase.change.ColumnConfig;
import liquibase.change.ConstraintsConfig;
import liquibase.change.core.AbstractModifyDataChange;
import liquibase.change.core.CreateProcedureChange;
import liquibase.change.core.CreateViewChange;
import liquibase.change.core.ExecuteShellCommandChange;
import liquibase.change.core.InsertDataChange;
import liquibase.change.core.LoadDataChange;
import liquibase.change.core.LoadDataColumnConfig;
import liquibase.change.core.RawSQLChange;
import liquibase.change.core.StopChange;
import liquibase.change.core.UpdateDataChange;
import liquibase.change.custom.CustomChangeWrapper;
import liquibase.changelog.ChangeLogParameters;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.database.ObjectQuotingStrategy;
import liquibase.exception.CustomChangeException;
import liquibase.exception.LiquibaseException;
import liquibase.exception.MigrationFailedException;
import liquibase.exception.UnknownChangelogFormatException;
import liquibase.logging.LogFactory;
import liquibase.logging.Logger;
import liquibase.parser.ChangeLogParserFactory;
import liquibase.parser.core.xml.IncludeAllFilter;
import liquibase.parser.core.xml.XMLChangeLogSAXParser;
import liquibase.precondition.CustomPreconditionWrapper;
import liquibase.precondition.Precondition;
import liquibase.precondition.PreconditionFactory;
import liquibase.precondition.PreconditionLogic;
import liquibase.precondition.core.PreconditionContainer;
import liquibase.precondition.core.SqlPrecondition;
import liquibase.resource.ResourceAccessor;
import liquibase.sql.visitor.SqlVisitor;
import liquibase.sql.visitor.SqlVisitorFactory;
import liquibase.util.FileUtil;
import liquibase.util.ObjectUtil;
import liquibase.util.StringUtils;
import liquibase.util.file.FilenameUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class XMLChangeLogSAXHandler
extends DefaultHandler {
    private static final char LIQUIBASE_FILE_SEPARATOR = '/';
    private final ChangeFactory changeFactory;
    private final PreconditionFactory preconditionFactory;
    private final SqlVisitorFactory sqlVisitorFactory;
    private final ChangeLogParserFactory changeLogParserFactory;
    protected Logger log;
    private DatabaseChangeLog databaseChangeLog;
    private Change change;
    private Stack changeSubObjects = new Stack();
    private StringBuffer text;
    private PreconditionContainer rootPrecondition;
    private Stack<PreconditionLogic> preconditionLogicStack = new Stack();
    private ChangeSet changeSet;
    private String paramName;
    private ResourceAccessor resourceAccessor;
    private Precondition currentPrecondition;
    private ChangeLogParameters changeLogParameters;
    private boolean inRollback = false;
    private boolean inModifySql = false;
    private Set<String> modifySqlDbmsList;
    private Set<String> modifySqlContexts;
    private boolean modifySqlAppliedOnRollback = false;

    protected XMLChangeLogSAXHandler(String physicalChangeLogLocation, ResourceAccessor resourceAccessor, ChangeLogParameters changeLogParameters) {
        this.log = LogFactory.getLogger();
        this.resourceAccessor = resourceAccessor;
        this.databaseChangeLog = new DatabaseChangeLog();
        this.databaseChangeLog.setPhysicalFilePath(physicalChangeLogLocation);
        this.databaseChangeLog.setChangeLogParameters(changeLogParameters);
        this.changeLogParameters = changeLogParameters;
        this.changeFactory = ChangeFactory.getInstance();
        this.preconditionFactory = PreconditionFactory.getInstance();
        this.sqlVisitorFactory = SqlVisitorFactory.getInstance();
        this.changeLogParserFactory = ChangeLogParserFactory.getInstance();
    }

    public DatabaseChangeLog getDatabaseChangeLog() {
        return this.databaseChangeLog;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes baseAttributes) throws SAXException {
        block85: {
            ExpandingAttributes atts = new ExpandingAttributes(baseAttributes);
            try {
                if ("comment".equals(qName)) {
                    this.text = new StringBuffer();
                    break block85;
                }
                if ("validCheckSum".equals(qName)) {
                    this.text = new StringBuffer();
                    break block85;
                }
                if ("databaseChangeLog".equals(qName)) {
                    String version;
                    Matcher matcher;
                    String schemaLocation = atts.getValue("xsi:schemaLocation");
                    if (schemaLocation != null && (matcher = Pattern.compile(".*dbchangelog-(\\d+\\.\\d+).xsd").matcher(schemaLocation)).matches() && !(version = matcher.group(1)).equals(XMLChangeLogSAXParser.getSchemaVersion())) {
                        this.log.info(this.databaseChangeLog.getPhysicalFilePath() + " is using schema version " + version + " rather than version " + XMLChangeLogSAXParser.getSchemaVersion());
                    }
                    this.databaseChangeLog.setLogicalFilePath(atts.getValue("logicalFilePath"));
                    ObjectQuotingStrategy quotingStrategy = ObjectQuotingStrategy.LEGACY;
                    String quotingStrategyText = atts.getValue("objectQuotingStrategy");
                    if (quotingStrategyText != null) {
                        quotingStrategy = ObjectQuotingStrategy.valueOf(quotingStrategyText);
                    }
                    this.databaseChangeLog.setObjectQuotingStrategy(quotingStrategy);
                    break block85;
                }
                if ("include".equals(qName)) {
                    String fileName = atts.getValue("file");
                    fileName = fileName.replace('\\', '/');
                    boolean isRelativeToChangelogFile = Boolean.parseBoolean(atts.getValue("relativeToChangelogFile"));
                    this.handleIncludedChangeLog(fileName, isRelativeToChangelogFile, this.databaseChangeLog.getPhysicalFilePath());
                    break block85;
                }
                if ("includeAll".equals(qName)) {
                    Object resources;
                    String pathName = atts.getValue("path");
                    if (!(pathName = pathName.replace('\\', '/')).endsWith("/")) {
                        pathName = pathName + '/';
                    }
                    this.log.debug("includeAll for " + pathName);
                    this.log.debug("Using file opener for includeAll: " + this.resourceAccessor.toString());
                    boolean isRelativeToChangelogFile = Boolean.parseBoolean(atts.getValue("relativeToChangelogFile"));
                    String resourceFilterDef = atts.getValue("resourceFilter");
                    IncludeAllFilter resourceFilter = null;
                    if (resourceFilterDef != null) {
                        resourceFilter = (IncludeAllFilter)Class.forName(resourceFilterDef).newInstance();
                    }
                    if (isRelativeToChangelogFile) {
                        File changeLogFile = null;
                        resources = this.resourceAccessor.getResources(this.databaseChangeLog.getPhysicalFilePath());
                        while (resources.hasMoreElements()) {
                            try {
                                changeLogFile = new File(((URL)resources.nextElement()).toURI());
                            }
                            catch (URISyntaxException e) {
                                continue;
                            }
                            if (changeLogFile.exists()) break;
                            changeLogFile = null;
                        }
                        if (changeLogFile == null) {
                            throw new SAXException("Cannot determine physical location of " + this.databaseChangeLog.getPhysicalFilePath());
                        }
                        File resourceBase = new File(changeLogFile.getParentFile(), pathName);
                        if (!resourceBase.exists()) {
                            throw new SAXException("Resource directory for includeAll does not exist [" + resourceBase.getAbsolutePath() + "]");
                        }
                        pathName = resourceBase.getPath() + '/';
                        pathName = pathName.replace('\\', '/');
                    }
                    Enumeration<URL> resourcesEnum = this.resourceAccessor.getResources(pathName);
                    resources = new TreeSet<URL>(new Comparator<URL>(){

                        @Override
                        public int compare(URL o1, URL o2) {
                            return o1.toString().compareTo(o2.toString());
                        }
                    });
                    while (resourcesEnum.hasMoreElements()) {
                        resources.add(resourcesEnum.nextElement());
                    }
                    boolean foundResource = false;
                    HashSet<String> seenPaths = new HashSet<String>();
                    List<String> includedChangeLogs = new LinkedList<String>();
                    Iterator iterator = resources.iterator();
                    while (iterator.hasNext()) {
                        URL fileUrl = (URL)iterator.next();
                        if (!fileUrl.toExternalForm().startsWith("file:")) {
                            if (fileUrl.toExternalForm().startsWith("jar:file:") || fileUrl.toExternalForm().startsWith("wsjar:file:") || fileUrl.toExternalForm().startsWith("zip:")) {
                                File zipFileDir = XMLChangeLogSAXHandler.extractZipFile(fileUrl);
                                fileUrl = new File(zipFileDir, pathName).toURL();
                            } else {
                                this.log.debug(fileUrl.toExternalForm() + " is not a file path");
                                continue;
                            }
                        }
                        File file = new File(fileUrl.toURI());
                        this.log.debug("includeAll using path " + file.getCanonicalPath());
                        if (!file.exists()) {
                            throw new SAXException("includeAll path " + pathName + " could not be found.  Tried in " + file.toString());
                        }
                        if (file.isDirectory()) {
                            this.log.debug(file.getCanonicalPath() + " is a directory");
                            for (File childFile : new TreeSet<File>(Arrays.asList(file.listFiles()))) {
                                String path = pathName + childFile.getName();
                                if (!seenPaths.add(path)) {
                                    this.log.debug("already included " + path);
                                    continue;
                                }
                                includedChangeLogs.add(path);
                            }
                            continue;
                        }
                        String path = pathName + file.getName();
                        if (!seenPaths.add(path)) {
                            this.log.debug("already included " + path);
                            continue;
                        }
                        includedChangeLogs.add(path);
                    }
                    if (resourceFilter != null) {
                        includedChangeLogs = resourceFilter.filter(includedChangeLogs);
                    }
                    for (String path : includedChangeLogs) {
                        if (!this.handleIncludedChangeLog(path, false, this.databaseChangeLog.getPhysicalFilePath())) continue;
                        foundResource = true;
                    }
                    if (!foundResource) {
                        throw new SAXException("Could not find directory or directory was empty for includeAll '" + pathName + "'");
                    }
                    break block85;
                }
                if (this.changeSet == null && "changeSet".equals(qName)) {
                    String filePath;
                    boolean alwaysRun = false;
                    boolean runOnChange = false;
                    if ("true".equalsIgnoreCase(atts.getValue("runAlways"))) {
                        alwaysRun = true;
                    }
                    if ("true".equalsIgnoreCase(atts.getValue("runOnChange"))) {
                        runOnChange = true;
                    }
                    if ((filePath = atts.getValue("logicalFilePath")) == null || "".equals(filePath)) {
                        filePath = this.databaseChangeLog.getFilePath();
                    }
                    ObjectQuotingStrategy quotingStrategy = this.databaseChangeLog.getObjectQuotingStrategy();
                    String quotingStrategyText = atts.getValue("objectQuotingStrategy");
                    if (quotingStrategyText != null) {
                        quotingStrategy = ObjectQuotingStrategy.valueOf(quotingStrategyText);
                    }
                    this.changeSet = new ChangeSet(atts.getValue("id"), atts.getValue("author"), alwaysRun, runOnChange, filePath, atts.getValue("context"), atts.getValue("dbms"), Boolean.valueOf(atts.getValue("runInTransaction")), quotingStrategy, this.databaseChangeLog);
                    if (StringUtils.trimToNull(atts.getValue("failOnError")) != null) {
                        this.changeSet.setFailOnError(Boolean.parseBoolean(atts.getValue("failOnError")));
                    }
                    if (StringUtils.trimToNull(atts.getValue("onValidationFail")) != null) {
                        this.changeSet.setOnValidationFail(ChangeSet.ValidationFailOption.valueOf(atts.getValue("onValidationFail")));
                    }
                    this.changeSet.setChangeLogParameters(this.changeLogParameters);
                    break block85;
                }
                if (this.changeSet != null && "rollback".equals(qName)) {
                    this.text = new StringBuffer();
                    String id = atts.getValue("changeSetId");
                    if (id != null) {
                        String author;
                        ChangeSet changeSet;
                        String path = atts.getValue("changeSetPath");
                        if (path == null) {
                            path = this.databaseChangeLog.getFilePath();
                        }
                        if ((changeSet = this.databaseChangeLog.getChangeSet(path, author = atts.getValue("changeSetAuthor"), id)) == null) {
                            throw new SAXException("Could not find changeSet to use for rollback: " + path + ":" + author + ":" + id);
                        }
                        for (Change change : changeSet.getChanges()) {
                            this.changeSet.addRollbackChange(change);
                        }
                    }
                    this.inRollback = true;
                    break block85;
                }
                if ("preConditions".equals(qName)) {
                    this.rootPrecondition = new PreconditionContainer();
                    this.rootPrecondition.setOnFail(StringUtils.trimToNull(atts.getValue("onFail")));
                    this.rootPrecondition.setOnError(StringUtils.trimToNull(atts.getValue("onError")));
                    this.rootPrecondition.setOnFailMessage(StringUtils.trimToNull(atts.getValue("onFailMessage")));
                    this.rootPrecondition.setOnErrorMessage(StringUtils.trimToNull(atts.getValue("onErrorMessage")));
                    this.rootPrecondition.setOnSqlOutput(StringUtils.trimToNull(atts.getValue("onSqlOutput")));
                    this.preconditionLogicStack.push(this.rootPrecondition);
                    break block85;
                }
                if (this.currentPrecondition != null && this.currentPrecondition instanceof CustomPreconditionWrapper && qName.equals("param")) {
                    ((CustomPreconditionWrapper)this.currentPrecondition).setParam(atts.getValue("name"), atts.getValue("value"));
                    break block85;
                }
                if (this.rootPrecondition != null) {
                    this.currentPrecondition = this.preconditionFactory.create(localName);
                    for (int i = 0; i < atts.getLength(); ++i) {
                        String attributeName = atts.getLocalName(i);
                        String attributeValue = atts.getValue(i);
                        this.setProperty(this.currentPrecondition, attributeName, attributeValue);
                    }
                    this.preconditionLogicStack.peek().addNestedPrecondition(this.currentPrecondition);
                    if (this.currentPrecondition instanceof PreconditionLogic) {
                        this.preconditionLogicStack.push((PreconditionLogic)this.currentPrecondition);
                    }
                    if ("sqlCheck".equals(qName)) {
                        this.text = new StringBuffer();
                    }
                    break block85;
                }
                if ("modifySql".equals(qName)) {
                    this.inModifySql = true;
                    if (StringUtils.trimToNull(atts.getValue("dbms")) != null) {
                        this.modifySqlDbmsList = new HashSet<String>(StringUtils.splitAndTrim(atts.getValue("dbms"), ","));
                    }
                    if (StringUtils.trimToNull(atts.getValue("context")) != null) {
                        this.modifySqlContexts = new HashSet<String>(StringUtils.splitAndTrim(atts.getValue("context"), ","));
                    }
                    if (StringUtils.trimToNull(atts.getValue("applyToRollback")) != null) {
                        this.modifySqlAppliedOnRollback = Boolean.valueOf(atts.getValue("applyToRollback"));
                    }
                    break block85;
                }
                if (this.inModifySql) {
                    SqlVisitor sqlVisitor = this.sqlVisitorFactory.create(localName);
                    for (int i = 0; i < atts.getLength(); ++i) {
                        String attributeName = atts.getLocalName(i);
                        String attributeValue = atts.getValue(i);
                        this.setProperty(sqlVisitor, attributeName, attributeValue);
                    }
                    sqlVisitor.setApplicableDbms(this.modifySqlDbmsList);
                    sqlVisitor.setApplyToRollback(this.modifySqlAppliedOnRollback);
                    sqlVisitor.setContexts(this.modifySqlContexts);
                    this.changeSet.addSqlVisitor(sqlVisitor);
                    break block85;
                }
                if (this.changeSet != null && this.change == null) {
                    this.change = this.changeFactory.create(localName);
                    if (this.change == null) {
                        throw new SAXException("Unknown Liquibase extension: " + localName + ".  Are you missing a jar from your classpath?");
                    }
                    this.change.setChangeSet(this.changeSet);
                    this.text = new StringBuffer();
                    if (this.change == null) {
                        throw new MigrationFailedException(this.changeSet, "Unknown change: " + localName);
                    }
                    this.change.setResourceAccessor(this.resourceAccessor);
                    if (this.change instanceof CustomChangeWrapper) {
                        ((CustomChangeWrapper)this.change).setClassLoader(this.resourceAccessor.toClassLoader());
                    }
                    for (int i = 0; i < atts.getLength(); ++i) {
                        String attributeName = atts.getLocalName(i);
                        String attributeValue = atts.getValue(i);
                        this.setProperty(this.change, attributeName, attributeValue);
                    }
                    this.change.finishInitialization();
                    break block85;
                }
                if (this.change != null && "column".equals(qName)) {
                    ColumnConfig column = this.change instanceof LoadDataChange ? new LoadDataColumnConfig() : new ColumnConfig();
                    this.populateColumnFromAttributes(atts, column);
                    if (this.change instanceof ChangeWithColumns) {
                        ((ChangeWithColumns)((Object)this.change)).addColumn(column);
                        break block85;
                    }
                    throw new RuntimeException("Unexpected column tag for " + this.change.getClass().getName());
                }
                if (this.change != null && "whereParams".equals(qName)) {
                    if (!(this.change instanceof AbstractModifyDataChange)) {
                        throw new RuntimeException("Unexpected change: " + this.change.getClass().getName());
                    }
                    break block85;
                }
                if (this.change != null && this.change instanceof AbstractModifyDataChange && "param".equals(qName)) {
                    ColumnConfig param = new ColumnConfig();
                    this.populateColumnFromAttributes(atts, param);
                    ((AbstractModifyDataChange)this.change).addWhereParam(param);
                    break block85;
                }
                if (this.change != null && "constraints".equals(qName)) {
                    ConstraintsConfig constraints = new ConstraintsConfig();
                    for (int i = 0; i < atts.getLength(); ++i) {
                        String attributeName = atts.getLocalName(i);
                        String attributeValue = atts.getValue(i);
                        this.setProperty(constraints, attributeName, attributeValue);
                    }
                    ColumnConfig lastColumn = null;
                    if (this.change instanceof ChangeWithColumns) {
                        List columns = ((ChangeWithColumns)((Object)this.change)).getColumns();
                        if (columns != null && columns.size() > 0) {
                            lastColumn = (ColumnConfig)columns.get(columns.size() - 1);
                        }
                    } else {
                        throw new RuntimeException("Unexpected change: " + this.change.getClass().getName());
                    }
                    if (lastColumn == null) {
                        throw new RuntimeException("Could not determine column to add constraint to");
                    }
                    lastColumn.setConstraints(constraints);
                    break block85;
                }
                if ("param".equals(qName) && this.change instanceof CustomChangeWrapper) {
                    if (atts.getValue("value") == null) {
                        this.paramName = atts.getValue("name");
                        this.text = new StringBuffer();
                    } else {
                        ((CustomChangeWrapper)this.change).setParam(atts.getValue("name"), atts.getValue("value"));
                    }
                    break block85;
                }
                if ("where".equals(qName)) {
                    this.text = new StringBuffer();
                    break block85;
                }
                if ("property".equals(qName)) {
                    String context = StringUtils.trimToNull(atts.getValue("context"));
                    String dbms = StringUtils.trimToNull(atts.getValue("dbms"));
                    if (StringUtils.trimToNull(atts.getValue("file")) == null) {
                        this.changeLogParameters.set(atts.getValue("name"), atts.getValue("value"), context, dbms);
                    } else {
                        Properties props = new Properties();
                        InputStream propertiesStream = this.resourceAccessor.getResourceAsStream(atts.getValue("file"));
                        if (propertiesStream == null) {
                            this.log.info("Could not open properties file " + atts.getValue("file"));
                        } else {
                            props.load(propertiesStream);
                            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                                this.changeLogParameters.set(entry.getKey().toString(), entry.getValue().toString(), context, dbms);
                            }
                        }
                    }
                    break block85;
                }
                if (this.change instanceof ExecuteShellCommandChange && "arg".equals(qName)) {
                    ((ExecuteShellCommandChange)this.change).addArg(atts.getValue("value"));
                    break block85;
                }
                if (this.change != null) {
                    Method method;
                    String creatorMethod = "create" + localName.substring(0, 1).toUpperCase() + localName.substring(1);
                    Change objectToCreateFrom = this.changeSubObjects.size() == 0 ? this.change : this.changeSubObjects.peek();
                    try {
                        method = objectToCreateFrom.getClass().getMethod(creatorMethod, new Class[0]);
                    }
                    catch (NoSuchMethodException e) {
                        throw new MigrationFailedException(this.changeSet, "Could not find creator method " + creatorMethod + " for tag: " + localName);
                    }
                    Object subObject = method.invoke((Object)objectToCreateFrom, new Object[0]);
                    for (int i = 0; i < atts.getLength(); ++i) {
                        String attributeName = atts.getLocalName(i);
                        String attributeValue = atts.getValue(i);
                        this.setProperty(subObject, attributeName, attributeValue);
                    }
                    this.changeSubObjects.push(subObject);
                    break block85;
                }
                throw new MigrationFailedException(this.changeSet, "Unexpected tag: " + localName);
            }
            catch (Exception e) {
                this.log.severe("Error thrown as a SAXException: " + e.getMessage(), e);
                e.printStackTrace();
                throw new SAXException(e);
            }
        }
    }

    private void populateColumnFromAttributes(Attributes atts, ColumnConfig column) throws IllegalAccessException, InvocationTargetException, CustomChangeException {
        for (int i = 0; i < atts.getLength(); ++i) {
            String attributeName = atts.getLocalName(i);
            String attributeValue = atts.getValue(i);
            this.setProperty(column, attributeName, attributeValue);
        }
    }

    protected boolean handleIncludedChangeLog(String fileName, boolean isRelativePath, String relativeBaseFileName) throws LiquibaseException {
        DatabaseChangeLog changeLog;
        if (fileName.equalsIgnoreCase(".svn") || fileName.equalsIgnoreCase("cvs")) {
            return false;
        }
        if (isRelativePath) {
            String tempFile = FilenameUtils.concat(FilenameUtils.getFullPath(relativeBaseFileName), fileName);
            fileName = tempFile != null && new File(tempFile).exists() ? tempFile : FilenameUtils.getFullPath(relativeBaseFileName) + fileName;
        }
        try {
            changeLog = this.changeLogParserFactory.getParser(fileName, this.resourceAccessor).parse(fileName, this.changeLogParameters, this.resourceAccessor);
        }
        catch (UnknownChangelogFormatException e) {
            this.log.warning("included file " + relativeBaseFileName + "/" + fileName + " is not a recognized file type");
            return false;
        }
        PreconditionContainer preconditions = changeLog.getPreconditions();
        if (preconditions != null) {
            if (null == this.databaseChangeLog.getPreconditions()) {
                this.databaseChangeLog.setPreconditions(new PreconditionContainer());
            }
            this.databaseChangeLog.getPreconditions().addNestedPrecondition(preconditions);
        }
        for (ChangeSet changeSet : changeLog.getChangeSets()) {
            this.handleChangeSet(changeSet);
        }
        return true;
    }

    private void setProperty(Object object, String attributeName, String attributeValue) throws IllegalAccessException, InvocationTargetException, CustomChangeException {
        if (object instanceof CustomChangeWrapper) {
            if (attributeName.equals("class")) {
                ((CustomChangeWrapper)object).setClass(this.changeLogParameters.expandExpressions(attributeValue));
            } else {
                ((CustomChangeWrapper)object).setParam(attributeName, this.changeLogParameters.expandExpressions(attributeValue));
            }
        } else {
            ObjectUtil.setProperty(object, attributeName, this.changeLogParameters.expandExpressions(attributeValue));
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        String textString = null;
        if (this.text != null && this.text.length() > 0) {
            textString = this.changeLogParameters.expandExpressions(StringUtils.trimToNull(this.text.toString()));
        }
        try {
            if (this.changeSubObjects.size() > 0) {
                this.changeSubObjects.pop();
            } else if (this.rootPrecondition != null) {
                if ("preConditions".equals(qName)) {
                    if (this.changeSet == null) {
                        this.databaseChangeLog.setPreconditions(this.rootPrecondition);
                        this.handlePreCondition(this.rootPrecondition);
                    } else {
                        this.changeSet.setPreconditions(this.rootPrecondition);
                    }
                    this.rootPrecondition = null;
                } else if ("and".equals(qName)) {
                    this.preconditionLogicStack.pop();
                    this.currentPrecondition = null;
                } else if ("or".equals(qName)) {
                    this.preconditionLogicStack.pop();
                    this.currentPrecondition = null;
                } else if ("not".equals(qName)) {
                    this.preconditionLogicStack.pop();
                    this.currentPrecondition = null;
                } else if (qName.equals("sqlCheck")) {
                    ((SqlPrecondition)this.currentPrecondition).setSql(textString);
                    this.currentPrecondition = null;
                } else if (qName.equals("customPrecondition")) {
                    ((CustomPreconditionWrapper)this.currentPrecondition).setClassLoader(this.resourceAccessor.toClassLoader());
                    this.currentPrecondition = null;
                }
            } else if (this.changeSet != null && "rollback".equals(qName)) {
                this.changeSet.addRollBackSQL(textString);
                this.inRollback = false;
            } else if (this.change != null && this.change instanceof RawSQLChange && "comment".equals(qName)) {
                ((RawSQLChange)this.change).setComment(textString);
                this.text = new StringBuffer();
            } else if (this.change != null && "where".equals(qName)) {
                if (!(this.change instanceof AbstractModifyDataChange)) {
                    throw new RuntimeException("Unexpected change type: " + this.change.getClass().getName());
                }
                ((AbstractModifyDataChange)this.change).setWhere(textString);
                this.text = new StringBuffer();
            } else if (this.change != null && this.change instanceof CreateProcedureChange && "comment".equals(qName)) {
                ((CreateProcedureChange)this.change).setComments(textString);
                this.text = new StringBuffer();
            } else if (this.change != null && this.change instanceof CustomChangeWrapper && this.paramName != null && "param".equals(qName)) {
                ((CustomChangeWrapper)this.change).setParam(this.paramName, textString);
                this.text = new StringBuffer();
                this.paramName = null;
            } else if (this.changeSet != null && "comment".equals(qName)) {
                this.changeSet.setComments(textString);
                this.text = new StringBuffer();
            } else if (this.changeSet != null && "changeSet".equals(qName)) {
                this.handleChangeSet(this.changeSet);
                this.changeSet = null;
            } else if (this.change != null && qName.equals("column") && textString != null) {
                if (this.change instanceof InsertDataChange) {
                    List<ColumnConfig> columns = ((InsertDataChange)this.change).getColumns();
                    columns.get(columns.size() - 1).setValue(textString);
                } else if (this.change instanceof UpdateDataChange) {
                    List<ColumnConfig> columns = ((UpdateDataChange)this.change).getColumns();
                    columns.get(columns.size() - 1).setValue(textString);
                } else {
                    throw new RuntimeException("Unexpected column with text: " + textString);
                }
                this.text = new StringBuffer();
            } else if (this.change != null && this.change instanceof AbstractModifyDataChange && qName.equals("param") && textString != null) {
                List<ColumnConfig> columns = ((AbstractModifyDataChange)this.change).getWhereParams();
                columns.get(columns.size() - 1).setValue(textString);
                this.text = new StringBuffer();
            } else if (this.change != null && localName.equals(this.changeFactory.getChangeMetaData(this.change).getName())) {
                if (textString != null) {
                    if (this.change instanceof RawSQLChange) {
                        String expandedExpression = textString;
                        if (!ChangeLogParameters.EnableEscaping) {
                            expandedExpression = this.changeLogParameters.expandExpressions(textString);
                        }
                        ((RawSQLChange)this.change).setSql(expandedExpression);
                    } else if (this.change instanceof CreateProcedureChange) {
                        ((CreateProcedureChange)this.change).setProcedureBody(textString);
                    } else if (this.change instanceof CreateViewChange) {
                        ((CreateViewChange)this.change).setSelectQuery(textString);
                    } else if (this.change instanceof StopChange) {
                        ((StopChange)this.change).setMessage(textString);
                    } else {
                        throw new RuntimeException("Unexpected text in " + this.changeFactory.getChangeMetaData(this.change).getName());
                    }
                }
                this.text = null;
                if (this.inRollback) {
                    this.changeSet.addRollbackChange(this.change);
                } else {
                    this.changeSet.addChange(this.change);
                }
                this.change = null;
            } else if (this.changeSet != null && "validCheckSum".equals(qName)) {
                this.changeSet.addValidCheckSum(this.text.toString());
                this.text = null;
            } else if ("modifySql".equals(qName)) {
                this.inModifySql = false;
                this.modifySqlDbmsList = null;
                this.modifySqlContexts = null;
                this.modifySqlAppliedOnRollback = false;
            }
        }
        catch (Exception e) {
            this.log.severe("Error thrown as a SAXException: " + e.getMessage(), e);
            throw new SAXException(this.databaseChangeLog.getPhysicalFilePath() + ": " + e.getMessage(), e);
        }
    }

    protected void handlePreCondition(Precondition precondition) {
        this.databaseChangeLog.setPreconditions(this.rootPrecondition);
    }

    protected void handleChangeSet(ChangeSet changeSet) {
        this.databaseChangeLog.addChangeSet(changeSet);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.text != null) {
            this.text.append(new String(ch, start, length));
        }
    }

    static File extractZipFile(URL resource) throws IOException {
        String file = resource.getFile();
        String path = file.split("!")[0];
        path = path.matches("file:\\/[A-Za-z]:\\/.*") ? path.replaceFirst("file:\\/", "") : path.replaceFirst("file:", "");
        path = URLDecoder.decode(path);
        File zipfile = new File(path);
        File tempDir = File.createTempFile("liquibase-sax", ".dir");
        tempDir.delete();
        tempDir.mkdir();
        JarFile jarFile = new JarFile(zipfile);
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            File entryFile = new File(tempDir, entry.getName());
            entryFile.mkdirs();
        }
        FileUtil.forceDeleteOnExit(tempDir);
        return tempDir;
    }

    private class ExpandingAttributes
    implements Attributes {
        private Attributes attributes;

        private ExpandingAttributes(Attributes attributes) {
            this.attributes = attributes;
        }

        @Override
        public int getLength() {
            return this.attributes.getLength();
        }

        @Override
        public String getURI(int index) {
            return this.attributes.getURI(index);
        }

        @Override
        public String getLocalName(int index) {
            return this.attributes.getLocalName(index);
        }

        @Override
        public String getQName(int index) {
            return this.attributes.getQName(index);
        }

        @Override
        public String getType(int index) {
            return this.attributes.getType(index);
        }

        @Override
        public String getValue(int index) {
            return this.attributes.getValue(index);
        }

        @Override
        public int getIndex(String uri, String localName) {
            return this.attributes.getIndex(uri, localName);
        }

        @Override
        public int getIndex(String qName) {
            return this.attributes.getIndex(qName);
        }

        @Override
        public String getType(String uri, String localName) {
            return this.attributes.getType(uri, localName);
        }

        @Override
        public String getType(String qName) {
            return this.attributes.getType(qName);
        }

        @Override
        public String getValue(String uri, String localName) {
            return XMLChangeLogSAXHandler.this.changeLogParameters.expandExpressions(this.attributes.getValue(uri, localName));
        }

        @Override
        public String getValue(String qName) {
            return XMLChangeLogSAXHandler.this.changeLogParameters.expandExpressions(this.attributes.getValue(qName));
        }
    }
}

