/*
 * Decompiled with CFR 0.152.
 */
package liquibase.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import liquibase.resource.UtfBomAwareReader;

public class StreamUtil {
    public static final String lineSeparator = System.getProperty("line.separator");

    public static String getLineSeparator() {
        return lineSeparator;
    }

    public static String getStreamContents(InputStream ins) throws IOException {
        return StreamUtil.getReaderContents(new UtfBomAwareReader(ins));
    }

    public static String getStreamContents(InputStream ins, String charsetName) throws IOException {
        UtfBomAwareReader reader;
        if (charsetName == null) {
            reader = new UtfBomAwareReader(ins);
        } else {
            String charsetCanonicalName = Charset.forName(charsetName).name();
            reader = new UtfBomAwareReader(ins, charsetName);
            String encoding = Charset.forName(reader.getEncoding()).name();
            if (charsetCanonicalName.startsWith("UTF") && !charsetCanonicalName.equals(encoding)) {
                reader.close();
                throw new IllegalArgumentException("Expected encoding was '" + charsetCanonicalName + "' but a BOM was detected for '" + encoding + "'");
            }
        }
        return StreamUtil.getReaderContents(reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getReaderContents(Reader reader) throws IOException {
        try {
            int read;
            StringBuffer result = new StringBuffer();
            char[] buffer = new char[2048];
            while ((read = reader.read(buffer)) > -1) {
                result.append(buffer, 0, read);
            }
            String string = result.toString();
            return string;
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        byte[] bytes = new byte[1024];
        int r = inputStream.read(bytes);
        while (r > 0) {
            outputStream.write(bytes, 0, r);
            r = inputStream.read(bytes);
        }
    }
}

