/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.io;

import ezvcard.VCard;
import ezvcard.io.ParseWarnings;
import ezvcard.io.scribe.ScribeIndex;
import ezvcard.io.scribe.VCardPropertyScribe;
import ezvcard.parameter.AddressType;
import ezvcard.property.Address;
import ezvcard.property.Label;
import ezvcard.property.VCardProperty;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StreamReader
implements Closeable {
    protected final ParseWarnings warnings = new ParseWarnings();
    protected ScribeIndex index = new ScribeIndex();

    public List<VCard> readAll() throws IOException {
        ArrayList<VCard> vcards = new ArrayList<VCard>();
        VCard vcard = null;
        while ((vcard = this.readNext()) != null) {
            vcards.add(vcard);
        }
        return vcards;
    }

    public VCard readNext() throws IOException {
        this.warnings.clear();
        return this._readNext();
    }

    protected abstract VCard _readNext() throws IOException;

    protected void assignLabels(VCard vcard, List<Label> labels) {
        List<Address> adrs = vcard.getAddresses();
        for (Label label : labels) {
            boolean orphaned = true;
            Set<AddressType> labelTypes = label.getTypes();
            for (Address adr : adrs) {
                if (adr.getLabel() != null || !adr.getTypes().equals(labelTypes)) continue;
                adr.setLabel((String)label.getValue());
                orphaned = false;
                break;
            }
            if (!orphaned) continue;
            vcard.addOrphanedLabel(label);
        }
    }

    public void registerScribe(VCardPropertyScribe<? extends VCardProperty> scribe) {
        this.index.register(scribe);
    }

    public ScribeIndex getScribeIndex() {
        return this.index;
    }

    public void setScribeIndex(ScribeIndex index) {
        this.index = index;
    }

    public List<String> getWarnings() {
        return this.warnings.copy();
    }
}

