/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.io.text;

import ezvcard.util.StringUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.regex.Pattern;

public class FoldedLineReader
extends BufferedReader {
    private static final Pattern foldedQuotedPrintableValueRegex = Pattern.compile("[^:]*?QUOTED-PRINTABLE.*?:.*?=", 2);
    private String lastLine;
    private int lastLineNum = 0;
    private int lineCount = 0;
    private final Charset charset;

    public FoldedLineReader(Reader reader) {
        super(reader);
        InputStreamReader isr;
        String charsetStr;
        this.charset = reader instanceof InputStreamReader ? ((charsetStr = (isr = (InputStreamReader)reader).getEncoding()) == null ? null : Charset.forName(charsetStr)) : null;
    }

    public FoldedLineReader(String text) {
        this(new StringReader(text));
    }

    public int getLineNum() {
        return this.lastLineNum;
    }

    public Charset getEncoding() {
        return this.charset;
    }

    private String readNonEmptyLine() throws IOException {
        String line;
        do {
            if ((line = super.readLine()) == null) continue;
            ++this.lineCount;
        } while (line != null && line.length() == 0);
        return line;
    }

    public String readLine() throws IOException {
        StringBuilder unfoldedLine;
        block7: {
            String line;
            String wholeLine = this.lastLine == null ? this.readNonEmptyLine() : this.lastLine;
            this.lastLine = null;
            if (wholeLine == null) {
                return null;
            }
            boolean foldedQuotedPrintableLine = false;
            if (foldedQuotedPrintableValueRegex.matcher(wholeLine).matches()) {
                foldedQuotedPrintableLine = true;
                wholeLine = wholeLine.substring(0, wholeLine.length() - 1);
            }
            this.lastLineNum = this.lineCount;
            unfoldedLine = new StringBuilder(wholeLine);
            while (true) {
                int lastWhitespace;
                String string = line = foldedQuotedPrintableLine ? super.readLine() : this.readNonEmptyLine();
                if (line == null) break block7;
                if (foldedQuotedPrintableLine) {
                    boolean endsInEquals = (line = StringUtils.ltrim(line)).endsWith("=");
                    if (endsInEquals) {
                        line = line.substring(0, line.length() - 1);
                    }
                    unfoldedLine.append(line);
                    if (endsInEquals) {
                        continue;
                    }
                    break block7;
                }
                if (line.length() <= 0 || !Character.isWhitespace(line.charAt(0))) break;
                for (lastWhitespace = 1; lastWhitespace < line.length() && Character.isWhitespace(line.charAt(lastWhitespace)); ++lastWhitespace) {
                }
                unfoldedLine.append(line.substring(lastWhitespace));
            }
            this.lastLine = line;
        }
        return unfoldedLine.toString();
    }
}

