/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.aiff;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.jaudiotagger.audio.aiff.ExtDouble;

public class AiffUtil {
    private static final SimpleDateFormat dateFmt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private static final Charset LATIN1 = (Charset)Charset.availableCharsets().get("ISO-8859-1");

    public static long readUINT32(RandomAccessFile raf) throws IOException {
        long result = 0L;
        for (int i = 0; i < 4; ++i) {
            result <<= 8;
            result |= (long)raf.read();
        }
        return result;
    }

    public static String read4Chars(RandomAccessFile raf) throws IOException {
        StringBuffer sbuf = new StringBuffer(4);
        for (int i = 0; i < 4; ++i) {
            char ch = (char)raf.read();
            sbuf.append(ch);
        }
        return sbuf.toString();
    }

    public static double read80BitDouble(RandomAccessFile raf) throws IOException {
        byte[] buf = new byte[10];
        raf.readFully(buf);
        ExtDouble xd = new ExtDouble(buf);
        return xd.toDouble();
    }

    public static Date timestampToDate(long timestamp) {
        Calendar cal = Calendar.getInstance();
        cal.set(1904, 0, 1, 0, 0, 0);
        int hours = (int)(timestamp / 3600L);
        int seconds = (int)(timestamp - (long)hours * 3600L);
        cal.add(11, hours);
        cal.add(13, seconds);
        Date dat = cal.getTime();
        return dat;
    }

    public static String formatDate(Date dat) {
        return dateFmt.format(dat);
    }

    public static String bytesToPascalString(byte[] data) {
        byte len = data[0];
        return new String(data, 0, (int)len, LATIN1);
    }

    public static String readPascalString(RandomAccessFile raf) throws IOException {
        int len = raf.read();
        byte[] buf = new byte[len + 1];
        raf.read(buf, 1, len);
        buf[0] = (byte)len;
        return AiffUtil.bytesToPascalString(buf);
    }
}

