/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.test;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;

public class MergeID3AndMP3Files {
    private static int count = 0;
    private static int failed = 0;

    public static void main(String[] args) {
        File mp3File;
        MergeID3AndMP3Files test = new MergeID3AndMP3Files();
        if (args.length == 0) {
            System.err.println("usage MergeID3AndMP3Files FromDir ToDir mp3File");
            System.err.println("      You must enter the from dir,outputdir and the mp3file to append");
            System.exit(1);
        } else if (args.length != 3) {
            System.err.println("usage MergeID3AndMP3Files FromDir ToDir mp3File");
            System.err.println("      Only three parameters accepted");
            System.exit(1);
        }
        File rootDir = new File(args[0]);
        if (!rootDir.isDirectory()) {
            System.err.println("usage MergeID3AndMP3Files FromDir ToDir mp3File");
            System.err.println("      Directory " + args[0] + " could not be found");
            System.exit(1);
        }
        File toDir = new File(args[1]);
        if (!rootDir.isDirectory()) {
            System.err.println("usage MergeID3AndMP3Files FromDir ToDir mp3File");
            System.err.println("      Directory " + args[1] + " could not be found");
            System.exit(1);
        }
        if (!(mp3File = new File(args[2])).isFile()) {
            System.err.println("usage MergeID3AndMP3Files FromDir ToDir mp3File");
            System.err.println("      Mp3File " + args[2] + " could not be found");
            System.exit(1);
        }
        Date start = new Date();
        System.out.println("Started to merge from:" + rootDir.getPath() + " at " + DateFormat.getTimeInstance().format(start));
        test.scanSingleDir(rootDir, toDir, mp3File);
        Date finish = new Date();
        System.out.println("Finished to merge from:" + rootDir.getPath() + DateFormat.getTimeInstance().format(finish));
        System.out.println("Attempted  to merge:" + count);
        System.out.println("Successful to merge:" + (count - failed));
        System.out.println("Failed     to merge:" + failed);
    }

    private void scanSingleDir(File fromDir, File toDir, File mp3File) {
        File[] audioFileDirs;
        File[] audioFiles = fromDir.listFiles(new MP3FileFilter());
        if (audioFiles.length > 0) {
            for (File audioFile : audioFiles) {
                ++count;
                try {
                    MergeID3AndMP3Files.copyAudioToTmp(toDir, audioFile, mp3File);
                }
                catch (Throwable t) {
                    System.err.println("Unable to merge record:" + count + ":" + mp3File.getPath());
                    ++failed;
                    t.printStackTrace();
                }
            }
        }
        if ((audioFileDirs = fromDir.listFiles(new DirFilter())).length > 0) {
            for (File audioFileDir : audioFileDirs) {
                this.scanSingleDir(audioFileDir, new File(toDir, audioFileDir.getName()), mp3File);
            }
        }
    }

    public static File copyAudioToTmp(File toDir, File tagFile, File mp3File) {
        File outputFile = new File(toDir.getPath(), tagFile.getName());
        boolean result = MergeID3AndMP3Files.append(tagFile, mp3File, outputFile);
        return outputFile;
    }

    private static boolean append(File fromFile1, File fromFile2, File toFile) {
        try {
            int theByte;
            FileInputStream in = new FileInputStream(fromFile1);
            FileInputStream in2 = new FileInputStream(fromFile2);
            toFile.getParentFile().mkdirs();
            FileOutputStream out = new FileOutputStream(toFile);
            BufferedInputStream inBuffer = new BufferedInputStream(in);
            BufferedInputStream inBuffer2 = new BufferedInputStream(in2);
            BufferedOutputStream outBuffer = new BufferedOutputStream(out);
            while ((theByte = inBuffer.read()) > -1) {
                outBuffer.write(theByte);
            }
            while ((theByte = inBuffer2.read()) > -1) {
                outBuffer.write(theByte);
            }
            outBuffer.close();
            inBuffer.close();
            inBuffer2.close();
            out.close();
            in.close();
            in2.close();
            if (fromFile1.length() + fromFile2.length() != toFile.length()) {
                toFile.delete();
                return false;
            }
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public final class DirFilter
    implements FileFilter {
        public static final String IDENT = "$Id$";

        public final boolean accept(File file) {
            return file.isDirectory();
        }
    }

    final class MP3FileFilter
    extends javax.swing.filechooser.FileFilter
    implements FileFilter {
        private final boolean allowDirectories;

        public MP3FileFilter() {
            this(false);
        }

        private MP3FileFilter(boolean allowDirectories) {
            this.allowDirectories = allowDirectories;
        }

        public final boolean accept(File file) {
            return file.getName().toLowerCase().endsWith(".mp3") || file.isDirectory() && this.allowDirectories;
        }

        public final String getDescription() {
            return ".mp3 Files";
        }
    }
}

