/*
 * Decompiled with CFR 0.152.
 */
package com.drew.lang;

import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import java.io.Serializable;

public class Rational
extends Number
implements Serializable {
    private static final long serialVersionUID = 510688928138848770L;
    private final long _numerator;
    private final long _denominator;

    public Rational(long l, long l2) {
        this._numerator = l;
        this._denominator = l2;
    }

    @Override
    public double doubleValue() {
        return (double)this._numerator / (double)this._denominator;
    }

    @Override
    public float floatValue() {
        return (float)this._numerator / (float)this._denominator;
    }

    @Override
    public final byte byteValue() {
        return (byte)this.doubleValue();
    }

    @Override
    public final int intValue() {
        return (int)this.doubleValue();
    }

    @Override
    public final long longValue() {
        return (long)this.doubleValue();
    }

    @Override
    public final short shortValue() {
        return (short)this.doubleValue();
    }

    public final long getDenominator() {
        return this._denominator;
    }

    public final long getNumerator() {
        return this._numerator;
    }

    @NotNull
    public Rational getReciprocal() {
        return new Rational(this._denominator, this._numerator);
    }

    public boolean isInteger() {
        return this._denominator == 1L || this._denominator != 0L && this._numerator % this._denominator == 0L || this._denominator == 0L && this._numerator == 0L;
    }

    @NotNull
    public String toString() {
        return this._numerator + "/" + this._denominator;
    }

    @NotNull
    public String toSimpleString(boolean bl) {
        String string;
        if (this._denominator == 0L && this._numerator != 0L) {
            return this.toString();
        }
        if (this.isInteger()) {
            return Integer.toString(this.intValue());
        }
        if (this._numerator != 1L && this._denominator % this._numerator == 0L) {
            long l = this._denominator / this._numerator;
            return new Rational(1L, l).toSimpleString(bl);
        }
        Rational rational = this.getSimplifiedInstance();
        if (bl && (string = Double.toString(rational.doubleValue())).length() < 5) {
            return string;
        }
        return rational.toString();
    }

    private boolean tooComplexForSimplification() {
        double d = (double)(Math.min(this._denominator, this._numerator) - 1L) / 5.0 + 2.0;
        return d > 1000.0;
    }

    public boolean equals(@Nullable Object object) {
        if (object == null || !(object instanceof Rational)) {
            return false;
        }
        Rational rational = (Rational)object;
        return this.doubleValue() == rational.doubleValue();
    }

    public int hashCode() {
        return 23 * (int)this._denominator + (int)this._numerator;
    }

    @NotNull
    public Rational getSimplifiedInstance() {
        if (this.tooComplexForSimplification()) {
            return this;
        }
        int n = 2;
        while ((long)n <= Math.min(this._denominator, this._numerator)) {
            if (!(n % 2 == 0 && n > 2 || n % 5 == 0 && n > 5 || this._denominator % (long)n != 0L || this._numerator % (long)n != 0L)) {
                return new Rational(this._numerator / (long)n, this._denominator / (long)n);
            }
            ++n;
        }
        return this;
    }
}

