/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif;

import com.drew.lang.Rational;
import com.drew.lang.StringUtil;
import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.TagDescriptor;
import com.drew.metadata.exif.ExifSubIFDDescriptor;
import com.drew.metadata.exif.NikonType2MakernoteDirectory;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;

public class NikonType2MakernoteDescriptor
extends TagDescriptor<NikonType2MakernoteDirectory> {
    public NikonType2MakernoteDescriptor(@NotNull NikonType2MakernoteDirectory nikonType2MakernoteDirectory) {
        super(nikonType2MakernoteDirectory);
    }

    @Override
    @Nullable
    public String getDescription(int n) {
        switch (n) {
            case 13: {
                return this.getProgramShiftDescription();
            }
            case 14: {
                return this.getExposureDifferenceDescription();
            }
            case 132: {
                return this.getLensDescription();
            }
            case 146: {
                return this.getHueAdjustmentDescription();
            }
            case 141: {
                return this.getColorModeDescription();
            }
            case 18: {
                return this.getAutoFlashCompensationDescription();
            }
            case 23: {
                return this.getFlashExposureCompensationDescription();
            }
            case 24: {
                return this.getFlashBracketCompensationDescription();
            }
            case 28: {
                return this.getExposureTuningDescription();
            }
            case 139: {
                return this.getLensStopsDescription();
            }
            case 30: {
                return this.getColorSpaceDescription();
            }
            case 34: {
                return this.getActiveDLightingDescription();
            }
            case 42: {
                return this.getVignetteControlDescription();
            }
            case 2: {
                return this.getIsoSettingDescription();
            }
            case 134: {
                return this.getDigitalZoomDescription();
            }
            case 135: {
                return this.getFlashUsedDescription();
            }
            case 136: {
                return this.getAutoFocusPositionDescription();
            }
            case 1: {
                return this.getFirmwareVersionDescription();
            }
            case 131: {
                return this.getLensTypeDescription();
            }
            case 137: {
                return this.getShootingModeDescription();
            }
            case 147: {
                return this.getNEFCompressionDescription();
            }
            case 177: {
                return this.getHighISONoiseReductionDescription();
            }
            case 182: {
                return this.getPowerUpTimeDescription();
            }
        }
        return super.getDescription(n);
    }

    @Nullable
    public String getPowerUpTimeDescription() {
        Long l = ((NikonType2MakernoteDirectory)this._directory).getLongObject(182);
        if (l == null) {
            return null;
        }
        return new Date(l).toString();
    }

    @Nullable
    public String getHighISONoiseReductionDescription() {
        Integer n = ((NikonType2MakernoteDirectory)this._directory).getInteger(177);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return "Off";
            }
            case 1: {
                return "Minimal";
            }
            case 2: {
                return "Low";
            }
            case 4: {
                return "Normal";
            }
            case 6: {
                return "High";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getFlashUsedDescription() {
        Integer n = ((NikonType2MakernoteDirectory)this._directory).getInteger(135);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return "Flash Not Used";
            }
            case 1: {
                return "Manual Flash";
            }
            case 3: {
                return "Flash Not Ready";
            }
            case 7: {
                return "External Flash";
            }
            case 8: {
                return "Fired, Commander Mode";
            }
            case 9: {
                return "Fired, TTL Mode";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getNEFCompressionDescription() {
        Integer n = ((NikonType2MakernoteDirectory)this._directory).getInteger(147);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 1: {
                return "Lossy (Type 1)";
            }
            case 3: {
                return "Uncompressed";
            }
            case 7: {
                return "Lossless";
            }
            case 8: {
                return "Lossy (Type 2)";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getShootingModeDescription() {
        Integer n = ((NikonType2MakernoteDirectory)this._directory).getInteger(137);
        if (n == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if ((n & 1) == 1) {
            arrayList.add("Continuous");
        } else {
            arrayList.add("Single Frame");
        }
        if ((n & 2) == 2) {
            arrayList.add("Delay");
        }
        if ((n & 8) == 8) {
            arrayList.add("PC Control");
        }
        if ((n & 0x10) == 16) {
            arrayList.add("Exposure Bracketing");
        }
        if ((n & 0x20) == 32) {
            arrayList.add("Auto ISO");
        }
        if ((n & 0x40) == 64) {
            arrayList.add("White-Balance Bracketing");
        }
        if ((n & 0x80) == 128) {
            arrayList.add("IR Control");
        }
        return StringUtil.join(arrayList, ", ");
    }

    @Nullable
    public String getLensTypeDescription() {
        Integer n = ((NikonType2MakernoteDirectory)this._directory).getInteger(131);
        if (n == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if ((n & 1) == 1) {
            arrayList.add("MF");
        } else {
            arrayList.add("AF");
        }
        if ((n & 2) == 2) {
            arrayList.add("D");
        }
        if ((n & 4) == 4) {
            arrayList.add("G");
        }
        if ((n & 8) == 8) {
            arrayList.add("VR");
        }
        return StringUtil.join(arrayList, ", ");
    }

    @Nullable
    public String getColorSpaceDescription() {
        Integer n = ((NikonType2MakernoteDirectory)this._directory).getInteger(30);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 1: {
                return "sRGB";
            }
            case 2: {
                return "Adobe RGB";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getActiveDLightingDescription() {
        Integer n = ((NikonType2MakernoteDirectory)this._directory).getInteger(34);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return "Off";
            }
            case 1: {
                return "Light";
            }
            case 3: {
                return "Normal";
            }
            case 5: {
                return "High";
            }
            case 7: {
                return "Extra High";
            }
            case 65535: {
                return "Auto";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getVignetteControlDescription() {
        Integer n = ((NikonType2MakernoteDirectory)this._directory).getInteger(42);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return "Off";
            }
            case 1: {
                return "Low";
            }
            case 3: {
                return "Normal";
            }
            case 5: {
                return "High";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getAutoFocusPositionDescription() {
        int[] nArray = ((NikonType2MakernoteDirectory)this._directory).getIntArray(136);
        if (nArray == null) {
            return null;
        }
        if (nArray.length != 4 || nArray[0] != 0 || nArray[2] != 0 || nArray[3] != 0) {
            return "Unknown (" + ((NikonType2MakernoteDirectory)this._directory).getString(136) + ")";
        }
        switch (nArray[1]) {
            case 0: {
                return "Centre";
            }
            case 1: {
                return "Top";
            }
            case 2: {
                return "Bottom";
            }
            case 3: {
                return "Left";
            }
            case 4: {
                return "Right";
            }
        }
        return "Unknown (" + nArray[1] + ")";
    }

    @Nullable
    public String getDigitalZoomDescription() {
        Rational rational = ((NikonType2MakernoteDirectory)this._directory).getRational(134);
        if (rational == null) {
            return null;
        }
        return rational.intValue() == 1 ? "No digital zoom" : rational.toSimpleString(true) + "x digital zoom";
    }

    @Nullable
    public String getProgramShiftDescription() {
        int[] nArray = ((NikonType2MakernoteDirectory)this._directory).getIntArray(13);
        return NikonType2MakernoteDescriptor.getEVDescription(nArray);
    }

    @Nullable
    public String getExposureDifferenceDescription() {
        int[] nArray = ((NikonType2MakernoteDirectory)this._directory).getIntArray(14);
        return NikonType2MakernoteDescriptor.getEVDescription(nArray);
    }

    @NotNull
    public String getAutoFlashCompensationDescription() {
        int[] nArray = ((NikonType2MakernoteDirectory)this._directory).getIntArray(18);
        return NikonType2MakernoteDescriptor.getEVDescription(nArray);
    }

    @NotNull
    public String getFlashExposureCompensationDescription() {
        int[] nArray = ((NikonType2MakernoteDirectory)this._directory).getIntArray(23);
        return NikonType2MakernoteDescriptor.getEVDescription(nArray);
    }

    @NotNull
    public String getFlashBracketCompensationDescription() {
        int[] nArray = ((NikonType2MakernoteDirectory)this._directory).getIntArray(24);
        return NikonType2MakernoteDescriptor.getEVDescription(nArray);
    }

    @NotNull
    public String getExposureTuningDescription() {
        int[] nArray = ((NikonType2MakernoteDirectory)this._directory).getIntArray(28);
        return NikonType2MakernoteDescriptor.getEVDescription(nArray);
    }

    @NotNull
    public String getLensStopsDescription() {
        int[] nArray = ((NikonType2MakernoteDirectory)this._directory).getIntArray(139);
        return NikonType2MakernoteDescriptor.getEVDescription(nArray);
    }

    @Nullable
    private static String getEVDescription(@Nullable int[] nArray) {
        if (nArray == null) {
            return null;
        }
        if (nArray.length < 3 || nArray[2] == 0) {
            return null;
        }
        DecimalFormat decimalFormat = new DecimalFormat("0.##");
        double d = (double)(nArray[0] * nArray[1]) / (double)nArray[2];
        return decimalFormat.format(d) + " EV";
    }

    @Nullable
    public String getIsoSettingDescription() {
        int[] nArray = ((NikonType2MakernoteDirectory)this._directory).getIntArray(2);
        if (nArray == null) {
            return null;
        }
        if (nArray[0] != 0 || nArray[1] == 0) {
            return "Unknown (" + ((NikonType2MakernoteDirectory)this._directory).getString(2) + ")";
        }
        return "ISO " + nArray[1];
    }

    @Nullable
    public String getLensDescription() {
        Rational[] rationalArray = ((NikonType2MakernoteDirectory)this._directory).getRationalArray(132);
        if (rationalArray == null) {
            return null;
        }
        if (rationalArray.length < 4) {
            return ((NikonType2MakernoteDirectory)this._directory).getString(132);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(rationalArray[0].intValue());
        stringBuilder.append('-');
        stringBuilder.append(rationalArray[1].intValue());
        stringBuilder.append("mm f/");
        stringBuilder.append(rationalArray[2].floatValue());
        stringBuilder.append('-');
        stringBuilder.append(rationalArray[3].floatValue());
        return stringBuilder.toString();
    }

    @Nullable
    public String getHueAdjustmentDescription() {
        String string = ((NikonType2MakernoteDirectory)this._directory).getString(146);
        if (string == null) {
            return null;
        }
        return string + " degrees";
    }

    @Nullable
    public String getColorModeDescription() {
        String string = ((NikonType2MakernoteDirectory)this._directory).getString(141);
        if (string == null) {
            return null;
        }
        if (string.startsWith("MODE1")) {
            return "Mode I (sRGB)";
        }
        return string;
    }

    @Nullable
    public String getFirmwareVersionDescription() {
        int[] nArray = ((NikonType2MakernoteDirectory)this._directory).getIntArray(1);
        if (nArray == null) {
            return null;
        }
        return ExifSubIFDDescriptor.convertBytesToVersionString(nArray, 2);
    }
}

