/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.io;

import ezvcard.Ezvcard;
import ezvcard.VCard;
import ezvcard.VCardVersion;
import ezvcard.io.scribe.ScribeIndex;
import ezvcard.io.scribe.VCardPropertyScribe;
import ezvcard.parameter.AddressType;
import ezvcard.property.Address;
import ezvcard.property.Label;
import ezvcard.property.ProductId;
import ezvcard.property.RawProperty;
import ezvcard.property.TextProperty;
import ezvcard.property.VCardProperty;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StreamWriter
implements Closeable {
    protected ScribeIndex index = new ScribeIndex();
    protected boolean addProdId = true;
    protected boolean versionStrict = true;

    public void write(VCard vcard) throws IOException {
        List<VCardProperty> properties = this.prepare(vcard);
        this._write(vcard, properties);
    }

    protected abstract void _write(VCard var1, List<VCardProperty> var2) throws IOException;

    protected abstract VCardVersion getTargetVersion();

    public boolean isAddProdId() {
        return this.addProdId;
    }

    public void setAddProdId(boolean addProdId) {
        this.addProdId = addProdId;
    }

    public boolean isVersionStrict() {
        return this.versionStrict;
    }

    public void setVersionStrict(boolean versionStrict) {
        this.versionStrict = versionStrict;
    }

    public void registerScribe(VCardPropertyScribe<? extends VCardProperty> scribe) {
        this.index.register(scribe);
    }

    public ScribeIndex getScribeIndex() {
        return this.index;
    }

    public void setScribeIndex(ScribeIndex index) {
        this.index = index;
    }

    private List<VCardProperty> prepare(VCard vcard) {
        VCardVersion targetVersion = this.getTargetVersion();
        ArrayList<VCardProperty> propertiesToAdd = new ArrayList<VCardProperty>();
        HashSet unregistered = new HashSet();
        for (VCardProperty property : vcard) {
            Address adr;
            String labelStr;
            if (this.addProdId && property instanceof ProductId || this.versionStrict && !property.getSupportedVersions().contains((Object)targetVersion)) continue;
            if (!this.index.hasPropertyScribe(property)) {
                unregistered.add(property.getClass());
                continue;
            }
            propertiesToAdd.add(property);
            if (!(property instanceof Address) || targetVersion != VCardVersion.V2_1 && targetVersion != VCardVersion.V3_0 || (labelStr = (adr = (Address)property).getLabel()) == null) continue;
            Label label = new Label(labelStr);
            for (AddressType adrType : adr.getTypes()) {
                label.addType(adrType);
            }
            propertiesToAdd.add(label);
        }
        if (!unregistered.isEmpty()) {
            throw new IllegalArgumentException("No scribes were found the following property classes: " + unregistered);
        }
        if (this.addProdId) {
            TextProperty property = targetVersion == VCardVersion.V2_1 ? new RawProperty("X-PRODID", "ez-vcard " + Ezvcard.VERSION) : new ProductId("ez-vcard " + Ezvcard.VERSION);
            propertiesToAdd.add(property);
        }
        return propertiesToAdd;
    }
}

