/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.io.html;

import ezvcard.VCard;
import ezvcard.VCardVersion;
import ezvcard.io.CannotParseException;
import ezvcard.io.EmbeddedVCardException;
import ezvcard.io.SkipMeException;
import ezvcard.io.StreamReader;
import ezvcard.io.html.HCardElement;
import ezvcard.io.scribe.RawPropertyScribe;
import ezvcard.io.scribe.VCardPropertyScribe;
import ezvcard.property.Categories;
import ezvcard.property.Email;
import ezvcard.property.Impp;
import ezvcard.property.Label;
import ezvcard.property.Nickname;
import ezvcard.property.RawProperty;
import ezvcard.property.Telephone;
import ezvcard.property.Url;
import ezvcard.property.VCardProperty;
import ezvcard.util.HtmlUtils;
import ezvcard.util.IOUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class HCardParser
extends StreamReader {
    private final String pageUrl;
    private final Elements vcardElements;
    private final Iterator<Element> vcardElementsIt;
    private final List<Label> labels = new ArrayList<Label>();
    private VCard vcard;
    private Elements embeddedVCards = new Elements();
    private Nickname nickname;
    private Categories categories;
    private final String urlPropertyName = this.index.getPropertyScribe(Url.class).getPropertyName().toLowerCase();
    private final String categoriesName = this.index.getPropertyScribe(Categories.class).getPropertyName().toLowerCase();
    private final String emailName = this.index.getPropertyScribe(Email.class).getPropertyName().toLowerCase();
    private final String telName = this.index.getPropertyScribe(Telephone.class).getPropertyName().toLowerCase();

    public HCardParser(URL url) throws IOException {
        this(Jsoup.parse((URL)url, (int)30000), url.toString());
    }

    public HCardParser(InputStream in) throws IOException {
        this(in, null);
    }

    public HCardParser(InputStream in, String pageUrl) throws IOException {
        this(pageUrl == null ? Jsoup.parse((InputStream)in, null, (String)"") : Jsoup.parse((InputStream)in, null, (String)pageUrl), pageUrl);
    }

    public HCardParser(File file) throws IOException {
        this(file, null);
    }

    public HCardParser(File file, String pageUrl) throws IOException {
        this(pageUrl == null ? Jsoup.parse((File)file, null, (String)"") : Jsoup.parse((File)file, null, (String)pageUrl), pageUrl);
    }

    public HCardParser(Reader reader) throws IOException {
        this(reader, null);
    }

    public HCardParser(Reader reader, String pageUrl) throws IOException {
        this(IOUtils.toString(reader), pageUrl);
    }

    public HCardParser(String html) {
        this(html, null);
    }

    public HCardParser(String html, String pageUrl) {
        this(pageUrl == null ? Jsoup.parse((String)html) : Jsoup.parse((String)html, (String)pageUrl), pageUrl);
    }

    public HCardParser(Document document) {
        this(document, null);
    }

    public HCardParser(Document document, String pageUrl) {
        this.pageUrl = pageUrl;
        String anchor = null;
        if (pageUrl != null) {
            try {
                URL url = new URL(pageUrl);
                anchor = url.getRef();
            }
            catch (MalformedURLException e) {
                anchor = null;
            }
        }
        Element searchUnder = null;
        if (anchor != null) {
            searchUnder = document.getElementById(anchor);
        }
        if (searchUnder == null) {
            searchUnder = document;
        }
        this.vcardElements = searchUnder.getElementsByClass("vcard");
        this.vcardElementsIt = this.vcardElements.iterator();
    }

    private HCardParser(Element embeddedVCard, String pageUrl) {
        this.pageUrl = pageUrl;
        this.vcardElements = new Elements(new Element[]{embeddedVCard});
        this.vcardElementsIt = this.vcardElements.iterator();
    }

    public VCard readNext() {
        try {
            return super.readNext();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected VCard _readNext() {
        if (!this.vcardElementsIt.hasNext()) {
            return null;
        }
        Element vcardElement = this.vcardElementsIt.next();
        while (HtmlUtils.isChildOf(vcardElement, this.vcardElements)) {
            if (!this.vcardElementsIt.hasNext()) {
                return null;
            }
            vcardElement = this.vcardElementsIt.next();
        }
        this.parseVCardElement(vcardElement);
        return this.vcard;
    }

    private void parseVCardElement(Element vcardElement) {
        this.labels.clear();
        this.nickname = null;
        this.categories = null;
        this.vcard = new VCard();
        this.vcard.setVersion(VCardVersion.V3_0);
        if (this.pageUrl != null) {
            this.vcard.addSource(this.pageUrl);
        }
        for (Element child : vcardElement.children()) {
            this.visit(child);
        }
        this.assignLabels(this.vcard, this.labels);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void visit(Element element) {
        boolean visitChildren = true;
        Set classNames = element.classNames();
        for (String className : classNames) {
            VCardProperty property;
            RawPropertyScribe scribe;
            VCardPropertyScribe.Result<? extends VCardProperty> result;
            String href;
            if (this.urlPropertyName.equals(className = className.toLowerCase()) && (href = element.attr("href")).length() > 0) {
                if (!classNames.contains(this.emailName) && href.matches("(?i)mailto:.*")) {
                    className = this.emailName;
                } else if (!classNames.contains(this.telName) && href.matches("(?i)tel:.*")) {
                    className = this.telName;
                } else {
                    VCardPropertyScribe<? extends VCardProperty> scribe2 = this.index.getPropertyScribe(Impp.class);
                    try {
                        result = scribe2.parseHtml(new HCardElement(element));
                        this.vcard.addProperty(result.getProperty());
                        for (String warning : result.getWarnings()) {
                            this.warnings.add(null, scribe2.getPropertyName(), warning);
                        }
                        continue;
                    }
                    catch (SkipMeException e) {
                    }
                    catch (CannotParseException e) {
                        // empty catch block
                    }
                }
            }
            if ("category".equals(className)) {
                className = this.categoriesName;
            }
            if ((scribe = this.index.getPropertyScribe(className)) == null) {
                if (!className.startsWith("x-")) continue;
                scribe = new RawPropertyScribe(className);
            }
            try {
                result = scribe.parseHtml(new HCardElement(element));
                for (String warning : result.getWarnings()) {
                    this.warnings.add(null, className, warning);
                }
                property = result.getProperty();
                if (property instanceof Label) {
                    this.labels.add((Label)property);
                    continue;
                }
                if (property instanceof Nickname) {
                    Nickname nn = (Nickname)property;
                    if (this.nickname == null) {
                        this.nickname = nn;
                        this.vcard.addProperty(this.nickname);
                        continue;
                    }
                    this.nickname.getValues().addAll(nn.getValues());
                    continue;
                }
                if (property instanceof Categories) {
                    Categories c = (Categories)property;
                    if (this.categories == null) {
                        this.categories = c;
                        this.vcard.addProperty(this.categories);
                        continue;
                    }
                    this.categories.getValues().addAll(c.getValues());
                    continue;
                }
            }
            catch (SkipMeException e) {
                this.warnings.add(null, className, 22, e.getMessage());
                continue;
            }
            catch (CannotParseException e) {
                String html = element.outerHtml();
                this.warnings.add(null, className, 32, html, e.getMessage());
                property = new RawProperty(className, html);
            }
            catch (EmbeddedVCardException e) {
                if (HtmlUtils.isChildOf(element, this.embeddedVCards)) continue;
                property = e.getProperty();
                this.embeddedVCards.add(element);
                HCardParser embeddedReader = new HCardParser(element, this.pageUrl);
                try {
                    VCard embeddedVCard = embeddedReader.readNext();
                    e.injectVCard(embeddedVCard);
                }
                catch (Throwable throwable) {
                    for (String warning : embeddedReader.getWarnings()) {
                        this.warnings.add(null, className, 26, warning);
                    }
                    IOUtils.closeQuietly(embeddedReader);
                    throw throwable;
                }
                for (String warning : embeddedReader.getWarnings()) {
                    this.warnings.add(null, className, 26, warning);
                }
                IOUtils.closeQuietly(embeddedReader);
                visitChildren = false;
            }
            this.vcard.addProperty(property);
        }
        if (visitChildren) {
            for (Element child : element.children()) {
                this.visit(child);
            }
        }
    }

    public void close() {
    }
}

