/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.io.scribe;

import ezvcard.VCard;
import ezvcard.VCardVersion;
import ezvcard.io.html.HCardElement;
import ezvcard.io.scribe.StringPropertyScribe;
import ezvcard.parameter.VCardParameters;
import ezvcard.property.Email;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmailScribe
extends StringPropertyScribe<Email> {
    public EmailScribe() {
        super(Email.class, "EMAIL");
    }

    @Override
    protected void _prepareParameters(Email property, VCardParameters copy, VCardVersion version, VCard vcard) {
        EmailScribe.handlePrefParam(property, copy, version, vcard);
    }

    @Override
    protected Email _parseValue(String value) {
        return new Email(value);
    }

    @Override
    protected Email _parseHtml(HCardElement element, List<String> warnings) {
        Pattern p;
        Matcher m;
        String href = element.attr("href");
        String email = href.length() > 0 ? ((m = (p = Pattern.compile("^mailto:(.*)$", 2)).matcher(href)).find() ? m.group(1) : element.value()) : element.value();
        Email property = new Email(email);
        List<String> types = element.types();
        for (String type : types) {
            property.getParameters().addType(type);
        }
        return property;
    }
}

