/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.io.scribe;

import ezvcard.VCardDataType;
import ezvcard.VCardVersion;
import ezvcard.io.html.HCardElement;
import ezvcard.io.json.JCardValue;
import ezvcard.io.scribe.VCardPropertyScribe;
import ezvcard.io.xml.XCardElement;
import ezvcard.parameter.VCardParameters;
import ezvcard.property.VCardProperty;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SimplePropertyScribe<T extends VCardProperty>
extends VCardPropertyScribe<T> {
    protected final VCardDataType dataType;

    public SimplePropertyScribe(Class<T> clazz, String propertyName, VCardDataType dataType) {
        super(clazz, propertyName);
        this.dataType = dataType;
    }

    @Override
    protected VCardDataType _defaultDataType(VCardVersion version) {
        return this.dataType;
    }

    @Override
    protected String _writeText(T property, VCardVersion version) {
        String value = this._writeValue(property);
        return value == null ? "" : SimplePropertyScribe.escape(value);
    }

    @Override
    protected T _parseText(String value, VCardDataType dataType, VCardVersion version, VCardParameters parameters, List<String> warnings) {
        value = SimplePropertyScribe.unescape(value);
        return this._parseValue(value);
    }

    @Override
    protected void _writeXml(T property, XCardElement parent) {
        parent.append(this.dataType, this._writeValue(property));
    }

    @Override
    protected T _parseXml(XCardElement element, VCardParameters parameters, List<String> warnings) {
        String value = element.first(this.dataType);
        if (value != null) {
            return this._parseValue(value);
        }
        throw VCardPropertyScribe.missingXmlElements(this.dataType);
    }

    @Override
    protected T _parseHtml(HCardElement element, List<String> warnings) {
        String value = element.value();
        return this._parseValue(value);
    }

    @Override
    protected JCardValue _writeJson(T property) {
        String value = this._writeValue(property);
        if (value == null) {
            value = "";
        }
        return JCardValue.single(value);
    }

    @Override
    protected T _parseJson(JCardValue value, VCardDataType dataType, VCardParameters parameters, List<String> warnings) {
        String valueStr = value.asSingle();
        return this._parseValue(valueStr);
    }

    protected abstract String _writeValue(T var1);

    protected abstract T _parseValue(String var1);
}

