/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.property;

import ezvcard.VCard;
import ezvcard.VCardVersion;
import ezvcard.Warning;
import ezvcard.parameter.RelatedType;
import ezvcard.property.HasAltId;
import ezvcard.property.VCardProperty;
import ezvcard.util.TelUri;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Related
extends VCardProperty
implements HasAltId {
    private String uri;
    private String text;

    public Related() {
    }

    public Related(String uri) {
        this.setUri(uri);
    }

    public static Related email(String email) {
        return new Related("mailto:" + email);
    }

    public static Related im(String protocol, String handle) {
        return new Related(protocol + ":" + handle);
    }

    public static Related telephone(TelUri telUri) {
        return new Related(telUri.toString());
    }

    @Override
    public Set<VCardVersion> _supportedVersions() {
        return EnumSet.of(VCardVersion.V4_0);
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
        this.text = null;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        this.uri = null;
    }

    public Set<RelatedType> getTypes() {
        Set<String> values = this.parameters.getTypes();
        HashSet<RelatedType> types = new HashSet<RelatedType>(values.size());
        for (String value : values) {
            types.add(RelatedType.get(value));
        }
        return types;
    }

    public void addType(RelatedType type) {
        this.parameters.addType(type.getValue());
    }

    public void removeType(RelatedType type) {
        this.parameters.removeType(type.getValue());
    }

    @Override
    public List<Integer[]> getPids() {
        return super.getPids();
    }

    @Override
    public void addPid(int localId, int clientPidMapRef) {
        super.addPid(localId, clientPidMapRef);
    }

    @Override
    public void removePids() {
        super.removePids();
    }

    @Override
    public Integer getPref() {
        return super.getPref();
    }

    @Override
    public void setPref(Integer pref) {
        super.setPref(pref);
    }

    @Override
    public String getAltId() {
        return this.parameters.getAltId();
    }

    @Override
    public void setAltId(String altId) {
        this.parameters.setAltId(altId);
    }

    @Override
    protected void _validate(List<Warning> warnings, VCardVersion version, VCard vcard) {
        if (this.uri == null && this.text == null) {
            warnings.add(new Warning(8, new Object[0]));
        }
    }
}

