/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListMultimap<K, V>
implements Iterable<Map.Entry<K, List<V>>> {
    private final Map<K, List<V>> map;

    public ListMultimap() {
        this.map = new LinkedHashMap<K, List<V>>();
    }

    public ListMultimap(int initialCapacity) {
        this.map = new LinkedHashMap<K, List<V>>(initialCapacity);
    }

    public ListMultimap(ListMultimap<K, V> orig) {
        this();
        for (Map.Entry<K, List<V>> entry : orig) {
            ArrayList values = new ArrayList(entry.getValue());
            this.map.put(entry.getKey(), values);
        }
    }

    public void put(K key, V value) {
        List<V> values = this.get(key, true);
        values.add(value);
    }

    public void putAll(K key, Collection<V> values) {
        List<V> existingValues = this.get(key, true);
        existingValues.addAll(values);
    }

    public List<V> get(K key) {
        return this.get(key, false);
    }

    private List<V> get(K key, boolean add) {
        List<V> values = this.map.get(key = this.sanitizeKey(key));
        if (values == null) {
            values = new ArrayList<V>();
            if (add) {
                this.map.put(key, values);
            }
        }
        return values;
    }

    public V first(K key) {
        List<V> values = this.get(key);
        return values == null || values.isEmpty() ? null : (V)values.get(0);
    }

    public boolean containsKey(K key) {
        return this.map.containsKey(key);
    }

    public boolean remove(K key, V value) {
        List<V> values = this.map.get(this.sanitizeKey(key));
        if (values != null) {
            return values.remove(value);
        }
        return false;
    }

    public List<V> removeAll(K key) {
        List<V> removed = this.map.remove(this.sanitizeKey(key));
        return removed == null ? Collections.emptyList() : removed;
    }

    public List<V> replace(K key, V value) {
        List<V> replaced = this.removeAll(key);
        if (value != null) {
            this.put(key, value);
        }
        return replaced;
    }

    public List<V> replace(K key, Collection<V> values) {
        List<V> replaced = this.removeAll(key);
        if (values != null && !values.isEmpty()) {
            this.putAll(key, values);
        }
        return replaced;
    }

    public void clear() {
        this.map.clear();
    }

    public Set<K> keySet() {
        return this.map.keySet();
    }

    public List<V> values() {
        ArrayList<V> list = new ArrayList<V>();
        for (List<V> value : this.map.values()) {
            list.addAll(value);
        }
        return list;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int size() {
        int size = 0;
        for (List<V> value : this.map.values()) {
            size += value.size();
        }
        return size;
    }

    public Map<K, List<V>> getMap() {
        return this.map;
    }

    protected K sanitizeKey(K key) {
        return key;
    }

    @Override
    public Iterator<Map.Entry<K, List<V>>> iterator() {
        return this.map.entrySet().iterator();
    }

    public String toString() {
        return this.map.toString();
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ListMultimap other = (ListMultimap)obj;
        return this.map.equals(other.map);
    }
}

