/*
 * Decompiled with CFR 0.152.
 */
package com.javacodegeeks.stringsearch;

import java.util.ArrayList;
import java.util.List;

public class BOM {
    private static final char TRUE = '\u0001';
    private static final char FALSE = '\u0000';
    private static final int UNDEFINED = -1;
    private char[] x;
    private char[] t;
    private Cell[] list;
    private int m;

    private static int getTransition(char[] x, int p, Cell[] list, char c) {
        if (p > 0 && x[p - 1] == c) {
            return p - 1;
        }
        Cell cell = list[p];
        while (cell != null) {
            if (x[cell.element] == c) {
                return cell.element;
            }
            cell = cell.next;
        }
        return -1;
    }

    private static void setTransition(int p, int q, Cell[] list) {
        Cell cell = new Cell();
        cell.element = q;
        cell.next = list[p];
        list[p] = cell;
    }

    private static void oracle(char[] x, char[] t, Cell[] list) {
        int p;
        int q = -1;
        int m = x.length - 1;
        int[] s = new int[x.length];
        s[m] = m + 1;
        for (int i = m; i > 0; --i) {
            char c = x[i - 1];
            p = s[i];
            while (p <= m && (q = BOM.getTransition(x, p, list, c)) == -1) {
                BOM.setTransition(p, i - 1, list);
                p = s[p];
            }
            s[i - 1] = p == m + 1 ? m : q;
        }
        p = 0;
        while (p <= m) {
            t[p] = '\u0001';
            p = s[p];
        }
    }

    public static List<Integer> findAll(String pattern, String source) {
        int shift;
        int i;
        char[] ptrn = pattern.toCharArray();
        char[] y = source.toCharArray();
        char[] x = new char[ptrn.length + 1];
        System.arraycopy(ptrn, 0, x, 0, ptrn.length);
        int period = 0;
        int m = ptrn.length;
        int n = y.length;
        ArrayList<Integer> result = new ArrayList<Integer>();
        char[] t = new char[x.length];
        Cell[] list = new Cell[x.length];
        for (i = 0; i < t.length; ++i) {
            t[i] = '\u0000';
        }
        BOM.oracle(x, t, list);
        for (int j = 0; j <= n - m; j += shift) {
            int q;
            i = m - 1;
            int p = m;
            shift = m;
            while (i + j >= 0 && (q = BOM.getTransition(x, p, list, y[i + j])) != -1) {
                p = q;
                if (t[p] == '\u0001') {
                    period = shift;
                    shift = i;
                }
                --i;
            }
            if (i >= 0) continue;
            result.add(j);
            shift = period;
        }
        return result;
    }

    public static BOM compile(String pattern) {
        char[] ptrn = pattern.toCharArray();
        char[] x = new char[ptrn.length + 1];
        System.arraycopy(ptrn, 0, x, 0, ptrn.length);
        int m = ptrn.length;
        char[] t = new char[x.length];
        Cell[] list = new Cell[x.length];
        for (int i = 0; i < t.length; ++i) {
            t[i] = '\u0000';
        }
        BOM.oracle(x, t, list);
        BOM bom = new BOM();
        bom.m = m;
        bom.x = x;
        bom.t = t;
        bom.list = list;
        return bom;
    }

    public List<Integer> findAll(String source) {
        int shift;
        char[] y = source.toCharArray();
        int period = 0;
        int n = y.length;
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int j = 0; j <= n - this.m; j += shift) {
            int q;
            int i = this.m - 1;
            int p = this.m;
            shift = this.m;
            while (i + j >= 0 && (q = BOM.getTransition(this.x, p, this.list, y[i + j])) != -1) {
                p = q;
                if (this.t[p] == '\u0001') {
                    period = shift;
                    shift = i;
                }
                --i;
            }
            if (i >= 0) continue;
            result.add(j);
            shift = period;
        }
        return result;
    }

    private static class Cell {
        int element;
        Cell next;

        private Cell() {
        }
    }
}

