/*
 * Decompiled with CFR 0.152.
 */
package com.javacodegeeks.stringsearch;

import java.util.ArrayList;
import java.util.List;

public class KPMSS {
    private char[] x;
    private int m;
    private int[] kmpNext;
    private int[] list;
    private int[] mpNext;
    private int[] z;

    private static void preMp(char[] x, int[] mpNext) {
        int m = x.length - 1;
        int i = 0;
        mpNext[0] = -1;
        int j = -1;
        while (i < m) {
            while (j > -1 && x[i] != x[j]) {
                j = mpNext[j];
            }
            mpNext[++i] = ++j;
        }
    }

    private static void preKmp(char[] x, int[] kmpNext) {
        int m = x.length - 1;
        int i = 0;
        kmpNext[0] = -1;
        int j = -1;
        while (i < m) {
            while (j > -1 && x[i] != x[j]) {
                j = kmpNext[j];
            }
            if (x[++i] == x[++j]) {
                kmpNext[i] = kmpNext[j];
                continue;
            }
            kmpNext[i] = j;
        }
    }

    private static int attempt(char[] y, char[] x, int start, int wall) {
        int k;
        int m = x.length - 1;
        for (k = wall - start; k < m && x[k] == y[k + start]; ++k) {
        }
        return k;
    }

    public static List<Integer> findAll(String pattern, String source) {
        int i;
        char[] ptrn = pattern.toCharArray();
        char[] y = source.toCharArray();
        char[] x = new char[ptrn.length + 1];
        System.arraycopy(ptrn, 0, x, 0, ptrn.length);
        int m = ptrn.length;
        int n = y.length;
        ArrayList<Integer> result = new ArrayList<Integer>();
        int[] kmpNext = new int[x.length];
        int[] list = new int[x.length];
        int[] mpNext = new int[x.length];
        int[] z = new int[65536];
        KPMSS.preMp(x, mpNext);
        KPMSS.preKmp(x, kmpNext);
        for (i = 0; i < z.length; ++i) {
            z[i] = -1;
        }
        for (i = 0; i < m; ++i) {
            list[i] = -1;
        }
        z[x[0]] = 0;
        for (i = 1; i < m; ++i) {
            list[i] = z[x[i]];
            z[x[i]] = i;
        }
        int wall = 0;
        int per = m - kmpNext[m];
        int j = -1;
        i = -1;
        while ((j += m) < n && z[y[j]] < 0) {
        }
        if (j >= n) {
            return result;
        }
        i = z[y[j]];
        int start = j - i;
        while (start <= n - m) {
            if (start > wall) {
                wall = start;
            }
            int k = KPMSS.attempt(y, x, start, wall);
            wall = start + k;
            if (k == m) {
                result.add(start);
                i -= per;
            } else {
                i = list[i];
            }
            if (i < 0) {
                while ((j += m) < n && z[y[j]] < 0) {
                }
                if (j >= n) {
                    return result;
                }
                i = z[y[j]];
            }
            int kmpStart = start + k - kmpNext[k];
            k = kmpNext[k];
            start = j - i;
            while (start < kmpStart || kmpStart < start && start < wall) {
                if (start < kmpStart) {
                    if ((i = list[i]) < 0) {
                        while ((j += m) < n && z[y[j]] < 0) {
                        }
                        if (j >= n) {
                            return result;
                        }
                        i = z[y[j]];
                    }
                    start = j - i;
                    continue;
                }
                kmpStart += k - mpNext[k];
                k = mpNext[k];
            }
        }
        return result;
    }

    public static KPMSS compile(String pattern) {
        int i;
        char[] ptrn = pattern.toCharArray();
        char[] x = new char[ptrn.length + 1];
        System.arraycopy(ptrn, 0, x, 0, ptrn.length);
        int m = ptrn.length;
        int[] kmpNext = new int[x.length];
        int[] list = new int[x.length];
        int[] mpNext = new int[x.length];
        int[] z = new int[65536];
        KPMSS.preMp(x, mpNext);
        KPMSS.preKmp(x, kmpNext);
        for (i = 0; i < z.length; ++i) {
            z[i] = -1;
        }
        for (i = 0; i < m; ++i) {
            list[i] = -1;
        }
        z[x[0]] = 0;
        for (i = 1; i < m; ++i) {
            list[i] = z[x[i]];
            z[x[i]] = i;
        }
        KPMSS kpmss = new KPMSS();
        kpmss.x = x;
        kpmss.m = m;
        kpmss.kmpNext = kmpNext;
        kpmss.list = list;
        kpmss.mpNext = mpNext;
        kpmss.z = z;
        return kpmss;
    }

    public List<Integer> findAll(String source) {
        char[] y = source.toCharArray();
        int n = y.length;
        ArrayList<Integer> result = new ArrayList<Integer>();
        int wall = 0;
        int per = this.m - this.kmpNext[this.m];
        int j = -1;
        int i = -1;
        while ((j += this.m) < n && this.z[y[j]] < 0) {
        }
        if (j >= n) {
            return result;
        }
        i = this.z[y[j]];
        int start = j - i;
        while (start <= n - this.m) {
            if (start > wall) {
                wall = start;
            }
            int k = KPMSS.attempt(y, this.x, start, wall);
            wall = start + k;
            if (k == this.m) {
                result.add(start);
                i -= per;
            } else {
                i = this.list[i];
            }
            if (i < 0) {
                while ((j += this.m) < n && this.z[y[j]] < 0) {
                }
                if (j >= n) {
                    return result;
                }
                i = this.z[y[j]];
            }
            int kmpStart = start + k - this.kmpNext[k];
            k = this.kmpNext[k];
            start = j - i;
            while (start < kmpStart || kmpStart < start && start < wall) {
                if (start < kmpStart) {
                    if ((i = this.list[i]) < 0) {
                        while ((j += this.m) < n && this.z[y[j]] < 0) {
                        }
                        if (j >= n) {
                            return result;
                        }
                        i = this.z[y[j]];
                    }
                    start = j - i;
                    continue;
                }
                kmpStart += k - this.mpNext[k];
                k = this.mpNext[k];
            }
        }
        return result;
    }
}

