/*
 * Decompiled with CFR 0.152.
 */
package com.javacodegeeks.stringsearch;

import java.util.ArrayList;
import java.util.List;

public class OM {
    private static void orderPattern(char[] x, Pattern[] pat, int[] freq) {
        for (int i = 0; i < x.length; ++i) {
            Pattern ptrn = new Pattern();
            ptrn.loc = i;
            ptrn.c = x[i];
            pat[i] = ptrn;
        }
        OM.qsortPtrn(pat, 0, x.length - 1, freq);
    }

    private static void qsortPtrn(Pattern[] pat, int low, int n, int[] freq) {
        int lo = low;
        int hi = n;
        if (lo >= n) {
            return;
        }
        Pattern mid = pat[(lo + hi) / 2];
        while (lo < hi) {
            while (lo < hi && OM.optimalPcmp(pat[lo], mid, freq) < 0) {
                ++lo;
            }
            while (lo < hi && OM.optimalPcmp(pat[hi], mid, freq) > 0) {
                --hi;
            }
            if (lo >= hi) continue;
            Pattern T = pat[lo];
            pat[lo] = pat[hi];
            pat[hi] = T;
        }
        if (hi < lo) {
            int T = hi;
            hi = lo;
            lo = T;
        }
        OM.qsortPtrn(pat, low, lo, freq);
        OM.qsortPtrn(pat, lo == low ? lo + 1 : lo, n, freq);
    }

    private static int optimalPcmp(Pattern pat1, Pattern pat2, int[] freq) {
        int fx = freq[pat1.c] - freq[pat2.c];
        return fx != 0 ? (fx > 0 ? 1 : -1) : pat2.loc - pat1.loc;
    }

    private static int matchShift(char[] x, int ploc, int lshift, Pattern[] pat) {
        while (lshift < x.length) {
            int j;
            int i = ploc;
            while (--i >= 0 && ((j = pat[i].loc - lshift) < 0 || pat[i].c == x[j])) {
            }
            if (i < 0) break;
            ++lshift;
        }
        return lshift;
    }

    private static void preAdaptedGs(char[] x, int[] adaptedGs, Pattern[] pat) {
        int ploc;
        int lshift = 1;
        adaptedGs[0] = 1;
        for (ploc = 1; ploc <= x.length; ++ploc) {
            adaptedGs[ploc] = lshift = OM.matchShift(x, ploc, lshift, pat);
        }
        for (ploc = 0; ploc < x.length; ++ploc) {
            int i;
            lshift = adaptedGs[ploc];
            while (lshift < x.length && (i = pat[ploc].loc - lshift) >= 0 && pat[ploc].c == x[i]) {
                ++lshift;
                lshift = OM.matchShift(x, ploc, lshift, pat);
            }
            adaptedGs[ploc] = lshift;
        }
    }

    private static int[] calculateCharFreq(char[] x, char[] y, int z) {
        int i;
        int[] freq = new int[z];
        for (i = 0; i < x.length; ++i) {
            char c = x[i];
            freq[c] = freq[c] + 1;
        }
        for (i = 0; i < y.length; ++i) {
            char c = y[i];
            freq[c] = freq[c] + 1;
        }
        return freq;
    }

    private static void preQsBc(char[] x, int[] qsBc) {
        int i;
        int m = x.length;
        for (i = 0; i < qsBc.length; ++i) {
            qsBc[i] = m + 1;
        }
        for (i = 0; i < m; ++i) {
            qsBc[x[i]] = m - i;
        }
    }

    public static List<Integer> findAll(String pattern, String source) {
        char[] x = pattern.toCharArray();
        char[] y = source.toCharArray();
        int m = x.length;
        int n = y.length;
        int[] adaptedGs = new int[m + 1];
        int[] qsBc = new int[65536];
        int[] freq = OM.calculateCharFreq(x, y, 65536);
        Pattern[] pat = new Pattern[m];
        ArrayList<Integer> result = new ArrayList<Integer>();
        OM.orderPattern(x, pat, freq);
        OM.preQsBc(x, qsBc);
        OM.preAdaptedGs(x, adaptedGs, pat);
        int j = 0;
        while (j <= n - m) {
            int i;
            for (i = 0; i < m && pat[i].c == y[j + pat[i].loc]; ++i) {
            }
            if (i >= m) {
                result.add(j);
            }
            if (j < n - m) {
                j += Math.max(adaptedGs[i], qsBc[y[j + m]]);
                continue;
            }
            j += adaptedGs[i];
        }
        return result;
    }

    private static class Pattern {
        int loc;
        char c;

        private Pattern() {
        }
    }
}

