/*
 * Decompiled with CFR 0.152.
 */
package org.fedorahosted.tennera.jgettext;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import org.fedorahosted.tennera.jgettext.Catalog;
import org.fedorahosted.tennera.jgettext.Message;
import org.fedorahosted.tennera.jgettext.catalog.parse.ExtendedCatalogParser;
import org.fedorahosted.tennera.jgettext.catalog.parse.MessageStreamParser;
import org.fedorahosted.tennera.jgettext.catalog.parse.ParseException;
import org.fedorahosted.tennera.jgettext.catalog.parse.UnexpectedTokenException;

public class PoParser {
    private Catalog catalog;

    public PoParser() {
        this(new Catalog());
    }

    public PoParser(Catalog catalog) {
        this.catalog = catalog;
    }

    public Catalog parseCatalog(File file) throws FileNotFoundException, IOException, ParseException {
        ExtendedCatalogParser parser = new ExtendedCatalogParser(this.catalog, file);
        return this.parseCatalog(parser);
    }

    public Catalog parseCatalog(Reader reader, boolean isPot) throws ParseException {
        ExtendedCatalogParser parser = new ExtendedCatalogParser(this.catalog, reader, isPot);
        return this.parseCatalog(parser);
    }

    public Catalog parseCatalog(InputStream inputStream, boolean isPot) throws ParseException, IOException {
        ExtendedCatalogParser parser = new ExtendedCatalogParser(this.catalog, inputStream, isPot);
        return this.parseCatalog(parser);
    }

    public Catalog parseCatalog(InputStream inputStream, Charset charset, boolean isPot) throws ParseException {
        ExtendedCatalogParser parser = new ExtendedCatalogParser(this.catalog, inputStream, charset, isPot);
        return this.parseCatalog(parser);
    }

    private Catalog parseCatalog(ExtendedCatalogParser parser) throws ParseException {
        try {
            parser.catalog();
        }
        catch (RecognitionException e) {
            throw new UnexpectedTokenException(e.getMessage(), e.getLine());
        }
        catch (TokenStreamException e) {
            throw new ParseException(e.getMessage(), e, -1);
        }
        return parser.getCatalog();
    }

    public Message parseMessage(File file) throws FileNotFoundException, IOException, ParseException {
        MessageStreamParser parser = new MessageStreamParser(file);
        return this.parseMessage(parser);
    }

    public Message parseMessage(Reader reader) throws ParseException {
        MessageStreamParser parser = new MessageStreamParser(reader);
        return this.parseMessage(parser);
    }

    public Message parseMessage(InputStream inputStream) throws ParseException, IOException {
        MessageStreamParser parser = new MessageStreamParser(inputStream);
        return this.parseMessage(parser);
    }

    public Message parseMessage(InputStream inputStream, Charset charset) throws ParseException {
        MessageStreamParser parser = new MessageStreamParser(inputStream, charset);
        return this.parseMessage(parser);
    }

    private Message parseMessage(MessageStreamParser parser) throws ParseException {
        if (!parser.hasNext()) {
            throw new ParseException("No Message in input", -1);
        }
        Message message = parser.next();
        if (parser.hasNext()) {
            throw new ParseException("Input contains more than a single Message", -1);
        }
        return message;
    }
}

