/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.serialization;

import com.hazelcast.nio.BufferObjectDataInput;
import com.hazelcast.nio.BufferObjectDataOutput;
import com.hazelcast.nio.serialization.ByteArrayObjectDataInput;
import com.hazelcast.nio.serialization.ByteArrayObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.InputOutputFactory;
import com.hazelcast.nio.serialization.SerializationService;
import java.nio.ByteOrder;

final class ByteArrayInputOutputFactory
implements InputOutputFactory {
    private final ByteOrder byteOrder;

    public ByteArrayInputOutputFactory(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
    }

    @Override
    public BufferObjectDataInput createInput(Data data, SerializationService service) {
        return new ByteArrayObjectDataInput(data.toByteArray(), 5, service, this.byteOrder);
    }

    @Override
    public BufferObjectDataInput createInput(byte[] buffer, SerializationService service) {
        return new ByteArrayObjectDataInput(buffer, service, this.byteOrder);
    }

    @Override
    public BufferObjectDataOutput createOutput(int size, SerializationService service) {
        return new ByteArrayObjectDataOutput(size, service, this.byteOrder);
    }

    @Override
    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }
}

