/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vcompact;

import java.awt.geom.Dimension2D;
import java.util.Set;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.creole.CreoleParser;
import net.sourceforge.plantuml.creole.Sheet;
import net.sourceforge.plantuml.creole.SheetBlock1;
import net.sourceforge.plantuml.creole.SheetBlock2;
import net.sourceforge.plantuml.creole.Stencil;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.sequencediagram.NotePosition;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FtileWithNote
extends AbstractFtile
implements Stencil {
    private final Ftile tile;
    private final TextBlock text;
    private final NotePosition notePosition;
    private final double suppSpace = 20.0;
    private final int FOO = 6;

    @Override
    public Set<Swimlane> getSwimlanes() {
        return this.tile.getSwimlanes();
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.tile.getSwimlaneIn();
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.tile.getSwimlaneOut();
    }

    public FtileWithNote(Ftile ftile, Display display, NotePosition notePosition, ISkinParam iSkinParam) {
        super(ftile.shadowing());
        this.tile = ftile;
        this.notePosition = notePosition;
        Rose rose = new Rose();
        HtmlColor htmlColor = rose.getFontColor(iSkinParam, FontParam.NOTE);
        UFont uFont = iSkinParam.getFont(FontParam.NOTE, null);
        HtmlColor htmlColor2 = rose.getHtmlColor(iSkinParam, ColorParam.noteBackground);
        HtmlColor htmlColor3 = rose.getHtmlColor(iSkinParam, ColorParam.noteBorder);
        FontConfiguration fontConfiguration = new FontConfiguration(uFont, htmlColor);
        Sheet sheet = new CreoleParser(fontConfiguration, HorizontalAlignment.LEFT, iSkinParam).createSheet(display);
        this.text = new SheetBlock2(new SheetBlock1(sheet, 0.0), this, new UStroke(1.0));
    }

    private UTranslate getTranslate(StringBounder stringBounder) {
        Dimension2D dimension2D = this.calculateDimensionInternal(stringBounder);
        Dimension2D dimension2D2 = this.text.calculateDimension(stringBounder);
        FtileGeometry ftileGeometry = this.tile.calculateDimension(stringBounder);
        double d = (dimension2D.getHeight() - ((Dimension2D)ftileGeometry).getHeight()) / 2.0;
        double d2 = this.notePosition == NotePosition.LEFT ? dimension2D2.getWidth() + 20.0 : 0.0;
        return new UTranslate(d2, d);
    }

    private UTranslate getTranslateForOpale(UGraphic uGraphic) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        FtileGeometry ftileGeometry = this.calculateDimension(stringBounder);
        Dimension2D dimension2D = this.text.calculateDimension(stringBounder);
        double d = (((Dimension2D)ftileGeometry).getHeight() - dimension2D.getHeight()) / 2.0;
        if (this.notePosition == NotePosition.LEFT) {
            return new UTranslate(0.0, d);
        }
        double d2 = ((Dimension2D)ftileGeometry).getWidth() - dimension2D.getWidth();
        return new UTranslate(d2, d);
    }

    @Override
    public void drawU(UGraphic uGraphic) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        Dimension2D dimension2D = this.text.calculateDimension(stringBounder);
        this.text.drawU(uGraphic.apply(this.getTranslateForOpale(uGraphic)));
        uGraphic.apply(this.getTranslate(stringBounder)).draw(this.tile);
    }

    @Override
    public FtileGeometry calculateDimension(StringBounder stringBounder) {
        Dimension2D dimension2D = this.calculateDimensionInternal(stringBounder);
        FtileGeometry ftileGeometry = this.tile.calculateDimension(stringBounder);
        UTranslate uTranslate = this.getTranslate(stringBounder);
        if (ftileGeometry.hasPointOut()) {
            return new FtileGeometry(dimension2D, ftileGeometry.getLeft() + uTranslate.getDx(), ftileGeometry.getInY() + uTranslate.getDy(), ftileGeometry.getOutY() + uTranslate.getDy());
        }
        return new FtileGeometry(dimension2D, ftileGeometry.getLeft() + uTranslate.getDx(), ftileGeometry.getInY() + uTranslate.getDy());
    }

    private Dimension2D calculateDimensionInternal(StringBounder stringBounder) {
        Dimension2D dimension2D = this.text.calculateDimension(stringBounder);
        FtileGeometry ftileGeometry = this.tile.calculateDimension(stringBounder);
        double d = Math.max(dimension2D.getHeight(), ((Dimension2D)ftileGeometry).getHeight());
        return new Dimension2DDouble(((Dimension2D)ftileGeometry).getWidth() + 1.0 * dimension2D.getWidth() + 20.0, d);
    }

    @Override
    public double getStartingX(StringBounder stringBounder, double d) {
        return -6.0;
    }

    @Override
    public boolean isKilled() {
        return this.tile.isKilled();
    }

    @Override
    public double getEndingX(StringBounder stringBounder, double d) {
        return this.text.calculateDimension(stringBounder).getWidth() - 6.0;
    }
}

