/*
 * Decompiled with CFR 0.152.
 */
package org.htmlcleaner;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.htmlcleaner.CleanerTransformations;
import org.htmlcleaner.Html4TagProvider;
import org.htmlcleaner.Html5TagProvider;
import org.htmlcleaner.HtmlCleaner;
import org.htmlcleaner.ITagInfoProvider;
import org.htmlcleaner.OptionalOutput;
import org.htmlcleaner.TagNode;
import org.htmlcleaner.audit.ErrorType;
import org.htmlcleaner.audit.HtmlModificationListener;
import org.htmlcleaner.conditional.ITagNodeCondition;
import org.htmlcleaner.conditional.TagNodeAutoGeneratedCondition;
import org.htmlcleaner.conditional.TagNodeNameCondition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CleanerProperties
implements HtmlModificationListener {
    public static final String DEFAULT_CHARSET = "UTF-8";
    public static final String BOOL_ATT_SELF = "self";
    public static final String BOOL_ATT_EMPTY = "empty";
    public static final String BOOL_ATT_TRUE = "true";
    private ITagInfoProvider tagInfoProvider;
    private boolean advancedXmlEscape;
    private boolean useCdataForScriptAndStyle;
    private boolean translateSpecialEntities;
    private boolean recognizeUnicodeChars;
    private boolean omitUnknownTags;
    private boolean treatUnknownTagsAsContent;
    private boolean omitDeprecatedTags;
    private boolean omitComments;
    private boolean treatDeprecatedTagsAsContent;
    private OptionalOutput omitXmlDeclaration;
    private OptionalOutput omitDoctypeDeclaration;
    private OptionalOutput omitHtmlEnvelope;
    private boolean useEmptyElementTags;
    private boolean allowMultiWordAttributes;
    private String booleanAttributeValues;
    private boolean ignoreQuestAndExclam;
    private boolean allowHtmlInsideAttributes;
    private boolean namespacesAware;
    private boolean transSpecialEntitiesToNCR;
    private boolean omitCdataOutsideScriptAndStyle;
    private boolean deserializeEntities;
    private boolean trimAttributeValues;
    private int htmlVersion;
    private boolean addNewlineToHeadAndBody;
    private boolean keepWhitespaceAndCommentsInHead;
    private String hyphenReplacementInComment;
    private String pruneTags;
    private String allowTags;
    private CleanerTransformations cleanerTransformations = new CleanerTransformations();
    private List<HtmlModificationListener> htmlModificationListeners;
    private Set<ITagNodeCondition> pruneTagSet = new HashSet<ITagNodeCondition>();
    private Set<ITagNodeCondition> allowTagSet = new HashSet<ITagNodeCondition>();
    private String charset = "UTF-8";
    private boolean transResCharsToNCR;

    public CleanerProperties() {
        this.reset();
    }

    public CleanerProperties(ITagInfoProvider tagInfoProvider) {
        this.reset();
        this.tagInfoProvider = tagInfoProvider;
    }

    void setTagInfoProvider(ITagInfoProvider tagInfoProvider) {
        this.tagInfoProvider = tagInfoProvider;
    }

    public ITagInfoProvider getTagInfoProvider() {
        return this.tagInfoProvider;
    }

    public boolean isAdvancedXmlEscape() {
        return this.advancedXmlEscape;
    }

    public void setAdvancedXmlEscape(boolean advancedXmlEscape) {
        this.advancedXmlEscape = advancedXmlEscape;
    }

    public boolean isTransResCharsToNCR() {
        return this.transResCharsToNCR;
    }

    public void setTransResCharsToNCR(boolean transResCharsToNCR) {
        this.transResCharsToNCR = transResCharsToNCR;
    }

    public boolean isUseCdataForScriptAndStyle() {
        return this.useCdataForScriptAndStyle;
    }

    public void setUseCdataForScriptAndStyle(boolean useCdataForScriptAndStyle) {
        this.useCdataForScriptAndStyle = useCdataForScriptAndStyle;
    }

    public boolean isTranslateSpecialEntities() {
        return this.translateSpecialEntities;
    }

    public void setTranslateSpecialEntities(boolean translateSpecialEntities) {
        this.translateSpecialEntities = translateSpecialEntities;
    }

    public boolean isRecognizeUnicodeChars() {
        return this.recognizeUnicodeChars;
    }

    public void setRecognizeUnicodeChars(boolean recognizeUnicodeChars) {
        this.recognizeUnicodeChars = recognizeUnicodeChars;
    }

    public boolean isOmitUnknownTags() {
        return this.omitUnknownTags;
    }

    public void setOmitUnknownTags(boolean omitUnknownTags) {
        this.omitUnknownTags = omitUnknownTags;
    }

    public boolean isTreatUnknownTagsAsContent() {
        return this.treatUnknownTagsAsContent;
    }

    public void setTreatUnknownTagsAsContent(boolean treatUnknownTagsAsContent) {
        this.treatUnknownTagsAsContent = treatUnknownTagsAsContent;
    }

    public boolean isOmitDeprecatedTags() {
        return this.omitDeprecatedTags;
    }

    public void setOmitDeprecatedTags(boolean omitDeprecatedTags) {
        this.omitDeprecatedTags = omitDeprecatedTags;
    }

    public boolean isTreatDeprecatedTagsAsContent() {
        return this.treatDeprecatedTagsAsContent;
    }

    public void setTreatDeprecatedTagsAsContent(boolean treatDeprecatedTagsAsContent) {
        this.treatDeprecatedTagsAsContent = treatDeprecatedTagsAsContent;
    }

    public boolean isOmitComments() {
        return this.omitComments;
    }

    public void setOmitComments(boolean omitComments) {
        this.omitComments = omitComments;
    }

    public boolean isOmitXmlDeclaration() {
        return this.omitXmlDeclaration == OptionalOutput.omit;
    }

    public void setOmitXmlDeclaration(boolean omitXmlDeclaration) {
        this.omitXmlDeclaration = omitXmlDeclaration ? OptionalOutput.omit : OptionalOutput.alwaysOutput;
    }

    public boolean isOmitDoctypeDeclaration() {
        return this.omitDoctypeDeclaration == OptionalOutput.omit || this.isOmitHtmlEnvelope();
    }

    public void setOmitDoctypeDeclaration(boolean omitDoctypeDeclaration) {
        this.omitDoctypeDeclaration = omitDoctypeDeclaration ? OptionalOutput.omit : OptionalOutput.alwaysOutput;
    }

    public boolean isOmitHtmlEnvelope() {
        return this.omitHtmlEnvelope == OptionalOutput.omit;
    }

    public void setOmitHtmlEnvelope(boolean omitHtmlEnvelope) {
        this.omitHtmlEnvelope = omitHtmlEnvelope ? OptionalOutput.omit : OptionalOutput.alwaysOutput;
    }

    public boolean isUseEmptyElementTags() {
        return this.useEmptyElementTags;
    }

    public void setUseEmptyElementTags(boolean useEmptyElementTags) {
        this.useEmptyElementTags = useEmptyElementTags;
    }

    public boolean isAllowMultiWordAttributes() {
        return this.allowMultiWordAttributes;
    }

    public void setAllowMultiWordAttributes(boolean allowMultiWordAttributes) {
        this.allowMultiWordAttributes = allowMultiWordAttributes;
    }

    public boolean isAllowHtmlInsideAttributes() {
        return this.allowHtmlInsideAttributes;
    }

    public void setAllowHtmlInsideAttributes(boolean allowHtmlInsideAttributes) {
        this.allowHtmlInsideAttributes = allowHtmlInsideAttributes;
    }

    public boolean isIgnoreQuestAndExclam() {
        return this.ignoreQuestAndExclam;
    }

    public void setIgnoreQuestAndExclam(boolean ignoreQuestAndExclam) {
        this.ignoreQuestAndExclam = ignoreQuestAndExclam;
    }

    public boolean isNamespacesAware() {
        return this.namespacesAware;
    }

    public void setNamespacesAware(boolean namespacesAware) {
        this.namespacesAware = namespacesAware;
    }

    public boolean isAddNewlineToHeadAndBody() {
        return this.addNewlineToHeadAndBody;
    }

    public void setAddNewlineToHeadAndBody(boolean addNewlineToHeadAndBody) {
        this.addNewlineToHeadAndBody = addNewlineToHeadAndBody;
    }

    public boolean isKeepWhitespaceAndCommentsInHead() {
        return this.keepWhitespaceAndCommentsInHead;
    }

    public void setKeepWhitespaceAndCommentsInHead(boolean keepHeadWhitespace) {
        this.keepWhitespaceAndCommentsInHead = keepHeadWhitespace;
    }

    public String getHyphenReplacementInComment() {
        return this.hyphenReplacementInComment;
    }

    public void setHyphenReplacementInComment(String hyphenReplacementInComment) {
        this.hyphenReplacementInComment = hyphenReplacementInComment;
    }

    public String getPruneTags() {
        return this.pruneTags;
    }

    public boolean isOmitCdataOutsideScriptAndStyle() {
        return this.omitCdataOutsideScriptAndStyle;
    }

    public void setOmitCdataOutsideScriptAndStyle(boolean value) {
        this.omitCdataOutsideScriptAndStyle = value;
    }

    public boolean isDeserializeEntities() {
        return this.deserializeEntities;
    }

    public void setDeserializeEntities(boolean deserializeEntities) {
        this.deserializeEntities = deserializeEntities;
    }

    public void setHtmlVersion(int version) {
        this.htmlVersion = version;
        if (version == 4) {
            this.setTagInfoProvider(Html4TagProvider.INSTANCE);
        } else {
            this.setTagInfoProvider(Html5TagProvider.INSTANCE);
        }
    }

    public int getHtmlVersion() {
        return this.htmlVersion;
    }

    public boolean isTrimAttributeValues() {
        return this.trimAttributeValues;
    }

    public void setTrimAttributeValues(boolean trimAttributeValues) {
        this.trimAttributeValues = trimAttributeValues;
    }

    public void setPruneTags(String pruneTags) {
        this.pruneTags = pruneTags;
        this.resetPruneTagSet();
        this.addTagNameConditions(this.pruneTagSet, pruneTags);
    }

    public void addPruneTagNodeCondition(ITagNodeCondition condition) {
        this.pruneTagSet.add(condition);
    }

    public Set<ITagNodeCondition> getPruneTagSet() {
        return this.pruneTagSet;
    }

    public String getAllowTags() {
        return this.allowTags;
    }

    public void setAllowTags(String allowTags) {
        this.allowTags = allowTags;
        this.setAllowTagSet(allowTags);
    }

    private void setAllowTagSet(String allowTags) {
        this.allowTagSet.clear();
        this.addTagNameConditions(this.allowTagSet, allowTags);
    }

    public boolean isTransSpecialEntitiesToNCR() {
        return this.transSpecialEntitiesToNCR;
    }

    public void setTransSpecialEntitiesToNCR(boolean transSpecialEntitiesToNCR) {
        this.transSpecialEntitiesToNCR = transSpecialEntitiesToNCR;
    }

    private void addTagNameConditions(Set<ITagNodeCondition> tagSet, String tagsNameStr) {
        if (tagsNameStr != null) {
            StringTokenizer tokenizer = new StringTokenizer(tagsNameStr, ",");
            while (tokenizer.hasMoreTokens()) {
                tagSet.add(new TagNodeNameCondition(tokenizer.nextToken().trim().toLowerCase()));
            }
        }
    }

    public Set<ITagNodeCondition> getAllowTagSet() {
        return this.allowTagSet;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public String getCharset() {
        return this.charset;
    }

    public String getBooleanAttributeValues() {
        return this.booleanAttributeValues;
    }

    public void setBooleanAttributeValues(String booleanAttributeValues) {
        this.booleanAttributeValues = BOOL_ATT_SELF.equalsIgnoreCase(booleanAttributeValues) || BOOL_ATT_EMPTY.equalsIgnoreCase(booleanAttributeValues) || BOOL_ATT_TRUE.equalsIgnoreCase(booleanAttributeValues) ? booleanAttributeValues.toLowerCase() : BOOL_ATT_SELF;
    }

    public void reset() {
        this.advancedXmlEscape = true;
        this.useCdataForScriptAndStyle = true;
        this.translateSpecialEntities = true;
        this.recognizeUnicodeChars = true;
        this.omitUnknownTags = false;
        this.treatUnknownTagsAsContent = false;
        this.omitDeprecatedTags = false;
        this.treatDeprecatedTagsAsContent = false;
        this.omitComments = false;
        this.omitXmlDeclaration = OptionalOutput.alwaysOutput;
        this.omitDoctypeDeclaration = OptionalOutput.alwaysOutput;
        this.omitHtmlEnvelope = OptionalOutput.alwaysOutput;
        this.useEmptyElementTags = true;
        this.allowMultiWordAttributes = true;
        this.allowHtmlInsideAttributes = false;
        this.ignoreQuestAndExclam = true;
        this.namespacesAware = true;
        this.addNewlineToHeadAndBody = true;
        this.keepWhitespaceAndCommentsInHead = true;
        this.hyphenReplacementInComment = "=";
        this.setPruneTags(null);
        this.setAllowTags(null);
        this.booleanAttributeValues = BOOL_ATT_SELF;
        this.charset = DEFAULT_CHARSET;
        this.cleanerTransformations.clear();
        this.resetPruneTagSet();
        this.tagInfoProvider = this.getHtmlVersion() == HtmlCleaner.HTML_4 ? Html4TagProvider.INSTANCE : Html5TagProvider.INSTANCE;
        this.htmlModificationListeners = new ArrayList<HtmlModificationListener>();
        this.omitCdataOutsideScriptAndStyle = false;
        this.trimAttributeValues = true;
    }

    private void resetPruneTagSet() {
        this.pruneTagSet.clear();
        this.pruneTagSet.add(TagNodeAutoGeneratedCondition.INSTANCE);
    }

    public CleanerTransformations getCleanerTransformations() {
        return this.cleanerTransformations;
    }

    public void setCleanerTransformations(CleanerTransformations cleanerTransformations) {
        if (cleanerTransformations == null) {
            this.cleanerTransformations.clear();
        } else {
            this.cleanerTransformations = cleanerTransformations;
        }
    }

    public void addHtmlModificationListener(HtmlModificationListener listener) {
        this.htmlModificationListeners.add(listener);
    }

    @Override
    public void fireConditionModification(ITagNodeCondition condition, TagNode tagNode) {
        for (HtmlModificationListener listener : this.htmlModificationListeners) {
            listener.fireConditionModification(condition, tagNode);
        }
    }

    @Override
    public void fireHtmlError(boolean certainty, TagNode startTagToken, ErrorType type) {
        for (HtmlModificationListener listener : this.htmlModificationListeners) {
            listener.fireHtmlError(certainty, startTagToken, type);
        }
    }

    @Override
    public void fireUglyHtml(boolean certainty, TagNode startTagToken, ErrorType errorType) {
        for (HtmlModificationListener listener : this.htmlModificationListeners) {
            listener.fireUglyHtml(certainty, startTagToken, errorType);
        }
    }

    @Override
    public void fireUserDefinedModification(boolean certainty, TagNode tagNode, ErrorType errorType) {
        for (HtmlModificationListener listener : this.htmlModificationListeners) {
            listener.fireUserDefinedModification(certainty, tagNode, errorType);
        }
    }
}

