/*
 * Decompiled with CFR 0.152.
 */
package org.jdom2.contrib.android;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TranslateTests {
    private static final String[] skipclasses = new String[]{".*StAX.*"};
    private static final String[] skipmethods = new String[]{".*HighSurrogateAttPair.*", "bulkIntern", "testBuildString"};
    private static final Pattern pat = Pattern.compile("^(.+/(\\w+))\\.class$");
    private final Class<?> tclass;
    private final File outf;

    private static String potentialTest(String zename) {
        String cname;
        Matcher mat = pat.matcher(zename);
        if (mat.matches() && ((cname = mat.group(2)).startsWith("Test") || cname.endsWith("Test"))) {
            for (String cm : skipclasses) {
                if (!Pattern.matches(cm, cname)) continue;
                return null;
            }
            String cp = mat.group(1);
            return cp.replace('/', '.');
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        if (args.length != 2) {
            throw new IllegalArgumentException("Usage: Jar SrcOutDir");
        }
        String jarname = args[0];
        File srcoutdir = new File(args[1]);
        if (!srcoutdir.exists()) {
            srcoutdir.mkdirs();
        }
        if (!srcoutdir.isDirectory()) {
            throw new IllegalArgumentException("Could not create/use SrcOutput directory: " + srcoutdir);
        }
        ArrayList<String> classes = new ArrayList<String>();
        ZipFile zfile = new ZipFile(jarname);
        try {
            Enumeration<? extends ZipEntry> e = zfile.entries();
            while (e.hasMoreElements()) {
                String classname;
                String zename;
                ZipEntry ze = e.nextElement();
                if (ze.isDirectory() || !(zename = ze.getName()).endsWith(".class") || (classname = TranslateTests.potentialTest(zename)) == null) continue;
                TranslateTests tt = new TranslateTests(srcoutdir, classname);
                classes.add(tt.translate());
            }
        }
        finally {
            zfile.close();
        }
    }

    public TranslateTests(File outdir, String zename) {
        System.out.println("Contemplating " + zename);
        try {
            this.tclass = Class.forName(zename);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to load class " + zename, e);
        }
        String path = zename.replace('.', '/') + "TT.java";
        this.outf = new File(outdir, path);
    }

    private String translate() throws IOException {
        String sname = this.tclass.getSimpleName();
        StringBuilder sb = new StringBuilder();
        String ret = this.tclass.getPackage().getName() + "." + sname + "TT";
        sb.append("package ").append(this.tclass.getPackage().getName()).append(";\n");
        sb.append("@SuppressWarnings(\"javadoc\")\n");
        sb.append("public class ").append(sname).append("TT extends android.test.AndroidTestCase {\n");
        if (this.tclass.getAnnotation(Ignore.class) != null) {
            sb.append("\n\n    // Class has @Ignore set\n\n");
        } else {
            Method[] methods = this.tclass.getMethods();
            ArrayList<Method> pretest = new ArrayList<Method>();
            ArrayList<Method> posttest = new ArrayList<Method>();
            TreeSet<String> excepts = new TreeSet<String>();
            for (Method m : methods) {
                if (m.getAnnotation(Before.class) != null) {
                    pretest.add(m);
                    excepts.addAll(this.getExceptions(m));
                }
                if (m.getAnnotation(After.class) == null) continue;
                posttest.add(m);
                excepts.addAll(this.getExceptions(m));
            }
            sb.append("  private final ").append(sname).append(" test = new ").append(sname).append("();\n");
            sb.append("\n  @Override\n");
            sb.append("  public void setUp() throws Exception {\n");
            sb.append("    super.setUp();\n");
            sb.append("    // tests run when class starts...\n");
            sb.append("    org.jdom2.test.util.UnitTestUtil.setAndroid();\n");
            sb.append("    System.setProperty(\"javax.xml.validation.SchemaFactory:http://www.w3.org/2001/XMLSchema\",\n");
            sb.append("        \"org.apache.xerces.jaxp.validation.XMLSchemaFactory\");\n");
            for (Method m : methods) {
                if (m.getAnnotation(BeforeClass.class) == null) continue;
                sb.append("    test.").append(m.getName()).append("();\n");
            }
            sb.append("  }\n");
            sb.append("\n  @Override\n");
            sb.append("  public void tearDown() throws Exception {\n");
            sb.append("    super.tearDown();\n");
            sb.append("    // tests run when class completes...\n");
            for (Method m : methods) {
                if (m.getAnnotation(AfterClass.class) == null) continue;
                sb.append("    test.").append(m.getName()).append("();\n");
            }
            sb.append("  }\n");
            for (Method m : methods) {
                Test tanno = null;
                tanno = m.getAnnotation(Test.class);
                if (tanno == null || m.getAnnotation(Ignore.class) != null) continue;
                String tname = this.getTestName(m);
                sb.append("\n");
                sb.append("  public void ").append(tname).append("()").append(this.buildThrows(excepts, m)).append("{\n");
                for (Method pre : pretest) {
                    sb.append("    // pre test\n");
                    sb.append("    test.").append(pre.getName()).append("();\n");
                }
                if (posttest.isEmpty()) {
                    sb.append("    // actual test\n");
                    if (tanno.expected() == Test.None.class) {
                        sb.append("    test.").append(m.getName()).append("();\n");
                    } else {
                        sb.append("    try {\n");
                        sb.append("      test.").append(m.getName()).append("();\n");
                        sb.append("        org.jdom2.test.util.UnitTestUtil.failNoException(").append(tanno.expected().getName()).append(".class);\n");
                        sb.append("    } catch (").append(tanno.expected().getName()).append(" e) {\n");
                        sb.append("        org.jdom2.test.util.UnitTestUtil.checkException(").append(tanno.expected().getName()).append(".class, e);\n");
                        sb.append("    }\n");
                    }
                } else {
                    sb.append("    try {\n");
                    sb.append("      // actual test\n");
                    if (tanno.expected() == Test.None.class) {
                        sb.append("      test.").append(m.getName()).append("();\n");
                    } else {
                        sb.append("      try {\n");
                        sb.append("        test.").append(m.getName()).append("();\n");
                        sb.append("        org.jdom2.test.util.UnitTestUtil.failNoException(").append(tanno.expected().getName()).append(".class);\n");
                        sb.append("      } catch (Exception e) {\n");
                        sb.append("        org.jdom2.test.util.UnitTestUtil.checkException(").append(tanno.expected().getName()).append(".class, e);\n");
                        sb.append("      }\n");
                    }
                    sb.append("    } finally {\n");
                    for (Method post : posttest) {
                        sb.append("    // post test\n");
                        sb.append("    test.").append(post.getName()).append("();\n");
                    }
                    sb.append("    }\n");
                }
                sb.append("  }\n");
            }
        }
        sb.append("\n}\n");
        File outd = this.outf.getParentFile().getAbsoluteFile();
        if (!outd.isDirectory()) {
            outd.mkdirs();
        }
        FileWriter fw = new FileWriter(this.outf);
        fw.write(sb.toString());
        fw.flush();
        fw.close();
        return ret;
    }

    private String getTestName(Method m) {
        String mname = m.getName();
        for (String mm : skipmethods) {
            if (!Pattern.matches(mm, mname)) continue;
            return "/* Skip test on Android */ do_not_" + mname;
        }
        return mname.startsWith("test") ? mname : "test_" + mname;
    }

    private Set<String> getExceptions(Method m) {
        TreeSet<String> hs = new TreeSet<String>();
        if (m != null) {
            for (Class<?> ec : m.getExceptionTypes()) {
                hs.add(ec.getName());
            }
        }
        return hs;
    }

    private String buildThrows(Set<String> current, Method m) {
        Iterator<String> it;
        Set<String> tothrow = this.getExceptions(m);
        if (current != null) {
            tothrow.addAll(current);
        }
        if (!(it = tothrow.iterator()).hasNext()) {
            return " ";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(" throws ").append(it.next());
        while (it.hasNext()) {
            sb.append(", ").append(it.next());
        }
        sb.append(" ");
        return sb.toString();
    }
}

