/*
 * Decompiled with CFR 0.152.
 */
package org.jdom2.contrib.ids;

import java.util.HashMap;
import java.util.Map;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.Parent;
import org.jdom2.contrib.ids.IdDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdElement
extends Element {
    private static final long serialVersionUID = 1L;

    public IdElement(String name, Namespace namespace) {
        super(name, namespace);
    }

    public IdElement(String name) {
        this(name, (Namespace)null);
    }

    public IdElement(String name, String uri) {
        this(name, Namespace.getNamespace((String)"", (String)uri));
    }

    public IdElement(String name, String prefix, String uri) {
        this(name, Namespace.getNamespace((String)prefix, (String)uri));
    }

    protected Content setParent(Parent parent) {
        Document prevDoc = this.getDocument();
        Document newDoc = parent != null ? parent.getDocument() : null;
        super.setParent(parent);
        if (newDoc != prevDoc) {
            this.transferIds(prevDoc, newDoc);
        }
        return this;
    }

    private void transferIds(Document prevDoc, Document newDoc) {
        if (prevDoc instanceof IdDocument || newDoc instanceof IdDocument) {
            IdDocument idDoc;
            Map<String, Element> ids = IdElement.getIds(this, new HashMap<String, Element>());
            if (prevDoc instanceof IdDocument) {
                idDoc = (IdDocument)prevDoc;
                for (String string : ids.keySet()) {
                    idDoc.removeId(string);
                }
            }
            if (newDoc instanceof IdDocument) {
                idDoc = (IdDocument)newDoc;
                for (Map.Entry entry : ids.entrySet()) {
                    idDoc.addId((String)entry.getKey(), (Element)entry.getValue());
                }
            }
        }
    }

    private static Map<String, Element> getIds(Element root, Map<String, Element> ids) {
        IdElement.addIdAttributes(root, ids);
        for (Element emt : root.getChildren()) {
            IdElement.getIds(emt, ids);
        }
        return ids;
    }

    private static void addIdAttributes(Element elt, Map<String, Element> ids) {
        for (Attribute attr : elt.getAttributes()) {
            if (attr.getAttributeType() != Attribute.ID_TYPE) continue;
            ids.put(attr.getValue(), elt);
            break;
        }
    }
}

