/*
 * Decompiled with CFR 0.152.
 */
package de.rtner.security.auth.spi;

import de.rtner.security.auth.spi.PRF;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class MacBasedPRF
implements PRF {
    protected Mac mac;
    protected int hLen;
    protected String macAlgorithm;

    public MacBasedPRF(String string) {
        this.macAlgorithm = string;
        try {
            this.mac = Mac.getInstance(string);
            this.hLen = this.mac.getMacLength();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(noSuchAlgorithmException);
        }
    }

    public MacBasedPRF(String string, String string2) {
        this.macAlgorithm = string;
        try {
            this.mac = Mac.getInstance(string, string2);
            this.hLen = this.mac.getMacLength();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(noSuchAlgorithmException);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new RuntimeException(noSuchProviderException);
        }
    }

    public byte[] doFinal(byte[] byArray) {
        byte[] byArray2 = this.mac.doFinal(byArray);
        return byArray2;
    }

    public int getHLen() {
        return this.hLen;
    }

    public void init(byte[] byArray) {
        try {
            this.mac.init(new SecretKeySpec(byArray, this.macAlgorithm));
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new RuntimeException(invalidKeyException);
        }
    }
}

