/*
 * Decompiled with CFR 0.152.
 */
package de.rtner.security.auth.spi;

import de.rtner.security.auth.spi.MacBasedPRF;
import de.rtner.security.auth.spi.PBKDF2;
import de.rtner.security.auth.spi.PBKDF2HexFormatter;
import de.rtner.security.auth.spi.PBKDF2Parameters;
import de.rtner.security.auth.spi.PRF;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;

public class PBKDF2Engine
implements PBKDF2 {
    protected PBKDF2Parameters parameters;
    protected PRF prf;

    public PBKDF2Engine() {
        this.parameters = null;
        this.prf = null;
    }

    public PBKDF2Engine(PBKDF2Parameters pBKDF2Parameters) {
        this.parameters = pBKDF2Parameters;
        this.prf = null;
    }

    public PBKDF2Engine(PBKDF2Parameters pBKDF2Parameters, PRF pRF) {
        this.parameters = pBKDF2Parameters;
        this.prf = pRF;
    }

    public byte[] deriveKey(String string) {
        return this.deriveKey(string, 0);
    }

    public byte[] deriveKey(String string, int n) {
        byte[] byArray = null;
        byte[] byArray2 = null;
        String string2 = this.parameters.getHashCharset();
        if (string == null) {
            string = "";
        }
        try {
            byArray2 = string2 == null ? string.getBytes() : string.getBytes(string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        this.assertPRF(byArray2);
        if (n == 0) {
            n = this.prf.getHLen();
        }
        byArray = this.PBKDF2(this.prf, this.parameters.getSalt(), this.parameters.getIterationCount(), n);
        return byArray;
    }

    public boolean verifyKey(String string) {
        byte[] byArray = this.getParameters().getDerivedKey();
        if (byArray == null || byArray.length == 0) {
            return false;
        }
        byte[] byArray2 = this.deriveKey(string, byArray.length);
        if (byArray2 == null || byArray2.length != byArray.length) {
            return false;
        }
        for (int i = 0; i < byArray2.length; ++i) {
            if (byArray2[i] == byArray[i]) continue;
            return false;
        }
        return true;
    }

    protected void assertPRF(byte[] byArray) {
        if (this.prf == null) {
            this.prf = new MacBasedPRF(this.parameters.getHashAlgorithm());
        }
        this.prf.init(byArray);
    }

    public PRF getPseudoRandomFunction() {
        return this.prf;
    }

    protected byte[] PBKDF2(PRF pRF, byte[] byArray, int n, int n2) {
        if (byArray == null) {
            byArray = new byte[]{};
        }
        int n3 = pRF.getHLen();
        int n4 = this.ceil(n2, n3);
        int n5 = n2 - (n4 - 1) * n3;
        byte[] byArray2 = new byte[n4 * n3];
        int n6 = 0;
        for (int i = 1; i <= n4; ++i) {
            this._F(byArray2, n6, pRF, byArray, n, i);
            n6 += n3;
        }
        if (n5 < n3) {
            byte[] byArray3 = new byte[n2];
            System.arraycopy(byArray2, 0, byArray3, 0, n2);
            return byArray3;
        }
        return byArray2;
    }

    protected int ceil(int n, int n2) {
        int n3 = 0;
        if (n % n2 > 0) {
            n3 = 1;
        }
        return n / n2 + n3;
    }

    protected void _F(byte[] byArray, int n, PRF pRF, byte[] byArray2, int n2, int n3) {
        int n4 = pRF.getHLen();
        byte[] byArray3 = new byte[n4];
        byte[] byArray4 = new byte[byArray2.length + 4];
        System.arraycopy(byArray2, 0, byArray4, 0, byArray2.length);
        this.INT(byArray4, byArray2.length, n3);
        for (int i = 0; i < n2; ++i) {
            byArray4 = pRF.doFinal(byArray4);
            this.xor(byArray3, byArray4);
        }
        System.arraycopy(byArray3, 0, byArray, n, n4);
    }

    protected void xor(byte[] byArray, byte[] byArray2) {
        for (int i = 0; i < byArray.length; ++i) {
            int n = i;
            byArray[n] = (byte)(byArray[n] ^ byArray2[i]);
        }
    }

    protected void INT(byte[] byArray, int n, int n2) {
        byArray[n + 0] = (byte)(n2 / 0x1000000);
        byArray[n + 1] = (byte)(n2 / 65536);
        byArray[n + 2] = (byte)(n2 / 256);
        byArray[n + 3] = (byte)n2;
    }

    public PBKDF2Parameters getParameters() {
        return this.parameters;
    }

    public void setParameters(PBKDF2Parameters pBKDF2Parameters) {
        this.parameters = pBKDF2Parameters;
    }

    public void setPseudoRandomFunction(PRF pRF) {
        this.prf = pRF;
    }

    public static void main(String[] stringArray) throws IOException, NoSuchAlgorithmException {
        String string = "password";
        String string2 = null;
        PBKDF2HexFormatter pBKDF2HexFormatter = new PBKDF2HexFormatter();
        if (stringArray.length >= 1) {
            string = stringArray[0];
        }
        if (stringArray.length >= 2) {
            string2 = stringArray[1];
        }
        if (string2 == null) {
            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
            byte[] byArray = new byte[8];
            secureRandom.nextBytes(byArray);
            int n = 1000;
            PBKDF2Parameters pBKDF2Parameters = new PBKDF2Parameters("HmacSHA1", "ISO-8859-1", byArray, n);
            PBKDF2Engine pBKDF2Engine = new PBKDF2Engine(pBKDF2Parameters);
            pBKDF2Parameters.setDerivedKey(pBKDF2Engine.deriveKey(string));
            string2 = pBKDF2HexFormatter.toString(pBKDF2Parameters);
            System.out.println(string2);
        } else {
            PBKDF2Parameters pBKDF2Parameters = new PBKDF2Parameters();
            pBKDF2Parameters.setHashAlgorithm("HmacSHA1");
            pBKDF2Parameters.setHashCharset("ISO-8859-1");
            if (pBKDF2HexFormatter.fromString(pBKDF2Parameters, string2)) {
                throw new IllegalArgumentException("Candidate data does not have correct format (\"" + string2 + "\")");
            }
            PBKDF2Engine pBKDF2Engine = new PBKDF2Engine(pBKDF2Parameters);
            boolean bl = pBKDF2Engine.verifyKey(string);
            System.out.println(bl ? "OK" : "FAIL");
            System.exit(bl ? 0 : 1);
        }
    }
}

