/*
 * Decompiled with CFR 0.152.
 */
package javapns.communication;

import javapns.communication.AppleServer;
import sun.misc.BASE64Encoder;

public class ProxyManager {
    private static final String LOCAL_PROXY_HOST_PROPERTY = "javapns.communication.proxyHost";
    private static final String LOCAL_PROXY_PORT_PROPERTY = "javapns.communication.proxyPort";
    private static final String LOCAL_PROXY_AUTHORIZATION_PROPERTY = "javapns.communication.proxyAuthorization";
    private static final String JVM_PROXY_HOST_PROPERTY = "https.proxyHost";
    private static final String JVM_PROXY_PORT_PROPERTY = "https.proxyPort";
    private static final String JVM_PROXY_AUTHORIZATION_PROPERTY = "https.proxyAuthorization";

    private ProxyManager() {
    }

    public static void setProxy(String host, String port) {
        System.setProperty(LOCAL_PROXY_HOST_PROPERTY, host);
        System.setProperty(LOCAL_PROXY_PORT_PROPERTY, port);
    }

    public static void setProxyBasicAuthorization(String username, String password) {
        ProxyManager.setProxyAuthorization(ProxyManager.encodeProxyAuthorization(username, password));
    }

    public static void setProxyAuthorization(String authorization) {
        System.setProperty(LOCAL_PROXY_AUTHORIZATION_PROPERTY, authorization);
    }

    public static String encodeProxyAuthorization(String username, String password) {
        BASE64Encoder encoder = new BASE64Encoder();
        String pwd = username + ":" + password;
        String encodedUserPwd = encoder.encode(pwd.getBytes());
        String authorization = "Basic " + encodedUserPwd;
        return authorization;
    }

    public static void setJVMProxy(String host, String port) {
        System.setProperty(JVM_PROXY_HOST_PROPERTY, host);
        System.setProperty(JVM_PROXY_PORT_PROPERTY, port);
    }

    public static String getProxyHost(AppleServer server) {
        String host;
        String string = host = server != null ? server.getProxyHost() : null;
        if (host != null && host.length() > 0) {
            return host;
        }
        host = System.getProperty(LOCAL_PROXY_HOST_PROPERTY);
        if (host != null && host.length() > 0) {
            return host;
        }
        host = System.getProperty(JVM_PROXY_HOST_PROPERTY);
        if (host != null && host.length() > 0) {
            return host;
        }
        return null;
    }

    public static String getProxyAuthorization(AppleServer server) {
        String authorization;
        String string = authorization = server != null ? server.getProxyAuthorization() : null;
        if (authorization != null && authorization.length() > 0) {
            return authorization;
        }
        authorization = System.getProperty(LOCAL_PROXY_AUTHORIZATION_PROPERTY);
        if (authorization != null && authorization.length() > 0) {
            return authorization;
        }
        authorization = System.getProperty(JVM_PROXY_AUTHORIZATION_PROPERTY);
        if (authorization != null && authorization.length() > 0) {
            return authorization;
        }
        return null;
    }

    public static int getProxyPort(AppleServer server) {
        String host;
        String string = host = server != null ? server.getProxyHost() : null;
        if (host != null && host.length() > 0) {
            return server.getProxyPort();
        }
        host = System.getProperty(LOCAL_PROXY_HOST_PROPERTY);
        if (host != null && host.length() > 0) {
            return Integer.parseInt(System.getProperty(LOCAL_PROXY_PORT_PROPERTY));
        }
        host = System.getProperty(JVM_PROXY_HOST_PROPERTY);
        if (host != null && host.length() > 0) {
            return Integer.parseInt(System.getProperty(JVM_PROXY_PORT_PROPERTY));
        }
        return 0;
    }

    public static boolean isUsingProxy(AppleServer server) {
        String proxyHost = ProxyManager.getProxyHost(server);
        boolean proxyConfigured = proxyHost != null && proxyHost.length() > 0;
        return proxyConfigured;
    }
}

