/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.AddressCodec;
import com.hazelcast.client.impl.protocol.codec.ClientMessageType;
import com.hazelcast.client.impl.protocol.util.ParameterUtil;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.serialization.Data;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;

@SuppressWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
public final class ClientAuthenticationCustomCodec {
    public static final ClientMessageType REQUEST_TYPE = ClientMessageType.CLIENT_AUTHENTICATIONCUSTOM;
    public static final int RESPONSE_TYPE = 109;
    public static final boolean RETRYABLE = true;

    public static ClientMessage encodeRequest(Data credentials, String uuid, String ownerUuid, boolean isOwnerConnection) {
        int requiredDataSize = RequestParameters.calculateDataSize(credentials, uuid, ownerUuid, isOwnerConnection);
        ClientMessage clientMessage = ClientMessage.createForEncode(requiredDataSize);
        clientMessage.setMessageType(REQUEST_TYPE.id());
        clientMessage.setRetryable(true);
        clientMessage.set(credentials);
        if (uuid == null) {
            boolean uuid_isNull = true;
            clientMessage.set(uuid_isNull);
        } else {
            boolean uuid_isNull = false;
            clientMessage.set(uuid_isNull);
            clientMessage.set(uuid);
        }
        if (ownerUuid == null) {
            boolean ownerUuid_isNull = true;
            clientMessage.set(ownerUuid_isNull);
        } else {
            boolean ownerUuid_isNull = false;
            clientMessage.set(ownerUuid_isNull);
            clientMessage.set(ownerUuid);
        }
        clientMessage.set(isOwnerConnection);
        clientMessage.updateFrameLength();
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        boolean isOwnerConnection;
        RequestParameters parameters = new RequestParameters();
        Data credentials = null;
        parameters.credentials = credentials = clientMessage.getData();
        String uuid = null;
        boolean uuid_isNull = clientMessage.getBoolean();
        if (!uuid_isNull) {
            parameters.uuid = uuid = clientMessage.getStringUtf8();
        }
        String ownerUuid = null;
        boolean ownerUuid_isNull = clientMessage.getBoolean();
        if (!ownerUuid_isNull) {
            parameters.ownerUuid = ownerUuid = clientMessage.getStringUtf8();
        }
        parameters.isOwnerConnection = isOwnerConnection = clientMessage.getBoolean();
        return parameters;
    }

    public static ClientMessage encodeResponse(Address address, String uuid, String ownerUuid) {
        int requiredDataSize = ResponseParameters.calculateDataSize(address, uuid, ownerUuid);
        ClientMessage clientMessage = ClientMessage.createForEncode(requiredDataSize);
        clientMessage.setMessageType(109);
        AddressCodec.encode(address, clientMessage);
        clientMessage.set(uuid);
        clientMessage.set(ownerUuid);
        clientMessage.updateFrameLength();
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ResponseParameters parameters = new ResponseParameters();
        Address address = null;
        parameters.address = address = AddressCodec.decode(clientMessage);
        String uuid = null;
        parameters.uuid = uuid = clientMessage.getStringUtf8();
        String ownerUuid = null;
        parameters.ownerUuid = ownerUuid = clientMessage.getStringUtf8();
        return parameters;
    }

    public static class ResponseParameters {
        public Address address;
        public String uuid;
        public String ownerUuid;

        public static int calculateDataSize(Address address, String uuid, String ownerUuid) {
            int dataSize = ClientMessage.HEADER_SIZE;
            dataSize += AddressCodec.calculateDataSize(address);
            dataSize += ParameterUtil.calculateStringDataSize(uuid);
            return dataSize += ParameterUtil.calculateStringDataSize(ownerUuid);
        }
    }

    public static class RequestParameters {
        public static final ClientMessageType TYPE = REQUEST_TYPE;
        public Data credentials;
        public String uuid;
        public String ownerUuid;
        public boolean isOwnerConnection;

        public static int calculateDataSize(Data credentials, String uuid, String ownerUuid, boolean isOwnerConnection) {
            int dataSize = ClientMessage.HEADER_SIZE;
            dataSize += ParameterUtil.calculateDataSize(credentials);
            ++dataSize;
            if (uuid != null) {
                dataSize += ParameterUtil.calculateStringDataSize(uuid);
            }
            ++dataSize;
            if (ownerUuid != null) {
                dataSize += ParameterUtil.calculateStringDataSize(ownerUuid);
            }
            return ++dataSize;
        }
    }
}

