/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jmx;

import com.hazelcast.core.IList;
import com.hazelcast.core.ItemEvent;
import com.hazelcast.core.ItemListener;
import com.hazelcast.jmx.HazelcastMBean;
import com.hazelcast.jmx.ManagedAnnotation;
import com.hazelcast.jmx.ManagedDescription;
import com.hazelcast.jmx.ManagementService;
import com.hazelcast.util.EmptyStatement;
import java.util.concurrent.atomic.AtomicLong;

@ManagedDescription(value="IList")
public class ListMBean
extends HazelcastMBean<IList<?>> {
    private final boolean totalEnabled;
    private AtomicLong totalAddedItemCount = new AtomicLong();
    private AtomicLong totalRemovedItemCount = new AtomicLong();
    private final String registrationId;

    protected ListMBean(IList<?> managedObject, ManagementService service) {
        super(managedObject, service);
        this.totalEnabled = service.instance.node.groupProperties.ENABLE_JMX_DETAILED.getBoolean();
        this.objectName = service.createObjectName("IList", managedObject.getName());
        if (this.totalEnabled) {
            ItemListener itemListener = new ItemListener(){

                public void itemAdded(ItemEvent item) {
                    ListMBean.this.totalAddedItemCount.incrementAndGet();
                }

                public void itemRemoved(ItemEvent item) {
                    ListMBean.this.totalRemovedItemCount.incrementAndGet();
                }
            };
            this.registrationId = managedObject.addItemListener(itemListener, false);
        } else {
            this.registrationId = null;
        }
    }

    @ManagedAnnotation(value="clear", operation=true)
    @ManagedDescription(value="Clear List")
    public void clear() {
        ((IList)this.managedObject).clear();
    }

    @ManagedAnnotation(value="name")
    @ManagedDescription(value="Name of the DistributedObject")
    public String getName() {
        return ((IList)this.managedObject).getName();
    }

    @ManagedAnnotation(value="totalAddedItemCount")
    public long getTotalAddedItemCount() {
        return this.totalAddedItemCount.get();
    }

    @ManagedAnnotation(value="totalRemovedItemCount")
    public long getTotalRemovedItemCount() {
        return this.totalRemovedItemCount.get();
    }

    @Override
    public void preDeregister() throws Exception {
        super.preDeregister();
        if (this.totalEnabled) {
            try {
                ((IList)this.managedObject).removeItemListener(this.registrationId);
            }
            catch (Exception ignored) {
                EmptyStatement.ignore(ignored);
            }
        }
    }
}

