/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl.operationservice.impl;

import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.MemberLeftException;
import com.hazelcast.instance.GroupProperties;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.instance.OutOfMemoryErrorDispatcher;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.partition.ReplicaErrorLogger;
import com.hazelcast.spi.OperationAccessor;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.executionservice.InternalExecutionService;
import com.hazelcast.spi.impl.operationexecutor.OperationHostileThread;
import com.hazelcast.spi.impl.operationservice.impl.CallIdSequence;
import com.hazelcast.spi.impl.operationservice.impl.Invocation;
import com.hazelcast.spi.impl.operationservice.impl.OperationServiceImpl;
import com.hazelcast.spi.impl.operationservice.impl.responses.BackupResponse;
import com.hazelcast.spi.impl.operationservice.impl.responses.CallTimeoutResponse;
import com.hazelcast.spi.impl.operationservice.impl.responses.ErrorResponse;
import com.hazelcast.spi.impl.operationservice.impl.responses.NormalResponse;
import com.hazelcast.spi.impl.operationservice.impl.responses.Response;
import com.hazelcast.util.Clock;
import com.hazelcast.util.EmptyStatement;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;

public class InvocationRegistry {
    private static final long SCHEDULE_DELAY = 1111L;
    private static final int INITIAL_CAPACITY = 1000;
    private static final float LOAD_FACTOR = 0.75f;
    private static final int DELAY_MILLIS = 1000;
    private static final double HUNDRED_PERCENT = 100.0;
    private final long backupTimeoutMillis;
    private final ConcurrentMap<Long, Invocation> invocations;
    private final OperationServiceImpl operationService;
    private final NodeEngineImpl nodeEngine;
    private final ILogger logger;
    private final InspectionThread inspectionThread;
    private final CallIdSequence callIdSequence;
    private final long slowInvocationThresholdMs;

    public InvocationRegistry(OperationServiceImpl operationService, int concurrencyLevel) {
        this.operationService = operationService;
        this.nodeEngine = operationService.nodeEngine;
        this.logger = operationService.logger;
        this.callIdSequence = operationService.backpressureRegulator.newCallIdSequence();
        GroupProperties props = operationService.nodeEngine.getGroupProperties();
        this.slowInvocationThresholdMs = this.initSlowInvocationThresholdMs(props);
        this.backupTimeoutMillis = props.OPERATION_BACKUP_TIMEOUT_MILLIS.getLong();
        this.invocations = new ConcurrentHashMap<Long, Invocation>(1000, 0.75f, concurrencyLevel);
        this.inspectionThread = new InspectionThread();
        this.inspectionThread.start();
    }

    private long initSlowInvocationThresholdMs(GroupProperties props) {
        long thresholdMs = props.SLOW_INVOCATION_DETECTOR_THRESHOLD_MILLIS.getLong();
        if (thresholdMs > -1L) {
            this.logger.info("Slow invocation detector enabled, using threshold: " + thresholdMs + " ms");
        }
        return thresholdMs;
    }

    public long getLastCallId() {
        return this.callIdSequence.getLastCallId();
    }

    public void register(Invocation invocation) {
        assert (invocation.op.getCallId() == 0L) : "can't register twice:" + invocation;
        long callId = this.callIdSequence.next(invocation);
        OperationAccessor.setCallId(invocation.op, callId);
        if (callId == Long.MAX_VALUE) {
            return;
        }
        this.invocations.put(callId, invocation);
    }

    public void deregister(Invocation invocation) {
        boolean deleted;
        long callId = invocation.op.getCallId();
        this.callIdSequence.complete(invocation);
        OperationAccessor.setCallId(invocation.op, 0L);
        if (callId == 0L || callId == Long.MAX_VALUE) {
            return;
        }
        boolean bl = deleted = this.invocations.remove(callId) != null;
        assert (deleted) : "failed to deregister callId:" + callId + " " + invocation;
    }

    public double getInvocationUsagePercentage() {
        return 100.0 * (double)this.invocations.size() / (double)this.callIdSequence.getMaxConcurrentInvocations();
    }

    public int size() {
        return this.invocations.size();
    }

    public Invocation get(long callId) {
        return (Invocation)this.invocations.get(callId);
    }

    public void notify(Response response) {
        if (response instanceof NormalResponse) {
            this.notifyNormalResponse((NormalResponse)response);
        } else if (response instanceof BackupResponse) {
            this.notifyBackupComplete(response.getCallId());
        } else if (response instanceof CallTimeoutResponse) {
            this.notifyCallTimeout((CallTimeoutResponse)response);
        } else if (response instanceof ErrorResponse) {
            this.notifyErrorResponse((ErrorResponse)response);
        } else {
            this.logger.severe("Unrecognized response: " + response);
        }
    }

    public void notifyBackupComplete(long callId) {
        try {
            Invocation invocation = (Invocation)this.invocations.get(callId);
            if (invocation == null) {
                if (this.logger.isFinestEnabled()) {
                    this.logger.finest("No Invocation found for BackupResponse with callId " + callId);
                }
                return;
            }
            invocation.notifySingleBackupComplete();
        }
        catch (Exception e) {
            ReplicaErrorLogger.log(e, this.logger);
        }
    }

    private void notifyErrorResponse(ErrorResponse response) {
        Invocation invocation = (Invocation)this.invocations.get(response.getCallId());
        if (invocation == null) {
            if (this.nodeEngine.isActive()) {
                this.logger.warning("No Invocation found for response: " + response);
            }
            return;
        }
        invocation.notifyError(response.getCause());
    }

    private void notifyNormalResponse(NormalResponse response) {
        Invocation invocation = (Invocation)this.invocations.get(response.getCallId());
        if (invocation == null) {
            if (this.nodeEngine.isActive()) {
                this.logger.warning("No Invocation found for response: " + response);
            }
            return;
        }
        invocation.notifyNormalResponse(response.getValue(), response.getBackupCount());
    }

    private void notifyCallTimeout(CallTimeoutResponse response) {
        Invocation invocation = (Invocation)this.invocations.get(response.getCallId());
        if (invocation == null) {
            if (this.nodeEngine.isActive()) {
                this.logger.warning("No Invocation found for response: " + response);
            }
            return;
        }
        invocation.notifyCallTimeout();
    }

    public void onMemberLeft(MemberImpl member) {
        InternalExecutionService executionService = this.nodeEngine.getExecutionService();
        OnMemberLeftTask task = new OnMemberLeftTask(member);
        executionService.schedule(task, 1111L, TimeUnit.MILLISECONDS);
    }

    public void reset() {
        for (Invocation invocation : this.invocations.values()) {
            try {
                invocation.notifyError(new MemberLeftException());
            }
            catch (Throwable e) {
                this.logger.warning(invocation + " could not be notified with reset message -> " + e.getMessage());
            }
        }
    }

    public void shutdown() {
        this.inspectionThread.shutdown();
        for (Invocation invocation : this.invocations.values()) {
            try {
                invocation.notifyError(new HazelcastInstanceNotActiveException());
            }
            catch (Throwable e) {
                this.logger.warning(invocation + " could not be notified with shutdown message -> " + e.getMessage(), e);
            }
        }
    }

    public void awaitTermination(long timeoutMillis) throws InterruptedException {
        this.inspectionThread.join(timeoutMillis);
    }

    public Collection<Invocation> invocations() {
        return this.invocations.values();
    }

    private class OnMemberLeftTask
    implements Runnable {
        private final MemberImpl leftMember;

        public OnMemberLeftTask(MemberImpl leftMember) {
            this.leftMember = leftMember;
        }

        @Override
        public void run() {
            for (Invocation invocation : InvocationRegistry.this.invocations.values()) {
                if (!this.hasMemberLeft(invocation)) continue;
                invocation.notifyError(new MemberLeftException(this.leftMember));
            }
        }

        private boolean hasMemberLeft(Invocation invocation) {
            MemberImpl targetMember = invocation.targetMember;
            if (targetMember == null) {
                Address invTarget = invocation.invTarget;
                return this.leftMember.getAddress().equals(invTarget);
            }
            return this.leftMember.getUuid().equals(targetMember.getUuid());
        }
    }

    class InspectionThread
    extends Thread
    implements OperationHostileThread {
        private volatile boolean shutdown;

        InspectionThread() {
            super(((InvocationRegistry)InvocationRegistry.this).operationService.node.getHazelcastThreadGroup().getThreadNamePrefix("InspectInvocationsThread"));
        }

        public void shutdown() {
            this.shutdown = true;
            this.interrupt();
        }

        @Override
        public void run() {
            try {
                while (!this.shutdown) {
                    this.scanHandleOperationTimeout();
                    if (this.shutdown) continue;
                    this.sleep();
                }
            }
            catch (Throwable t) {
                OutOfMemoryErrorDispatcher.inspectOutputMemoryError(t);
                ((InvocationRegistry)InvocationRegistry.this).operationService.logger.severe("Failed to run", t);
            }
        }

        private void sleep() {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ignore) {
                EmptyStatement.ignore(ignore);
            }
        }

        private void scanHandleOperationTimeout() {
            if (InvocationRegistry.this.invocations.isEmpty()) {
                return;
            }
            long now = Clock.currentTimeMillis();
            int backupTimeouts = 0;
            int invocationTimeouts = 0;
            Iterator iterator = InvocationRegistry.this.invocations.entrySet().iterator();
            while (iterator.hasNext()) {
                if (this.shutdown) {
                    return;
                }
                Map.Entry entry = iterator.next();
                Long callId = (Long)entry.getKey();
                Invocation invocation = (Invocation)entry.getValue();
                if (!this.callIdMatches(callId, invocation) && this.isInvocationDone(invocation)) {
                    iterator.remove();
                    continue;
                }
                this.detectSlowInvocation(now, invocation);
                if (this.checkInvocationTimeout(invocation)) {
                    ++invocationTimeouts;
                }
                if (!this.checkBackupTimeout(invocation)) continue;
                ++backupTimeouts;
            }
            this.log(backupTimeouts, invocationTimeouts);
        }

        private boolean callIdMatches(long callId, Invocation invocation) {
            return callId == invocation.op.getCallId();
        }

        private boolean isInvocationDone(Invocation invocation) {
            return invocation.invocationFuture.isDone();
        }

        private void detectSlowInvocation(long now, Invocation invocation) {
            long durationMs;
            if (InvocationRegistry.this.slowInvocationThresholdMs > 0L && (durationMs = now - invocation.op.getInvocationTime()) > InvocationRegistry.this.slowInvocationThresholdMs) {
                InvocationRegistry.this.logger.info("Slow invocation: duration=" + durationMs + " ms, operation=" + invocation.op.getClass().getName() + " inv:" + invocation);
            }
        }

        private boolean checkInvocationTimeout(Invocation invocation) {
            try {
                return invocation.checkInvocationTimeout();
            }
            catch (Throwable t) {
                OutOfMemoryErrorDispatcher.inspectOutputMemoryError(t);
                InvocationRegistry.this.logger.severe("Failed to handle operation timeout of invocation:" + invocation, t);
                return false;
            }
        }

        private boolean checkBackupTimeout(Invocation invocation) {
            try {
                return invocation.checkBackupTimeout(InvocationRegistry.this.backupTimeoutMillis);
            }
            catch (Throwable t) {
                OutOfMemoryErrorDispatcher.inspectOutputMemoryError(t);
                InvocationRegistry.this.logger.severe("Failed to handle backup timeout of invocation:" + invocation, t);
                return false;
            }
        }

        private void log(int backupTimeouts, int invocationTimeouts) {
            if (backupTimeouts > 0 || invocationTimeouts > 0) {
                InvocationRegistry.this.logger.info("Handled " + invocationTimeouts + " invocation timeouts and " + backupTimeouts + " backupTimeouts");
            }
        }
    }
}

